unit StructsUnit;
{-------------------------------------------------------------------------------
Structures Unit

Contains:
  Common data structures used across the compressor and related test files.

resource (C) 1998, 1999 Victor Kasenda / gruv
http://members.tripod.com/~gruv/resource

-------------------------------------------------------------------------------}

(**) interface (**)

const
  //BlockSize = 500; {bytes}
  BlockSize = 400 * 1024; {kilobytes}
  //BlockSize = 2 * 1024 * 1000;  {megabytes}

  GHOST_BUFFER = 2000; // for overshoot, only for block (see FSortUnit)

  {Run Length encoding may expand the block by a few bytes.
  If run length encoding before sorting is not performed, this can be set to 0}
  RLE_EXPAND_EXTRA_BYTES = 0; {BLOCKSIZE * 20 DIV 100;  {20% of BlockSize}
  //RLE_EXPAND_EXTRA_BYTES = 10000;  {20% of BlockSize}

  MaxLongword = high(Longword);

  {String constants}
  SRESOURCE_EXT = 'rs';

type

  {Block with ghost buffers at the front (1 byte) and back (5 bytes)
  Extra 1000 bytes in case RLEncoder expands the block}
  TBlock = array[-1..BlockSize*2 + GHOST_BUFFER + RLE_EXPAND_EXTRA_BYTES] of byte;
  PBlock = ^TBlock;

  TLongintBlock = array[0..BlockSize-1 + 1000 + RLE_EXPAND_EXTRA_BYTES] of longint;
  PLongintBlock = ^TLongintBlock;

  TLongWordBlock = array[0..BlockSize * 2 + GHOST_BUFFER + RLE_EXPAND_EXTRA_BYTES] of Longword;
  PLongWordBlock = ^TLongwordBlock;

  PWord = ^Word;

  T64kBlock = array[0..65535] of longint;
  P64kBlock = ^T64kBlock;


  TBlockMan = class
  public
    // common blocks. shared memory blocks between compressor and expander
    // call InitBlocks, FreeBlocks to use
    longintblock1, longintblock2, longintblock3: PLongintblock;
    block1, block2: PBlock;
    k64Block: P64kBlock;

    constructor Create;
    destructor Destroy; override;
  end;

  procedure CompareBlocks(const block1, block2: PBlock; const block_length: longint;
                              error_msg: string);

var
  BlockMan: TBlockMan;
  

(**) implementation (**)
uses ErrorUnit, SysUtils;

constructor TBlockMan.Create;
begin
  inherited Create;
  New(longintblock1);
  New(longintblock2);
  New(longintblock3);
  New(block1);
  New(block2);
  New(k64Block);
end;

destructor TBlockMan.Destroy;
begin
  inherited Destroy;
end;

procedure CompareBlocks(const block1, block2: PBlock; const block_length: longint;
                              error_msg: string);
var
  i: longint;
begin
  for i := 0 to block_length-1 do
     if block1^[i] <> block2^[i] then
     begin
       if error_msg = '' then error_msg := 'block1 differs from block2 at ';
       ShowError(error_msg + ' position: ' + IntToStr(i));
       break;
     end;
end;

initialization
  BlockMan := TBlockMan.Create;
finalization
  BlockMan.Free;
end.
