unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses StructsUnit, OFile, RLEUnit;


{$R *.DFM}


const
  OrigFilePath = 'c:\ctest\RLEr.txt';       // path of the file to encode
  EncodedFilePath = 'c:\ctest\RLEout.txt';  // path of the encoded output
  DecodedFilePath = 'c:\ctest\RLEr2.txt';   // path of the decoded output

  {
    To check for reliability of RLE algorithm:
    The content and length of both RLEr.txt and RLEr2.txt are the same.
  }



procedure RunEncodeTest;
var
  infile, outfile: TOFile;
  bytes_read: longint;
  block: PBlock;
  out_block: PBlock;
  RunLengthEncoder: TRunLengthEncoder;
  out_block_length: longint;

begin
  New(block);
  New(out_block);

  infile := TOFile.create(OrigFilePath);
  infile.ResetReadOnly(1);

  outfile := TOFile.create(EncodedFilePath);
  outfile.Rewrite(1);

  RunLengthEncoder := TRunLengthEncoder.create;

  bytes_read := infile.BlockRead(block^[0], BlockSize);
  RunLengthEncoder.EncodeBlock(out_block, block, bytes_read, out_block_length);
  outfile.BlockWrite(out_block^[0], out_block_length);

  RunLengthEncoder.free;


  infile.free;
  outfile.free;
  Dispose(out_block);
  Dispose(block);
end;


procedure RunDecodeTest;
var
  infile, outfile: TOFile;
  bytes_read: longint;
  in_block, out_block: PBlock;
  out_block_length: longint;
  RunLengthDecoder: TRunLengthDecoder;
  
begin
  New(in_block);
  New(out_block);

  infile := TOFile.create(EncodedFilePath);
  infile.ResetReadOnly(1);

  outfile := TOFile.create(DecodedFilePath);
  outfile.Rewrite(1);

  RunLengthDecoder := TRunLengthDecoder.create;

  bytes_read := infile.BlockRead(in_block^[0], BlockSize);
  RunLengthDecoder.DecodeBlock(out_block, in_block, bytes_read, out_block_length);
  outfile.BlockWrite(out_block^[0], out_block_length);

  RunLengthDecoder.free;

  infile.free;
  outfile.free;
  Dispose(out_block);
  Dispose(in_block);
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
  RunEncodeTest;
  RunDecodeTest;
  Application.Terminate;
end;

end.
