unit ProgStatsDlgUnit;
{-------------------------------------------------------------------------------
  Program Statistics Dialog
  -------------------------
  show program statistics

  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

  Use:
  To check if memory is enough, or if we are out of memory.
  To help in debugging if the user reports a bug to the developer.
-------------------------------------------------------------------------------}


(**) interface (**)

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TProgStatsDlg = class(TForm)
    RichEdit: TRichEdit;
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ProgStatsDlg: TProgStatsDlg;

(**) implementation (**)
uses Main, StructsUnit;

{$R *.DFM}

procedure TProgStatsDlg.FormShow(Sender: TObject);
var
  HeapStatus: THeapStatus;
begin
  CentreFormToMain(Self);

  // fill in the program stats richedit
  HeapStatus := GetHeapStatus;
  with RichEdit.Lines, RichEdit, HeapStatus do
  begin
    Clear;
    Add('Engine:');
    Add('Block Size = ' + IntToStr(BlockSize));
    Add('');
    Add('Program:');
    Add('rs Total Allocated = ' + IntToStr(TotalAllocated));
    Add('Heap manager overhead = ' + IntToStr(Overhead));
    Add('');
    Add('System:');
    Add('Win Total Address Space = ' + IntToStr(TotalAddrSpace));
    Add('Win Total Uncommitted = ' + IntToStr(TotalUncommitted));
    SelStart := 0;
  end;
end;




end.
