unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses MTFUnit, StructsUnit, OFile;

{$R *.DFM}


const
  OrigFilePath = 'c:\ctest\MTFr.txt';       // path of the file to encode
  EncodedFilePath = 'c:\ctest\MTFout.txt';  // path of the encoded output
  DecodedFilePath = 'c:\ctest\MTFr2.txt';   // path of the decoded output

  {
    To check for reliability of MTF algorithm:
    The content and length of both MTFr.txt and MTFr2.txt are the same.
  }



procedure RunEncodeTest;
var
  infile, outfile: TOFile;
  bytes_read: longint;
  block: PBlock;
  mtf_block: PBlock;

  procedure EncodeBlock;
  var
    MTFEncoder: TMTFEncoder;
    i: longint;
  begin
    MTFEncoder := TMTFEncoder.create;
    for i := 0 to bytes_read-1 do
    begin
      mtf_block^[i] := MTFEncoder.Encode(block^[i]);
    end;
    MTFEncoder.free;
  end;

begin
  New(block);
  New(mtf_block);

  infile := TOFile.create(OrigFilePath);
  infile.ResetReadOnly(1);

  outfile := TOFile.create(EncodedFilePath);
  outfile.Rewrite(1);

  bytes_read := infile.BlockRead(block^, BlockSize);
  while bytes_read > 0 do
  begin
    EncodeBlock;
    outfile.BlockWrite(mtf_block^, bytes_read);
    bytes_read := infile.BlockRead(block^, BlockSize);
  end;


  infile.free;
  outfile.free;
  Dispose(mtf_block);
  Dispose(block);
end;




procedure RunDecodeTest;
var
  infile, outfile: TOFile;
  bytes_read: longint;
  block: PBlock;
  mtf_block: PBlock;

  procedure DecodeBlock;
  var
    MTFDecoder: TMTFDecoder;
    i: longint;
  begin
    MTFDecoder := TMTFDecoder.create;
    for i := 0 to bytes_read-1 do
    begin
      block^[i] := MTFDecoder.decode(mtf_block^[i]);
    end;
    MTFDecoder.free;
  end;

begin
  New(block);
  New(mtf_block);

  infile := TOFile.create(EncodedFilePath);
  infile.ResetReadOnly(1);

  outfile := TOFile.create(DecodedFilePath);
  outfile.Rewrite(1);

  bytes_read := infile.BlockRead(mtf_block^, BlockSize);
  while bytes_read > 0 do
  begin
    DecodeBlock;
    outfile.BlockWrite(block^, bytes_read);
    bytes_read := infile.BlockRead(mtf_block^, BlockSize);
  end;

  Dispose(mtf_block);
  Dispose(block);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  RunEncodeTest;
  RunDecodeTest;
  Application.Terminate;
end;

end.
