unit MTFEncoderUnit;
{-------------------------------------------------------------------------------
  Move To Front Encoder
  ---------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource
-------------------------------------------------------------------------------}

(**) interface (**)
uses StructsUnit, MTFBaseUnit;

type
  TMTFEncoder = class(TMTFBase)
  public
    procedure EncodeBlock(const inblock, outblock: PBlock; const block_length: longint);
    function Encode(const s: byte): byte;
  private
  end;


(**) implementation (**)

////////////////////////////////////////////////////////////////////////////////
// TMTFEncoder
////////////////////////////////////////////////////////////////////////////////

{-------------------------------------------------------------------------------
  Encode
  ------
  Return symbol's current position then move it to the front
-------------------------------------------------------------------------------}

function TMTFEncoder.Encode(const s: byte): byte;
begin
  result := map[s];
  MoveToFront(s);
end;

procedure TMTFEncoder.EncodeBlock;
var
  i: longint;
begin
  for i := 0 to block_length-1 do
    outblock^[i] := Encode(inblock^[i]);
end;


end.
