unit MTFDecoderUnit;
{-------------------------------------------------------------------------------
  Move To Front Decoder
  ---------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource
  
  Notes: For manual decoding, call init then decode.
-------------------------------------------------------------------------------}

(**) interface (**)
uses StructsUnit, MTFBaseUnit;

type
  TMTFDecoder = class(TMTFBase)
  public
    function Decode(const posn: byte): byte;
    {procedure DecodeBlock(const inblock, outblock: PBlock; const block_length: longint);
    procedure DecodeBlockWithVirtualChar(const inblock, outblock: PBlock; var block_length: longint; const virtual_char_index: longint);}
  private
  end;


(**) implementation (**)
uses ErrorUnit;

////////////////////////////////////////////////////////////////////////////////
// TMTFDecoder
////////////////////////////////////////////////////////////////////////////////

{-------------------------------------------------------------------------------
  Decode
  ------
  given its position posn, return a symbol and update the decoder
-------------------------------------------------------------------------------}

function TMTFDecoder.Decode(const posn: byte): byte;
begin
  result := image[posn];
  MoveToFront(result);
end;

(*
procedure TMTFDecoder.DecodeBlock;
var
  i: longint;
begin
  for i := 0 to block_length-1 do
    outblock^[i] := Decode(inblock^[i]);
end;

procedure TMTFDecoder.DecodeBlockWithVirtualChar(const inblock, outblock: PBlock; var block_length: longint; const virtual_char_index: longint);
var
  i, j: longint;
begin
  // Error Check. virtual_char_index < block_length
  if (virtual_char_index > block_length) then
  begin
    ShowError('Warning: Virtual char index wrong.');
    exit;
  end;

  // i: outblock index
  // j: inblock index
  i := 0;
  j := 0;

  while (i < virtual_char_index) do
  begin
    outblock[i] := Decode(inblock[j]);
    inc(i);
    inc(j);
  end;

  inc(i);  // leave one char in outblock for virtual char

  while (j < block_length) do
  begin
    outblock[i] := Decode(inblock[j]);
    inc(i);
    inc(j);
  end;


  // add one to the block length because the virtual char was added
  // outblock is now 1 char greater
  inc(block_length);
end;
*)

end.
