unit FileAttrDlgUnit;
{-------------------------------------------------------------------------------
  File Attribute Dialog Unit
  --------------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

  Interface for the user to change the file attributes in the archive.
-------------------------------------------------------------------------------}


(**) interface (**)

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons,
  ArchiveHeadersUnit;

type
  TFileAttrDlg = class(TForm)
    NameEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    XBReadOnly: TCheckBox;
    XBHidden: TCheckBox;
    XBArchive: TCheckBox;
    XBSystem: TCheckBox;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    LastModifiedDateLabel: TLabel;
    Label3: TLabel;
    SizeLabel: TLabel;
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function Execute(CentralFileHeader: TCentralFileHeader): integer;
    procedure GetCentralFileHeader(CentralFileHeader: TCentralFileHeader);
  end;

var
  FileAttrDlg: TFileAttrDlg;

(**) implementation (**)
uses Main;

{$R *.DFM}


function TFileAttrDlg.Execute(CentralFileHeader: TCentralFileHeader): integer;
var
  s: string;
begin
  // initialize fields with info from CentralFileHeader
  with CentralFileHeader do
  begin
    // name
    NameEdit.Text := FileName;
    // size
    SizeLabel.Caption := Format('%d', [uncompressed_size]) + ' bytes';
    // date
    DateTimeToString(s, 'dddd, mmmm d, yyyy hh:nn:ss AM/PM', FileDateToDateTime(time));
    LastModifiedDateLabel.Caption := s;
    // attributes
    XBReadOnly.Checked := (attr and faReadOnly <> 0);
    XBArchive.Checked := (attr and faArchive <> 0);
    XBHidden.Checked := (attr and faHidden <> 0);
    XBSystem.Checked := (attr and faSysFile <> 0);
  end;
  result := ShowModal;
end;

{-------------------------------------------------------------------------------
  GetCentralFileHeader
  --------------------

  Updates CentralFileHeader with the data in the dialog
-------------------------------------------------------------------------------}
procedure TFileAttrDlg.GetCentralFileHeader(CentralFileHeader: TCentralFileHeader);
var
  nattr: integer;
begin
  // store new attribute in nattr
  nattr := 0;
  if (XBReadOnly.Checked) then nattr := nattr or faReadOnly;
  if (XBArchive.Checked) then nattr := nattr or faArchive;
  if (XBHidden.Checked) then nattr := nattr or faHidden;
  if (XBSystem.Checked) then nattr := nattr or faSysFile;

  with CentralFileHeader do
  begin
    FileName := NameEdit.Text;
    attr := nattr;
  end;
end;


procedure TFileAttrDlg.FormShow(Sender: TObject);
begin
  CentreFormToMain(Self);
end;

end.
