unit FileAriEncoderUnit;
{-------------------------------------------------------------------------------
  DEFUNCT. USE THE STRUCTURED ENCODER.

  FileAriEncoderUnit
  ------------------
  reSource (C) 1998 Victor K /97S66

  To Use:
  Create it. Pass a working model.
  Call EncodeBlock.
  Free.
-------------------------------------------------------------------------------}


(**) interface (**)
uses // general
     StructsUnit,
     // base class
     AriEncoderUnit, AriModelUnit, ArchiveFileUnit;

type
  TFileAriEncoder = class(TAriEncoder)
  protected
    ArchiveFile: TArchiveFile;
    procedure OutputBit(bit: byte); override;
    procedure OutputBits(code: longint; count: byte); override;

  public
    constructor Create(_ArchiveFile: TArchiveFile; AriModel :TAriModel);
    destructor Destroy; override;

    procedure EncodeBlock(block: PBlock; block_length: integer);
  end;

(**) implementation (**)

constructor TFileAriEncoder.Create(_ArchiveFile: TArchiveFile; AriModel :TAriModel);
begin
  inherited Create(AriModel);
  ArchiveFile := _ArchiveFile;
  ArchiveFile.BeginBitWriteAccess;
end;

destructor TFileAriEncoder.Destroy;
begin
  ArchiveFile.EndBitWriteAccess;
  //ArchiveFile.ResetBuffer;
  inherited Destroy;
end;

procedure TFileAriEncoder.OutputBit(bit: byte);
begin
  ArchiveFile.OutputBit(bit);
end;

procedure TFileAriEncoder.OutputBits(code: longint; count: byte);
begin
  ArchiveFile.OutputBits(code, count);
end;

procedure TFileAriEncoder.EncodeBlock(block: PBlock; block_length: integer);
var
  i: longint;
begin
  StartEncoding;
  for i := 0 to block_length - 1 do
    EncodeByte(block^[i]);

  EncodeSymbol(EOF_SYMBOL);
  DoneEncoding;
end;



end.
