unit FileAriDecoderUnit;
{-------------------------------------------------------------------------------
  DEFUNCT. USE THE STRUCTURED DECODER.

  FileAriDecoderUnit
  ------------------
  reSource (C) 1998 Victor K /97S66

  To use:
  Create the class.
  Call DecodeBlock.
  Free.


  DecodeBlock
  Decode from file to block. returns the block length in block_length.
-------------------------------------------------------------------------------}


(**) interface (**)
uses StructsUnit,
     AriDecoderUnit, AriModelUnit, ArchiveFileUnit;

type
  TFileAriDecoder = class(TAriDecoder)
  protected
    ArchiveFile: TArchiveFile;
    function  InputBit: byte; override;
    function  InputBits( count: byte ): longint; override;
  public
    constructor Create(_ArchiveFile: TArchiveFile; _AriModel: TAriModel);
    destructor Destroy; override;
    procedure DecodeBlock(block: PBlock; var block_length: integer);
  end;


(**) implementation (**)

constructor TFileAriDecoder.Create(_ArchiveFile: TArchiveFile; _AriModel: TAriModel);
begin
  inherited Create(_AriModel);
  ArchiveFile := _ArchiveFile;
  ArchiveFile.BeginBitReadAccess;
end;

destructor TFileAriDecoder.Destroy;
begin
  ArchiveFile.EndBitReadAccess;
  inherited Destroy;
end;

function  TFileAriDecoder.InputBit: byte;
begin
  result := ArchiveFile.InputBit;
end;

function  TFileAriDecoder.InputBits( count: byte ): longint;
begin
  result := ArchiveFile.InputBits(count);
end;

procedure TFileAriDecoder.DecodeBlock(block: PBlock; var block_length: integer);
var
  i: longint;
  symbol: integer;
  ch: byte;
begin
  StartDecoding;

  i := 0;
  repeat
    DecodeSymbol(symbol, ch);
    if (symbol = EOF_SYMBOL) then break;
    block^[i] := ch;
    inc(i);
  until false;

  block_length := i;

  DoneDecoding;
end;

end.
