unit FClasses;
{-------------------------------------------------------------------------------
  F-Classes unit
  Supplement to the classes unit

  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

  contains: TObjList

  TObjList
  --------
  Frees up the memory for its items.
  All items assumed to be of TObject type.
-------------------------------------------------------------------------------}

(**) interface (**)
uses classes, Forms;

type
  TObjList = class(TList)
  public
    destructor Destroy; override;
    procedure Clear; override;
    procedure Delete(Index: Integer);
  end;

(**) implementation (**)


destructor TObjList.Destroy;
begin
  Clear;
  inherited Destroy;
end;

procedure TObjList.Clear;
var
  i: integer;
begin
  {Free every entry in the list first}
  for i := Count-1 downto 0 do
    TObject(items[i]).Free;
  inherited Clear;
end;

procedure TObjList.Delete(Index: Integer);
begin
  TObject(items[Index]).Free;
  inherited Delete(Index);
end;


end.
