unit ExtractOptionsDlgUnit;
{-------------------------------------------------------------------------------
  ExtractOptionsDlgUnit
  ---------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource


  Desc:
  Shows a directory list that allows the user to select the directory
  to extract to.

-------------------------------------------------------------------------------}

{  if not EDos.FileExists(DriveComboBox.drive + ':') then
  begin
    Application.MessageBox(PChar('The drive ' + DriveComboBox.drive + ' is not available. Please select another drive.'),
                           'IO Error', 0);

  end;}


(**) interface (**)

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, FileCtrl, ComCtrls, Dialogs;

type
  TExtractOptionsDlg = class(TForm)
    GroupBox1: TGroupBox;
    RBExtractAllFiles: TRadioButton;
    RBExtractSelectedFiles: TRadioButton;
    Label1: TLabel;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    DirTree: TDirectoryListBox;
    DriveComboBox: TDriveComboBox;
    procedure DirectoryListBoxChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private

  public
    function ExtractDir: string;
  end;

var
  ExtractOptionsDlg: TExtractOptionsDlg;

(**) implementation (**)
uses EDosUnit, Main;

{$R *.DFM}


function TExtractOptionsDlg.ExtractDir: string;
begin
  result := DirTree.Directory;
  EDos.AddSlash(result);
end;

procedure TExtractOptionsDlg.DirectoryListBoxChange(Sender: TObject);
begin
  //ExtractDirEdit.Text := DirectoryListBox.Directory;
end;

procedure TExtractOptionsDlg.FormActivate(Sender: TObject);
begin
  //ExtractDirEdit.Text := DirectoryListBox.Directory;
end;

procedure TExtractOptionsDlg.FormCreate(Sender: TObject);
begin
  {$IFDEF DEBUG}
  //DirTree.Directory := 'c:\ctestout';
  {$ENDIF}
end;

procedure TExtractOptionsDlg.FormShow(Sender: TObject);
begin
  CentreFormToMain(Self);
end;

end.

