unit DebugFormUnit;
{-------------------------------------------------------------------------------
  DebugFormUnit
  -------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

  Desc:
  Currently defunct.
  Used for showing the status or stage of the compression. Useful to detect
  for stalls or 'hangs' that may occur (and many did).
-------------------------------------------------------------------------------}


(**) interface (**)

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TDebugForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ArrowImage: TImage;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }

    procedure DoingSorting;
    procedure DoingMTF;
    procedure DoingTransform;
    procedure DoingAriCompress;
  end;

var
  DebugForm: TDebugForm;

(**) implementation (**)
uses ConfigUnit;

{$R *.DFM}


const
  ArrowInitialTop = 15;
  ArrowMoveHeight = 25;


procedure TDebugForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  DebugForm := nil;
  ConfigMan.ShowDebugForm := false;
end;

procedure TDebugForm.DoingSorting;
begin
  ArrowImage.Top := ArrowInitialTop;
  Application.ProcessMessages;
end;

procedure TDebugForm.DoingTransform;
begin
  ArrowImage.Top := ArrowInitialTop + ArrowMoveHeight;
  Application.ProcessMessages;
end;

procedure TDebugForm.DoingMTF;
begin
  ArrowImage.Top := ArrowInitialTop + ArrowMoveHeight*2;
  Application.ProcessMessages;
end;

procedure TDebugForm.DoingAriCompress;
begin
  ArrowImage.Top := ArrowInitialTop + ArrowMoveHeight*3;
  Application.ProcessMessages;
end;



end.
