unit ConfigUnit;
{-------------------------------------------------------------------------------
  Configuration Unit
  ------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

  Desc:
  All configurable variables are stored in the ConfigMan class.
  The user uses the interface, ConfigDlg to change these values.

-------------------------------------------------------------------------------}

(**) interface (**)
uses SysUtils, Windows;


type
  TConfigMan = class
  private
    FShowDebugForm: boolean;
    procedure EnableDebugForm(enable: boolean);
    
  public
    ClipDebugFormToMainForm: boolean;

    temp_dir: string;
    default_temp_dir: string;

    confirm_on_delete: boolean;
    property ShowDebugForm: boolean read FShowDebugForm write EnableDebugForm;

    constructor Create;
    procedure ResetDefaults;
  end;

var
  ConfigMan: TConfigMan;


(**) implementation (**)
uses DebugFormUnit, EDosUnit;

constructor TConfigMan.Create;
begin
  inherited Create;
  ResetDefaults;
end;


procedure TConfigMan.ResetDefaults;
var
  dir: PChar;
begin
  ShowDebugForm := false;
  ClipDebugFormToMainForm := true;

  // get the windows default temp dir
  dir := StrAlloc(MAX_PATH + 1);
  GetTempPath(MAX_PATH, dir);
  default_temp_dir := dir;
  StrDispose(dir);
  EDos.AddSlash(default_temp_dir);
  temp_dir := default_temp_dir;

  confirm_on_delete := false;
end;

procedure TConfigMan.EnableDebugForm(enable: boolean);
begin
  FShowDebugForm := enable;
  if (enable = false) then
  begin
    if Assigned(DebugForm) then
    begin
      DebugForm.Free;
      DebugForm := nil;
    end;
  end
  else
  begin
    DebugForm := TDebugForm.Create(nil);
    DebugForm.Show;
  end;
end;

initialization
  ConfigMan := TConfigMan.Create;
finalization
  ConfigMan.Free;
end.
