unit ConfigDlgUnit;
{-------------------------------------------------------------------------------
  Configuration Dialog Unit
  -------------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

  Desc:
  The interface for ConfigMan.
  Anything that is configurable by the user is exposed through ConfigDlg
  It will also check if the input is valid.
-------------------------------------------------------------------------------}


(**) interface (**)

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls;

type
  TConfigDlg = class(TForm)
    PageControl: TPageControl;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    TabSheet1: TTabSheet;
    GroupBox1: TGroupBox;
    RBUseWindowsDefaultTempDir: TRadioButton;
    RBUseCustomTempDir: TRadioButton;
    WinDefTempDirLabel: TLabel;
    TabSheet2: TTabSheet;
    GroupBox2: TGroupBox;
    XBConfirmOnDelete: TCheckBox;
    CustomTempDirBtn: TBitBtn;
    CustomTempDirLabel: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure CustomTempDirBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
  public

  end;

var
  ConfigDlg: TConfigDlg;

(**) implementation (**)
uses ConfigUnit, BrowseForDirUnit, EDosUnit, Main;

{$R *.DFM}


{-------------------------------------------------------------------------------
FormActivate
------------
Init all the fields with their respective data from ConfigMan.
-------------------------------------------------------------------------------}
procedure TConfigDlg.FormActivate(Sender: TObject);
begin
  // read in the config from ConfigMan
  with ConfigMan do
  begin
    // temporary directory
    WinDefTempDirLabel.Caption := ConfigMan.default_temp_dir;
    if (temp_dir = default_temp_dir) then
      RBUseWindowsDefaultTempDir.Checked := true
    else
    begin
      RBUseCustomTempDir.Checked := true;
      CustomTempDirLabel.Caption := temp_dir;
    end;

    // confirmation
    XBConfirmOnDelete.Checked := confirm_on_delete;
  end;
end;

{-------------------------------------------------------------------------------
CustomTempDirBtnClick
---------------------
Let the user choose their own cutom directory using BrowseForDirForm.
Will auto select the radio button for custom temp dir if user has not done so
-------------------------------------------------------------------------------}
procedure TConfigDlg.CustomTempDirBtnClick(Sender: TObject);
var
  dir: string;
begin
  if (BrowseForDirForm.ShowModal = mrOK) then
  begin
    dir := BrowseForDirForm.Directory;
    EDos.AddSlash(dir);
    CustomTempDirLabel.Caption := dir;
    RBUseCustomTempDir.Checked := true;
  end
  else
    RBUseWindowsDefaultTempDir.Checked := true;

end;

{-------------------------------------------------------------------------------
OKBtnClick
----------
Save the config to ConfigMan
-------------------------------------------------------------------------------}
procedure TConfigDlg.OKBtnClick(Sender: TObject);
begin
  // save the config to ConfigMan

  // confirm on delete
  ConfigMan.confirm_on_delete := XBConfirmOnDelete.Checked;

  // temporary directory
  if (RBUseWindowsDefaultTempDir.Checked) then
    ConfigMan.temp_dir := ConfigMan.default_temp_dir
  else
  begin
    // check the temp_dir is not empty
    if (CustomTempDirLabel.Caption = '') then
    begin
      Application.MessageBox('The custom temporary directory is invalid. Please correct it.', 'Error', 0);
      PageControl.ActivePage := TabSheet1;
      ModalResult := 0;
    end
    else
      ConfigMan.temp_dir := CustomTempDirLabel.Caption;
  end;
end;




procedure TConfigDlg.FormShow(Sender: TObject);
begin
  CentreFormToMain(Self);
end;

end.
