unit BrowseForDirUnit;
{-------------------------------------------------------------------------------
  Browse for Dir Unit
  -------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource


  Contains a form which allows the user to select a directory by means of
  a directory tree.

Used in:
  ConigDialog, where the user selects the custom temp directory.

Usage:
  retrieve the directory from the directory property.
  The dialog box will open in the current directory.
-------------------------------------------------------------------------------}



(**) interface (**)

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, FileCtrl;

type
  TBrowseForDirForm = class(TForm)
    DirectoryListBox: TDirectoryListBox;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    fdirectory: string;
  public
    property directory: string read fdirectory;

  end;

var
  BrowseForDirForm: TBrowseForDirForm;

(**) implementation (**)
Uses Main;

{$R *.DFM}

procedure TBrowseForDirForm.OKBtnClick(Sender: TObject);
begin
  fdirectory := DirectoryListBox.Directory;
end;

procedure TBrowseForDirForm.CancelBtnClick(Sender: TObject);
begin
  fdirectory := '';
end;

procedure TBrowseForDirForm.FormShow(Sender: TObject);
begin
  CentreFormToMain(Self);
end;

end.
