unit BWTFileCompressUnit;
////////////////////////////////////////////////////////////////////////////////
//  Burrows Wheeler Transformation
//  File Compression Unit
//
//
//  reSource (C) 1997 Finc
////////////////////////////////////////////////////////////////////////////////
(*
   Notes:
   The file compressor chops a file into several smaller blocks and adds them
   to an archive. If the file to compress is smaller than a block, the file size
   is used instead.

   The output file is assumed to be opened and already seeked to the correct
   position to add the file to the archive.

*)

interface
uses BWTCompressUnit;

type
  TFileCompressor = class
  private
    Compressor: TCompressor;
  public
    constructor Create;
    proceure
    destructor Destroy; override;
  end;


implementation

constructor TFileCompressor.Create;
begin
  inherited Create;
  Compressor := TCompressor.create;
end;

destructor TFileCompressor.Destroy; override;
begin
  Compressor.destroy;
  inherited Destroy;
end;



end.
