unit BWTBaseUnit;
{-------------------------------------------------------------------------------
  Burrows Wheeler Transformation
  Base Unit
  ------------------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

Desc:
  The base unit for TBWTCompress and TBWTExpand
  contains common procedures used by both of them.
-------------------------------------------------------------------------------}

(**) interface (**)
uses StructsUnit;

type
  TBWTBase = class
  protected
    in_block ,out_block: PBlock;

    procedure SwapBlocks;
    procedure CalculateCRC32(block: PBlock; block_length: integer; var crc: longword);

  public

  end;


(**) implementation (**)
uses CRC32Unit;

{-------------------------------------------------------------------------------
  Swap Blocks
  in_block and out_block exchange pointer values
-------------------------------------------------------------------------------}
procedure TBWTBase.SwapBlocks;
var
  temp_block: PBlock;
begin
  temp_block := in_block;
  in_block := out_block;
  out_block := temp_block;
end;

procedure TBWTBase.CalculateCRC32(block: PBlock; block_length: integer; var crc: longword);
var
  i: integer;
  CRC32: TCRC32;
begin
  CRC32 := TCRC32.Create;
  for i := 0 to block_length-1 do
    CRC32.Update(block^[i]);
  crc := CRC32.Get;
  CRC32.Free;
end;

end.
