unit AriModelUnit;
{-------------------------------------------------------------------------------
Warning: Defunct Unit

Adaptive order-0 model for Arithmetic compression
-------------------------------------------------
reSource (C) 1998 Victor K /97S66


Warning: Never use AriModelUnit with StrucAriModelUnit. They contain similarly
named constants but their values may differ.
-------------------------------------------------------------------------------}

(**) interface (**)


const
  NO_OF_CHARS = 256;
  EOF_SYMBOL = NO_OF_CHARS + 1;
  NO_OF_SYMBOLS = NO_OF_CHARS + 1;

  CODE_VALUE_BITS = 16;
  TOP_VALUE = (1 SHL CODE_VALUE_BITS) -1;

  FIRST_QTR = (TOP_VALUE DIV 4) + 1;
  HALF = 2 * FIRST_QTR;
  THIRD_QTR = 3 * FIRST_QTR;

  MAX_FREQUANCY = 8192;  {8192}
  INCREMENT = 1;  {16}

type
  TCodeValue = longint;
  TCumFreq = array[0..NO_OF_SYMBOLS+1] of integer;

  TAriModel = class
  private
    procedure StartModel;

  public
    char_to_index: array[0..NO_OF_CHARS] of integer;
    index_to_char: array[0..NO_OF_SYMBOLS+1] of byte;
    freq: array[0..NO_OF_SYMBOLS+1] of integer;
    cum_freq: TCumFreq;

    constructor Create;
    procedure UpdateModel(Symbol: integer);
  end;

(**) implementation (**)



Constructor TAriModel.Create;
begin
  inherited Create;
  StartModel;
end;

procedure TAriModel.StartModel;
var
  i: integer;
 begin
  for i := 0 to NO_OF_CHARS - 1 do
  begin
    char_to_index[i] := i + 1;
    index_to_char[i+1] := i;
  end;

  for i := 0 to NO_OF_SYMBOLS do
  begin
    freq[i] := 1;
    cum_freq[i] := NO_OF_SYMBOLS-i;
  end;

  freq[0] := 0;
end;

procedure TAriModel.UpdateModel;
var
  i, cum: integer;
  ch_i, ch_symbol: integer;
begin
  if (cum_freq[0] >= MAX_FREQUANCY) then
  begin
    cum := 0;
    for i := NO_OF_SYMBOLS downto 0 do
    begin
      freq[i] := (freq[i] + 1) div 2;
      cum_freq[i] := cum;
      inc(cum, freq[i]);
    end;
  end;

  i := symbol;
  while (freq[i] = freq[i-1]) do dec(i);

  if (i < symbol) then
  begin
    ch_i := index_to_char[i];
    ch_symbol := index_to_char[symbol];
    index_to_char[i] := ch_symbol;

    index_to_char[symbol] := ch_i;
    char_to_index[ch_i] := symbol;
    char_to_index[ch_symbol] := i;
  end;

  {inc(freq[i]);

  while (i > 0) do
  begin
    dec(i);
    inc(cum_freq[i]);
  end;}
  inc(freq[i], INCREMENT);
  while (i > 0) do
  begin
    dec(i);
    inc(cum_freq[i], INCREMENT);
  end;

end;



end.
