unit AriEncoderUnit;
{-------------------------------------------------------------------------------
Warning: Defunct unit

Arithmetic Encoder Unit
-----------------------
reSource (C) 1998 Victor K /97S66

This unit is not used in the release version and is for testing and comparison
purposes only.
To use this instead of the Structured Arithmetic decoder undefine USE_STRUC_ARI
in BWTCompressUnit.


Notes:
Call StartEncoding and DoneEncoding before and after coding respectively.
The Arithmetic model will be freed upon completion of the coding.
-------------------------------------------------------------------------------}


(**) interface (**)
uses
  SysUtils, Classes,
  bit_file_unit, StructsUnit, AriModelUnit, ArchiveFileUnit;



type
  TAriEncoder = class
  private
    low, high: longint;
    bits_to_follow: longint;

    procedure BitPlusFollow(bit: byte);

  protected
    AriModel: TAriModel;
    procedure OutputBit(bit: byte); virtual; abstract;
    procedure OutputBits(code: longint; count: byte); virtual; abstract;

    procedure StartEncoding;
    procedure DoneEncoding;
  public
    constructor Create(const _AriModel: TAriModel);
    destructor Destroy; override;

    procedure EncodeByte(a: byte);
    procedure EncodeSymbol(symbol: integer);
  end;



(**) implementation (**)

constructor TAriEncoder.Create(const _AriModel: TAriModel);
begin
  inherited Create;
  AriModel := _AriModel;
  //StartEncoding;
end;

destructor TAriEncoder.Destroy;
begin
  //DoneEncoding;
  inherited Destroy;
end;

{ At the end of the encoding process, there are still significant bits left
in the high and low registers. We output two bits, plus as many underflow
bits as are necessary }

procedure TAriEncoder.BitPlusFollow(bit: byte);
begin
  OutputBit(bit);
  while (bits_to_follow > 0) do
  begin
    if bit = 0 then
      OutputBit(1)
    else
      OutputBit(0);
    //outfile.OutputBit(not bit);
    dec(bits_to_follow);
  end;
end;

procedure TAriEncoder.StartEncoding;
begin
  low := 0;
  high := TOP_VALUE;
  bits_to_follow := 0;
end;

procedure TAriEncoder.DoneEncoding;
begin
  inc(bits_to_follow);
  if (low < FIRST_QTR) then
    BitPlusFollow(0)
  else
    BitPlusFollow(1);

  //OutputBits(0, 15);    //16 or 15 or none?
  AriModel.Free;
end;

procedure TAriEncoder.EncodeByte(a: byte);
var
  symbol: integer;
begin
  symbol := AriModel.char_to_index[a];
  EncodeSymbol(symbol);
end;

procedure TAriEncoder.EncodeSymbol(symbol: integer);
var
  range: longint;
begin
  {Rescale high and low for the new symbol}
  range := high-low + 1;
  high := low + (((range * AriModel.cum_freq[symbol-1]) div AriModel.cum_freq[0]) -1);
  low := low + ((range * AriModel.cum_freq[symbol]) div AriModel.cum_freq[0]);

  repeat
    if (high < HALF) then
      BitPlusFollow(0)
    else if (low >= HALF) then
    begin
      BitPlusFollow(1);
      dec(low, HALF);
      dec(high, HALF);
    end
    else if ((low >= FIRST_QTR) and (high < THIRD_QTR)) then
    begin
      inc(bits_to_follow);
      dec(low, FIRST_QTR);
      dec(high, FIRST_QTR);
    end
    else break;

    {low := low shl 1;
    high := high shl 1;
    high := high or 1;}
    low := 2 * low;
    high := 2 * high + 1;

  until false;

  AriModel.UpdateModel(symbol);
end;



end.


