unit AriDecoderUnit;
{-------------------------------------------------------------------------------
Warning: Defunct unit

Arithmetic Decoder Unit
-----------------------
reSource (C) 1998 Victor K /97S66

This unit is not used in the release version and is for testing and comparison
purposes only.
To use this instead of the Structured Arithmetic decoder undefine USE_STRUC_ARI
in BWTExpandUnit.

Notes:
Call StartDecoding before decoding.
The Arithmetic model will be freed upon completion of the coding.
-------------------------------------------------------------------------------}


(**) interface (**)
uses
  SysUtils, Classes,
  bit_file_unit, StructsUnit, AriModelUnit, ArchiveFileUnit;



type
  TAriDecoder = class
  private
    low, high, value: longint;
  protected
    AriModel: TAriModel;
    function  InputBit: byte; virtual; abstract;
    function  InputBits( count: byte ): longint; virtual; abstract;

    procedure StartDecoding;
    procedure DoneDecoding;
  public
    constructor Create(_AriModel: TAriModel);
    destructor Destroy; override;

    procedure DecodeSymbol(var symbol: integer; var ch: byte);
  end;



(**) implementation (**)


constructor TAriDecoder.Create(_AriModel: TAriModel);
begin
  inherited Create;
  //StartDecoding;
  AriModel := _AriModel;
end;

destructor TAriDecoder.Destroy;
begin
  inherited Destroy;
end;

procedure TAriDecoder.StartDecoding;
var
  i: longint;
begin
  value := 0;
  for i := 1 to CODE_VALUE_BITS do
    value := 2 * value + InputBit;

  low := 0;
  high := TOP_VALUE;
end;

procedure TAriDecoder.DoneDecoding;
begin
  AriModel.Free;
end;

procedure TAriDecoder.DecodeSymbol(var symbol: integer; var ch: byte);
var
  range: longint;
  cum: integer;
  //symbol: integer;
begin
  range := high - low + 1;
  cum := ((value-low+1) * AriModel.cum_freq[0] -1) div range;

  // find the symbol that straddles the range
  symbol := 1;
  while (AriModel.cum_freq[symbol] > cum) do inc(symbol);

  // convert the symbol to char if possible
  ch := AriModel.index_to_char[symbol];

  high := low + (range * AriModel.cum_freq[symbol-1]) div AriModel.cum_freq[0] -1;
  low := low + (range * AriModel.cum_freq[symbol]) div AriModel.cum_freq[0];

  // remove the bits that represent the current symbol to get the next symbol's
  // range
  repeat
    if (high < HALF) then
      {nothing}
    else if (low >= HALF) then
    begin
      dec(value, HALF);
      dec(low, HALF);
      dec(high, HALF);
    end else if ((low >= FIRST_QTR) and (high < THIRD_QTR)) then
    begin
      dec(value, FIRST_QTR);
      dec(low, FIRST_QTR);
      dec(high, FIRST_QTR);
    end else break;

    low := 2 * low;
    high := 2 * high + 1;
    value := 2 * value + InputBit;
    //value := (value shl 1) + InputBit;

  until false;

  // update the model with the new symbol found
  AriModel.UpdateModel(symbol);
end;


end.
