unit AddOptionsDlgUnit;
{-------------------------------------------------------------------------------
  Add Options Dialog Unit
  -----------------------
  resource (C) 1998, 1999 Victor Kasenda / gruv
  http://members.tripod.com/~gruv/resource

  Desc:
  Shown when the user wants to add files to the archive.
  Allows user to select files to add to the archive through the use of
  a FileList. A directory tree allows the uses to change directory easily.
  User can also change drive through a combo box.
  No typing in of files to add is required. User need only select the files
  to add.

  Notes:
  The dialog will check if the user selected the archive file itself to
  be added. It is impossible to add the archive file to itself so an error
  will be reported. The archive file will be deselected from the FileList and
  the user can confirm again the files he selected.
  This check is only done when the OK button is pressed because it is the most
  efficient implementation for the set of controls. There are no support events
  for "OnSelectChange" or similar events.

  Not supported:
  Directories cannot be added to the archive. To add all files in a directory,
  select all of them in the FileList.
-------------------------------------------------------------------------------}


(**) interface (**)

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, FileCtrl;

type
  TAddOptionsDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    DirectoryListBox: TDirectoryListBox;
    FileListBox: TFileListBox;
    DriveComboBox: TDriveComboBox;
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AddOptionsDlg: TAddOptionsDlg;

(**) implementation (**)
uses Main;

{$R *.DFM}

procedure TAddOptionsDlg.FormCreate(Sender: TObject);
begin
  {$IFDEF DEBUG}
  //DirectoryListBox.Directory := 'c:\ctest\corpus';
  {$ENDIF}
end;

procedure TAddOptionsDlg.OKBtnClick(Sender: TObject);
var
  i: integer;
begin
  // Check that the archive file is not added in
  with MainForm.ArchiveManager do
  begin
    // The directory format stored in FileListBox.Directory does not include
    // the back slash, so it must be added
    if (CompareText(FileListBox.Directory + '\', archive_file_folder) = 0) then
    begin
      for i := 0 to FileListBox.Items.Count-1 do
      begin
        if FileListBox.Selected[i] then
          if (CompareText(FileListBox.Items[i], archive_file_name) = 0) then
          begin
            // found the archive file that was selected
            // show message box to deselect it
            Application.MessageBox('You have selected the archive file. It will be deselected.',
                                   'Select Error', 0);
            // deselect the file
            FileListBox.Selected[i] := false;
            // prevent the form from closing for the user to confirm selection again
            ModalResult := 0;
            break;
          end;
      end;
    end;
  end;
end;

procedure TAddOptionsDlg.FormShow(Sender: TObject);
begin
  CentreFormToMain(Self);
end;

end.
