//----------------------------------------------------------------
//           Bitmap rotation component for Delphi 4
//                  (3 and less not tested)
//
//  Author:    Pavel Petsevich
//  E-Mail:    pasha@junik.lv
//  Created:   November, 1999
//
//  NOT IMPORTANT NOTE    :))
//  This source is FREE!
//  If you found useful this component i just want to offer you
//                             -------
//  to GET SOME MONEY - about | $500  |, when you find customer
//                             -------
//  and install new version of my WindowSystem...
//
//  WindowSystem is a local/network system for automation of trading
//  and producing plastic and wooden windows and doors:
//
//  Common features of WindowSystem:
//  --------------------------------
//     - Very simple windowed interface
//     - All drawings drawing and printing with scaled REAL parts of unit
//     - Ability to work with multiple profile systems (plastic)
//     - Work flow: Proposal -> Order -> Payments register
//                  -> Technical printouts
//     - Complete salary calculation for every unit, order, etc.
//     - Complete materials calculation for every unit, order, etc.
//     - Price of every production unit (window, door) calculating
//       from EXACT materials cost + salary + formula (you can tune up)
//       You can have a special formula for every customer category
//     - Print balance of every order or customer
//     - Print order for glasses (can compile some window orders)
//     - Print order for furniture (can compile some window orders)
//     - Reports: customers, orders, materials, salary
//     - Profiles cutting optimization (single and double cutting)
//     - Complex construction order (+additional profiles and materials)
//       with simple graphical interface and scaled printout
//     - SQL Server data storage
//     - Multiuser ability (with customized accessibility)
//     - Orders transfer between WindowsSystem's through INTERNET
//     and more useful functions...
//
//  Available versions (november 1999):
//       WinSys 4.2p  - plastic windows and doors (local and network)
//       WinSys 5.0w  - wooden windows (local and network)
//
//  Contacts by email:
//       pasha@junik.lv
//
//----------------------------------------------------------------
//
//  TROTIMAGE: = TImage +
//  90 and 180 degrees rotation and flip ability
//
//----------------------------------------------------------------
//
//  LIMITATIONS:
//     - only works with Picture.Bitmap property
//     - only works with standard bitmap depth 8bit and more
//
//----------------------------------------------------------------
//
//  USAGE:
//
//  Rotate(RotationType: TRotationType)
//
//  TRotationType = (ra90, ra180, ra90rev, raFlipVert, raFlipHorz)
//
//----------------------------------------------------------------
//
//                            IMPORTANT NOTE:
//
//  This software is provided 'as-is', without any express or
//  implied warranty. In no event will the author be held
//  liable for any damages arising from the use of this
//  software.
//  Permission is granted to anyone to use this software for
//  any purpose, excluding commercial applications (permission will be 
//  granted for FREE after email request), and to alter it and 
//  redistribute it freely, subject to the following restrictions:
//  1. The origin of this software must not be misrepresented,
//      you must not claim that you wrote the original software.
//      If you use this software in a product, an acknowledgment
//      in the product documentation would be appreciated but is
//      not required.
//  2. Altered source versions must be plainly marked as such,
//      and must not be misrepresented as being the original
//      software.
//  3. Any notice may not be removed or altered from any
//      source distribution.
//
//----------------------------------------------------------------

unit RotImage;

interface

uses
  Windows, SysUtils, Classes, Graphics, ExtCtrls;

type
  TRotationType = (ra90, ra180, ra90rev, raFlipVert, raFlipHorz);

  TRotBitmap = class(TBitmap)
  public
    procedure Rotate(aRotAngle: TRotationType);
  end;

  TRotImage = class(TImage)
  public
    procedure RotateBitmap(aRotAngle: TRotationType);
  end;

procedure Register;

implementation

procedure TRotBitmap.Rotate(aRotAngle: TRotationType);
type TBMInfo = record
       bmType,
       bmWidth,
       bmHeight,
       bmWidthBytes: longint;
       bmPlanes,
       bmBitsPixel: word;
     end;
var xmul, nWidth,
    x, y, n: smallint;
    bmInfo: TBMInfo;
    bmData: array of byte;
    bmNewData: array of byte;
begin
  GetObject(Handle, SizeOf(bmInfo), @bmInfo);
  setLength(bmData, bmInfo.bmWidthBytes*bmInfo.bmHeight);
  setLength(bmNewData, bmInfo.bmWidthBytes*bmInfo.bmHeight);
  GetBitmapBits(Handle, bmInfo.bmWidthBytes*bmInfo.bmHeight, bmData);
  if aRotAngle in [ra90, ra90rev]
    then begin
      Height := bmInfo.bmWidth;
      Width := bmInfo.bmHeight;
    end;
  nWidth:=Width;
  if frac(bmInfo.bmBitsPixel/8)>0 then raise Exception.Create('Unsupported pixel format!');
  xmul:=bmInfo.bmBitsPixel div 8;
  with bmInfo do
    case aRotAngle of
      ra90   : for y:=0 to bmHeight-1 do
                 for x:=0 to bmWidth-1 do
                   for n:=0 to xmul-1 do
                     bmNewData[x*(nWidth*xmul) + bmHeight*xmul-(y+1)*xmul+n]:=
                     bmData[y*bmWidthBytes + x*xmul+n];
      ra90rev : for y:=0 to bmHeight-1 do
                  for x:=0 to bmWidth-1 do
                    for n:=0 to xmul-1 do
                      bmNewData[(bmWidth-1-x)*(nWidth*xmul) + y*xmul+n]:=
                      bmData[y*bmWidthBytes + x*xmul+n];
      ra180   : for y:=0 to bmHeight-1 do
                  for x:=0 to bmWidth-1 do
                    for n:=0 to xmul-1 do
                      bmNewData[(bmHeight-1-y)*(nWidth*xmul) + bmWidthBytes-(x+1)*xmul+n]:=
                      bmData[y*bmWidthBytes+x*xmul+n];
      raFlipVert : for y:=0 to bmHeight-1 do
                     System.Move(bmData[y*bmWidthBytes],
                                 bmNewData[(bmHeight-1-y)*(nWidth*xmul)], bmWidthBytes);
      raFlipHorz : for y:=0 to bmHeight-1 do
                     for x:=0 to bmWidth-1 do
                       for n:=0 to xmul-1 do
                         bmNewData[y*(nWidth*xmul)+bmWidthBytes-(x+1)*xmul+n]:=
                         bmData[y*bmWidthBytes+x*xmul+n];
    end;
  for y:=0 to Height-1 do
    System.Move(bmNewData[y*(nWidth*xmul)], ScanLine[y]^, nWidth*xmul);
  setLength(bmData, 0);
  setLength(bmNewData, 0);
end;

procedure TRotImage.RotateBitmap(aRotAngle: TRotationType);
var bm: TRotBitmap;
begin
  if Picture.Bitmap.Empty
    then raise Exception.Create('Bitmap is empty!');
  bm:=TRotBitmap.Create;
  bm.Assign(Picture.Bitmap);
  bm.Rotate(aRotAngle);
  Picture.Bitmap.Assign(bm);
  bm.Free;
end;


procedure Register;
begin
  RegisterComponents('Additional', [TRotImage]);
end;

end.
