{ @author(Ralf Junker -- delphi@zeitungsjunge.de )
  @Exclude }

unit rjExConsts;

interface

const
  CONTAINER_NOT_EMPTY_WHILE = 'Container not empty while ';
  NOT_ASSIGNED = ' not assigned';
  IS_NIL = ' is nil';

resourcestring
  SInvalidItemSizeError = 'Invalid ItemSize (%d)';
  SInvalidKeySizeError = 'Invalid KeySize (%d)';
  SContainerEmptyError = 'Container is empty';

  SItemNilError = 'Item' + IS_NIL;
  SItemDeletedError = 'Item is deleted';

  SNodeNilError = 'Node' + IS_NIL;
  SKeyNilError = 'Key' + IS_NIL;

  SNoCallBackError = 'CallBack' + NOT_ASSIGNED;
  SNoOnCopyKeyError = 'OnCopyKey' + NOT_ASSIGNED;
  SNoOnHashKeyError = 'OnHashKey' + NOT_ASSIGNED;
  SNoOnSameKeysError = 'OnSameKeys' + NOT_ASSIGNED;

  SNotEmptySetItemSizeError = CONTAINER_NOT_EMPTY_WHILE + 'setting ItemSize';
  SNotEmptySetKeySizeError = CONTAINER_NOT_EMPTY_WHILE + 'setting KeySize';

  SNotEmptyAssignOnFreeItemError = CONTAINER_NOT_EMPTY_WHILE + 'assigning OnFreeItem';
  SNotEmptyAssignOnInitItemError = CONTAINER_NOT_EMPTY_WHILE + 'assigning OnInitItem';

  SNotEmptyAssignOnCopyKeyError = CONTAINER_NOT_EMPTY_WHILE + 'assigning OnCopyKey';
  SNotEmptyAssignOnFreeKeyError = CONTAINER_NOT_EMPTY_WHILE + 'assigning OnFreeKey';
  SNotEmptyAssignOnHashKeyError = CONTAINER_NOT_EMPTY_WHILE + 'assigning OnHashKey';
  SNotEmptyAssignOnSameKeysError = CONTAINER_NOT_EMPTY_WHILE + 'assigning OnSameKeys';

  STreeMoveError = 'Cannot move a tree item to one of its children';

implementation

end.

