unit ritoptions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Registry, Rasext;

type
  TRasManClick = (rcSingle, rcShift);

  TRitOption = class(TObject)
  private
   FForce: Boolean; //Force RasInTask to start in AutoDial
   FLWC: Boolean; //When conf-time = 0 then use/not use predefined connection-list
   FAutorun: Boolean;
   FHinweise: Boolean;   //Hinweise is german and stands for Hint, Trick. I use this for the tutorial windows
   FAnim: Boolean;
   FLogging: Boolean;
   FSplash: Boolean;
   FUseCAD: Boolean;
   FDetDlg: Boolean;
   FLanguage: Integer;
   FConnectSk: String;
   FSclick   : Byte;
   FConnectDk: String;
   FDclick   : Byte;
   FIsSaved  :Boolean;
   FProgRun  : Boolean;
   FShowTips : Boolean;
   FConnectWindow: Boolean;
   FCAD: Byte;  //ComfirmAutoDial (in seconds)
   FPopUpType: Byte;
   FCountDown: Byte;
   FLogCount : Integer;
   FRasMan   : TRasManClick;

   procedure loadSettings;
   procedure saveSettings;

   procedure SetUseCAD(new: Boolean);
   procedure SetForce(new: Boolean);
   procedure SetLWC(new: Boolean);
   procedure SetAutorun(new: Boolean);
   procedure SetHinweise(new: Boolean);
   procedure SetAnim(new:Boolean);
   procedure SetSplash(new:Boolean);
   procedure SetLanguage(new: Integer);
   procedure SetConnectSk(new:String);
   procedure SetSClick(new: Byte);
   procedure SetConnectDk(new: String);
   procedure SetDClick(new: Byte);
   procedure SetProgRun(new: Boolean);
   procedure SetLogging(new: Boolean);
   procedure SetShowTips(new: Boolean);
   procedure SetConnectWindow(new: Boolean);
   procedure SetCAD(new: Byte);
   procedure SetPopUpType(new: Byte);
   procedure SetCountDown(new: Byte);
   procedure SetRasMan(const Value: TRasManClick);
   procedure SetDetDlg(new: Boolean);
   procedure SetLogCount(new: Integer);
   function getAnim: boolean;
  public
    constructor Create;
    destructor  Destroy; Override;

    procedure undo;
    procedure save;

    property Logging       : Boolean   read FLogging       write SetLogging;
    property UseCad        : Boolean   read FUseCAD        write SetUseCAD;
    property LWC           : Boolean   read FLWC           write SetLWC;
    property Force         : Boolean   read FForce         write SetForce;
    property Autorun       : Boolean   read FAutorun       write SetAutorun;
    property Splash        : Boolean   read FSplash        write SetSplash;
    property Hinweise      : Boolean   read FHinweise      write SetHinweise;
    property Anim          : Boolean   read GetAnim        write SetAnim;
    property Language      : Integer   read FLanguage      write SetLanguage;
    property LogCount      : Integer   read FLogCount      write SetLogCount;
    property ConnectSk     : String    read FConnectSk     write SetConnectSk;
    property Scklick       : Byte      read FSClick        write SetSClick;
    property ConnectDk     : String    read FConnectDk     write SetConnectDk;
    property DClick        : Byte      read FDClick        write SetDClick;
    property IsSaved       : Boolean   read FIsSaved       write FIsSaved;
    property ProgRun       : Boolean   read FProgRun       write SetProgRun;
    property ShowTips      : Boolean   read FShowTips      write SetShowTips;
    property DetDlg        : Boolean   read FDetDlg        write SetDetDlg;
    property ConnectWindow : Boolean   read FConnectWindow write SetConnectWindow;
    property PopUpType     : Byte      read FPopUpType     write SetPopUpType;
    property Countdown     : Byte      read FCountdown     write SetCountdown;
    property CAD           : Byte      read FCAD           write SetCAD;
    property RasMan        : TRasManClick read FRasMan write SetRasMan;
  end;

implementation

Uses EncryptIt, Main, ritconnection;

const
 CONNECT      = 1;  //..connect to..
 SHOW_OPTIONS = 2;  //..Show this Dialog
 SHOW_MENU    = 3;  //..Show PopupMenu
 SP_DEUTSCH   = 0;    // german
 SP_ENGLISCH  = 1000; // english
 REGKEY = '\Software\PH-Arts\RasInTask\Hints\';

procedure TRitOption.setAutorun(new:Boolean);
begin
FIsSaved:=False;
FAutoRun:=new;
end;

procedure TRitOption.setSplash(new:Boolean);
begin
FIsSaved:=False;
FSplash:=new;
end;


procedure TRitOption.setLogCount(new:Integer);
begin
FIsSaved:=False;
FLogCount:=new;
end;

procedure TRitOption.setLogging(new:Boolean);
begin
FIsSaved:=False;
FLogging:=new;
end;


procedure TRitOption.setConnectWindow(new:Boolean);
begin
FIsSaved:=False;
FConnectWindow:=new;
end;

procedure TRitOption.setDetDlg(new:Boolean);
begin
FIsSaved:=False;
FDetDlg:=new;
end;


procedure TRitOption.setUseCAD(new:Boolean);
begin
FIsSaved:=False;
FUseCAD:=new;
end;


procedure TRitOption.setLWC(new:Boolean);
begin
FIsSaved:=False;
FLWC:=new;
end;

procedure TRitOption.setProgRun(new:Boolean);
begin
FIsSaved:=False;
FProgRun:=new;
end;

procedure TRitOption.SetShowTips(new: Boolean);
begin
 FIsSaved:=False;
 FShowTips:=new;
end;

procedure TRitOption.setForce(new:Boolean);
begin
FIsSaved:=False;
FForce:=new;
end;


procedure TRitOption.setHinweise(new:Boolean);
begin
FIsSaved:=False;
FHinweise:=new;
end;

procedure TRitOption.setLanguage(new:Integer);
begin
FIsSaved:=False;
FLanguage:=new;
end;

procedure TRitOption.setconnectSk(new:String);
begin
FIsSaved:=False;
FconnectSk:=new;
end;

procedure TRitOption.setconnectdk(new:String);
begin
FIsSaved:=False;
Fconnectdk:=new;
end;

procedure TRitOption.setSClick(new:Byte);
begin
FIsSaved:=False;
FSClick:=new;
end;

procedure TRitOption.setDClick(new:Byte);
begin
FIsSaved:=False;
FDClick:=new;
end;

procedure TRitOption.setCAD(new:Byte);
begin
FIsSaved:=False;
FCAD:=new;
end;



procedure TRitOption.setPopUpType(new:Byte);
begin
FIsSaved:=False;
FPopUpType:=new;
end;

procedure TRitOption.setCountDown(new:Byte);
begin
FIsSaved:=False;
FCountdown:=new;
end;

constructor TRitOption.Create;
begin
inherited Create;
FCad       :=5;
FUseCAD    :=true;
FCountdown :=10;
FLWC       :=false;
FForce     :=False;
FAutorun   :=False;
FDetDlg    :=true;
FIsSaved   :=True;
FHinweise  :=True;
FAnim      :=True;
FSplash    :=true;
FLogCount  :=100;
FLanguage  :=SP_ENGLISCH;
FConnectSk :='';
FSClick    :=SHOW_MENU;
FConnectDK :='';
FDClick    :=SHOW_OPTIONS;
FProgRun   :=True;
FLogging   :=True;
FPopUpType :=0;
loadSettings;
FConnectWindow:=True;
FRasMan := rcSingle;
end;

destructor TRitOption.Destroy;
begin
inherited destroy;
end;

procedure TRitOption.LoadSettings;
var Reg:TRegistry;
    tmp: Integer;
begin
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_CURRENT_USER;
Reg.OpenKey('\Software\PH-Arts\RasInTask\', true);
Reg.WriteString('InstallPath', ExtractFilePath(Application.ExeName));
Reg.CloseKey;
Reg.OpenKey('\Software\PH-Arts\RasInTask\Settings\', true);
tmp:=0;
If Reg.ValueExists('RasMan') then
 tmp:=Reg.ReadInteger('RasMan');

Case tmp of
 1: FRasMan:=rcShift;
else
 FRasMan:=rcSingle;
End;

If Reg.ValueExists('Language') then
 FLanguage:=Reg.ReadInteger('Language');

If Reg.ValueExists('Force') then
 FForce:=Reg.ReadBool('Force');

If Reg.ValueExists('UseCAD') then
 FUseCAD:=Reg.ReadBool('UseCAD');

If Reg.ValueExists('LogCount') then
 FLogCount:=Reg.ReadInteger('LogCount');

If Reg.ValueExists('NoSplash') then
 FLogging:=not(Reg.ReadBool('NoSplash'));

If Reg.ValueExists('Logging') then
 FLogging:=Reg.ReadBool('Logging');

If Reg.ValueExists('DetDlg') then
 FDetDlg:=Reg.ReadBool('DetDlg');

If Reg.ValueExists('ProgRun') then
 FProgRun:=Reg.ReadBool('ProgRun');

If Reg.ValueExists('ConnectWindow') then
 FConnectWindow:=Reg.ReadBool('ConnectWindow');

if SysUTILS.Win32Platform = VER_PLATFORM_WIN32_NT then
 If Reg.ValueExists('Animation') then
  FAnim:=Reg.ReadBool('Animation')
else
  FAnim:=getAnim;

If Reg.ValueExists('LWC') then
 FLWC:=Reg.ReadBool('LWC');

If Reg.ValueExists('ConnectDc') then
 FConnectDk:=Reg.ReadString('ConnectDc');

If Reg.ValueExists('ConnectSc') then
 FConnectSk:=Reg.ReadString('ConnectSc');

If Reg.ValueExists('DoubleClick') then
 FDClick:=Reg.ReadInteger('DoubleClick');

If Reg.ValueExists('SingleClick') then
 FSClick:=Reg.ReadInteger('SingleClick');

If Reg.ValueExists('CAD') then
 FCAD:=Reg.ReadInteger('CAD');

If Reg.ValueExists('PopUpType') then
 FPopUpType:=Reg.ReadInteger('PopUpType');

If Reg.ValueExists('Countdown') then
 FCountdown:=Reg.ReadInteger('Countdown');

If Reg.ValueExists('Tutorial') then
 FHinweise:=Reg.ReadBool('Tutorial');

Reg.CloseKey;
Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run\', true);
FAutoRun:=Reg.ValueExists('RasInTask');
Reg.CloseKey;
//Reg.OpenKey('\Software\PH-Arts\RasInTask\Tips', true);
//FShowTips:=Reg.ValueExists('Show');
Reg.Free;
FIsSaved:=True;
end;

procedure TRitOption.saveSettings;
var Reg:TRegistry;
begin
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_CURRENT_USER;
Reg.OpenKey('\Software\PH-Arts\RasInTask\Settings\', true);
Reg.WriteInteger('Language', FLanguage);
Reg.WriteInteger('DoubleClick', FDClick);
Reg.WriteInteger('SingleClick', FSClick);
Reg.WriteInteger('PopUpType', FPopUpType);
Reg.WriteInteger('Countdown', FCountdown);
Reg.WriteInteger('LogCount', FLogCount);
Reg.WriteInteger('CAD', FCAD);
//Reg.WriteInteger('retBusy', FTries);
Reg.WriteBool('Logging', FLogging);
Reg.WriteBool('NoSplash', not(FSplash));
Reg.WriteBool('UseCAD', FUseCAD);
Reg.WriteBool('Force', FForce);
Reg.WriteBool('ProgRun', FProgRun);
Reg.WriteBool('LWC', FLWC);
Reg.WriteBool('DetDlg', FDetDlg);
Reg.WriteBool('ConnectWindow', FConnectWindow);
Reg.WriteBool('Animation', FAnim);
Reg.WriteBool('Tutorial', FHinweise);

Case FRasMan of
 rcSingle: Reg.WriteInteger('RasMan', 0);
else
 Reg.WriteInteger('RasMan', 1);
End;

Reg.WriteString('ConnectDc', FConnectDk);
Reg.WriteString('ConnectSc', FConnectSk);

Reg.CloseKey;

if FAutoRun then
 begin
 Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run\', true);
 Reg.WriteString('RasInTask', Application.ExeName);
 Reg.CloseKey;
 end
else
 begin
 Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run\', true);
 Reg.DeleteValue('RasInTask');
 Reg.CloseKey;
 end;

Reg.OpenKey('\Software\PH-Arts\RasInTask\Tips', true);
if FShowTips then
 Reg.WriteBool('Show', true)
else
 if Reg.ValueExists('Show') then
  Reg.DeleteValue('Show');
Reg.Free;
FIsSaved:=True;
end;

procedure TRitOption.undo;
var x: integer;
begin
loadSettings;
for x:=0 to MainForm.RasConnections.Count - 1 do
 begin
 TRitConnection(MainForm.RasConnections[x]).UndoAutoDial;
 end;
end;

procedure TRitOption.save;
begin
saveSettings;
end;


procedure TRitOption.setAnim(new:Boolean);
var i:Integer;
procedure switchmodem(connection: string);
var
    entry: LPRasEntry;
    entrySize, devinfoSize: Integer;
    ret: dword;
 begin
  entrySize := 0;
  devinfoSize := 0;
  ret:= RasGetEntryProperties(nil, PChar(connection),
      nil, entrySize, nil, devinfoSize);
  if ret <> ERROR_BUFFER_TOO_SMALL then
    begin
    Exit;
    end;
  entry := AllocMem(entrySize);
  try
    entry^.dwSize := SizeOf(TRasEntry);
    if RasGetEntryProperties(nil, PChar(connection),
        entry, entrySize, nil, devinfoSize) = 0 then
      begin
       if new then
        entry.dwfOptions:=entry.dwfOptions or RASEO_ModemLights
       else
        entry.dwfOptions:=entry.dwfOptions and not RASEO_ModemLights;
       ret:= RasSetEntryProperties(nil, PChar(connection), entry, entrySize, nil, 0);
       if ret <> 0 then
        ShowMessage('fuck');
    end
  finally
    FreeMem(entry);
  end;
 end;
begin
if sysutils.Win32Platform = VER_PLATFORM_WIN32_WINDOWS then
 begin
 for i:=0 to MainForm.RasConnections.Count -1 do
  switchmodem(TRitConnection(MainForm.RasConnections[i]).Name);
 end;
FIsSaved:=False;
FAnim:=new;
end;

function TRitOption.getAnim:boolean;
var i:integer;
    t:boolean;
function ise(connection: string): Boolean;
  var
    entry: LPRasEntry;
    entrySize, devinfoSize: Integer;
    ret: dword;
  begin
  result:=False;
  entrySize := 0;
  devinfoSize := 0;
  ret:= RasGetEntryProperties(nil, PChar(connection),
      nil, entrySize, nil, devinfoSize);
  if ret <> ERROR_BUFFER_TOO_SMALL then
    begin
    Exit;
    end;
  entry := AllocMem(entrySize);
  try
    entry^.dwSize := SizeOf(TRasEntry);
    if RasGetEntryProperties(nil, PChar(connection),
        entry, entrySize, nil, devinfoSize) = 0 then
      begin
       result := (entry.dwfOptions and RASEO_ModemLights = RASEO_ModemLights);
      end;
  finally
    FreeMem(entry);
    end;
  end;
begin
if sysutils.Win32Platform = VER_PLATFORM_WIN32_WINDOWS then
 begin
 t:=true;
 for i:=0 to MainForm.RasConnections.Count -1 do
  if not ise(TRitConnection(MainForm.RasConnections[i]).Name) then t:=false;
 FAnim:=t;
 end;
Result:=FAnim;
end;


procedure TRitOption.SetRasMan(const Value: TRasManClick);
begin
  FIsSaved :=False;
  FRasMan  := Value;
end;

end.
