unit ritconnection;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Registry, Rasext, ShellAPI, extctrls;

type
  TRitConnection = class; //Declaration for Constructor of TConnectionThread

  TKeepType = (ktNone, ktPing, ktHttp); //Type of KeepAlive that is used
//             ^^^^^^ means "disabled"
  TDisconnectType = (dtNone, dtAlways, dtIntelligent);
//                    (1)      (2)          (3)
{
 1: No automatical disconnection
 2: Always disconnect after a given time
 3: Always disconnect after a given time, but only if RasInTask
    detected no traffic
}

  TAutoDisconnect = Record
   DcType : TDisconnectType;
   DcTime : Integer;
  end;

  TAskLater = Record
   AskName      : Boolean;  //Display a login-box and ask for the name
   AskPassword  : Boolean;  //Display a login-box and ask for the password
   Timeout      : Integer;  //The Timeout in the Passwd-Window;
   SavePassword : Boolean;  //Shpould the Passwd be saved in one dialing-session?
  end;

  TKeepAlive = Record
   AliveType: TKeepType;
   URL: String;
   Minutes: Integer;
  end;


{
 The following thread (the third that is written by me for this application)
 does time-checking for the corresponding RitConnection-Object. With the help
 of this thread (Priority tpLower), the KeepAlive and Disconnect after xx seconds
 features are realized.
}

  TConnectionThread = class(TThread)
  protected
    FCheckRec : Integer;
    FCheckTrs : Integer;
    FCheckAliveTime : Integer;
    FCheckDisConnectTime : Integer;
    FConnection: TRitConnection;
    procedure Execute; override;
    procedure KeepAlive; //Called with synchronzie.
    procedure Disconnect; //Called with synchronize to disconnect
  public
    procedure Resume;
    constructor Create(Connection: TRitConnection; CreateSuspended: Boolean);
  end;

  TMultiDial = class(TObject)
  private
   FListIndex   : Integer;
   FDialList    : TStringList;
   FUseProgs    : Boolean;
   FUseKeep     : Boolean;
   FUseDisc     : Boolean;
   FActive      : Boolean;
   FShowWindow  : Boolean;
   FIsSaved     : Boolean;
   FConnection  : String;
   FInProgress  : Integer;   // 'RunTime'-Property: Is a multiDial in progress
   FSourceIndex : Integer;   // Contains the Index of the Connection that failed and activated multidial

   procedure SetDialList(new: TStringList);
   procedure SetUseProgs(new: Boolean);
   procedure SetUseKeep(new: Boolean);
   procedure SetActive(new: Boolean);
   procedure SetShowWindow(new: Boolean);
   procedure SetUseDisc(new: Boolean);
  public
   property DialList  : TStringList read FDialList   write SetDialList;
   property UseProgs  : Boolean     read FUseProgs   write SetUseProgs;
   property UseKeep   : Boolean     read FUseKeep    write SetUseKeep;
   property UseDisc   : Boolean     read FUseDisc    write SetUseDisc;
   property Active    : Boolean     read FActive     write SetActive;
   property ShowWindow: Boolean     read FShowWindow write SetShowWindow;
   property IsSaved   : Boolean     read FIsSaved    write FIsSaved;
   property InProgress: Integer     read FInProgress write FInProgress;
   property ListIndex : Integer     read FListIndex  write FListIndex;
   property SourceIndex: Integer read FSourceIndex write FSourceIndex;
   procedure   load;
   procedure   save;
   constructor Create(Connection: String);
   destructor  Destroy; Override;
  end;

  TStateChangeEvent = procedure(Sender: TObject; RitState, apiState, error: Integer) of object;

  TTimerType        = (ttNone, ttHangUp, ttRedial, ttMultiDial);

  TRitConnection = class(TObject)
  private
   FConWinIsOpen: Boolean;              //since windows calls the event ConnectionChange more than once and
   FDisconnectionAllowed: Boolean;      //sicne the reconnection-window is created dynamically, I have to
   FConnectionThread: TConnectionThread;//create this control-variable. Else the Window will be showed twice.
   FProgList      : TStringLIst;
   FDialTimer     : TTimer;  //This is pure bugfixing of M$-Bugs -> See Bottom of declaration
   FBugFix        : Boolean;
   FAD            : boolean;
   FSInAutoDial : Boolean; //this is suggested in AutoDial
   FName          : String;
   FUserName      : String;
   FPassword      : String;
   FAlive         : TKeepAlive;
   FReconnect     : Boolean;
   FDisconnect    : TAutoDisconnect;
   FIsSaved       : Boolean;
   FAskLater      : TAskLater;
   FNewName       : String;
   FActive        : Boolean;
   FActiveSince   : Dword;
   FMultiDial     : TMultiDial;
   FDialAttemps   : Integer;
   FDialPause     : Byte;
   FCurrentAttemp : Integer;
   FRitState      : Dword;
   FLonger        : Boolean;
   FHandle        : THRasConn;
   FCountDown     : Integer;
   FShowed        : Boolean;
   FDeviceName    : String;
   FDeviceType    : String;
   FSourceConnection: String;  //This belongs to the complex MultiDial -->End of File
   FTimerType       : TTimerType;
   FAllowedToRedial : Boolean;//After some kind of error, a Redial is not allowed,
                              //because this would not fix the problem
                              //For example: If the Modem is turned off, a redial
                             //would not work....
   FOnStateChange: TStateChangeEvent;
   procedure getRasOptions;
   procedure getPassword;
   procedure loadSettings;
   procedure writeSettings;
   procedure SavePassword;

   procedure SetAutoDial(state: Boolean);
   function  GetAutoDial:Boolean;
   procedure SetBugFix(new: Boolean);
   procedure SetReconnect(new: Boolean);
   procedure SetName(new:String);
   procedure SetUserName(new: String);
   procedure SetPassword(new:String);
   procedure SetAlive(new: TKeepAlive);
   procedure SetAskLater(new: TAskLater);
   procedure SetDisconnect(new: TAutoDisconnect);
   procedure SetMultiDial(new: TMultiDial);
   procedure SetActive(new: Boolean);
   procedure SetIsSaved(new: Boolean);
   procedure SetSInAutoDial(new: Boolean);
   procedure SetDialAttemps(new: Integer);
//   procedure RasCallback(msg: Integer; state: TRasConnState; error: Longint); stdcall;
{
  If RasCallback is a Class-Member, Windows9x will crash with a "Heavy Exception fault"
  (English translation from the German, Bluescreen-Message "Schwerer Ausnahmefehler").
  The procedure is now at the end if the Unit.

  The problem is: From the function, I have no access to the Object that called it.
  As a solution, I use the Callback-Function RASDialFunc1, which has in a
  parameter the handle of the connection that raised the event.

  Over the List in MainForm, I can look for the Handle and have the object again.
}

   procedure TimerEventProc(Sender: TObject);
   procedure SetDialPause(new: Byte);


   function  canSave  : Boolean;
   function  Dial(redial: boolean = false): Boolean;
   function  GetHandle: THandle; //This retrieves the handle of this connection:
   // RasInTask crashes if a connection that already existed has to be disconnected,
   // since the Handle-Property and the real handle of the connection are not
   // synchronized. GetHandle lists the active connections and returns the
   // handle of the connection that's name matches the FName-Property

   function GetIsSaved: Boolean;
  public
    procedure UnDo;
    procedure UndoAutoDial; //this is used in Ritoptions.undo
    procedure Save;
    procedure ReloadRasOnly;
    constructor Create(name: String; virt: Boolean);
    destructor  Destroy; Override;
    procedure RunProgs(before: Boolean);
    procedure SaveTheLive;
    procedure DeleteEntries; //Removes all the Settings from the Registry;
    procedure Connect(source: String);  //-->Source belongs to the compley MultiDial -->EOF
    procedure EventTriggered;
    function  HangUp(ask: boolean = false): boolean;
    procedure ChangeConnection(state: Boolean); //Disconnects/Reconnects with displaying the count-down-window
    property sInAutodial: Boolean     read FSinAutoDial write SetSInAutoDial;
    property Handle      : THrasConn       read FHandle;
    property BugFix      : Boolean         read FBugFix      write SetBugFix;
    property Name        : String          read FName;
    property NewName     : String          read FNewName     write SetName;
    property UserName    : String          read FUserName    write SetUserName;
    property Password    : String          read FPassword    write SetPassword;
    property ProgList    : TStringList     read FProgList    write FProgList;
    property Alive       : TKeepAlive      read FAlive       write SetAlive;
    property Reconnect   : Boolean         read FReconnect   write SetReconnect;
    property Disconnect  : TAutoDisconnect read FDisconnect  write SetDisconnect;
    property AskLater    : TAskLater       read FAskLater    write SetAskLater;
    property Active      : Boolean         read FActive      write SetActive;
    property ActiveSince : Dword           read FActiveSince;
    property MultiDial   : TMultiDial      read FMultiDial   write SetMultiDial;
    property DialAttemps : Integer         read FDialAttemps write SetDialAttemps;
    property DialPause   : Byte            read FDialPause   write SetDialPause;
    property AutoDial    : Boolean        read GetAutoDial   write SetAutoDial;
    property CurrentAttemp: Integer Read FCurrentAttemp write FCurrentAttemp;
    property IsSaved   : Boolean read GetIsSaved  write SetIsSaved;
    property Longer    : Boolean read FLonger;
    property DeviceName: String  read FDeviceName;
    property DeviceType: String  read FDeviceType;
    property RitState  : Dword   read FRitState;


    property OnStateChange : TStateChangeEvent read FOnStateChange write FOnStateChange;

  end;

{
 Why am I using a Timer? This takes memory and seems to be absolutely useless.
 Yes I would say: Yes, this I true. But when I started developping RasInTask, I
 found a stupid Bug In the Windows-API:

 From the RasCallback-Procedure, I cannot call "Dial" again (needed for Redial).
 If I do so, my application (and sometimes Windows) will crash. Please do not ask me
 why, but this is the fact.

 This is the text from the Win32SDK:

 Do not call the RasDial function from within a RasDialFunc1 callback
 function. You can call the RasGetConnectStatus, RasEnumEntries,
 RasEnumConnections, RasGetErrorString, and RasHangUp functions from within
 the callback function. For example, calling RasGetConnectStatus from within
 a callback function would be useful for determining the name and type of the
 connecting device.

 With the help of the timer, I can fix this: At the end of the callback procedure
 (or a procedure that is in the chain of the Callback), I Create and Initialize the dammed
 timer with a waiting time of 1 Second. Then, Windows (or is it the CPU) exits
 my procedure and the object does notihg but wait.
 Ater a short moment, the timer-event is raised. Then I will call the Redial-
 function and disable the timer.
}

function countExpressions(input: String): Integer;
function getExpression(str: String; nr: Integer): String;
// Here comes the declaration of the RasCallback-Procedure
procedure RasCallback(handle: ThRasConn; msg: Integer; state: TRasConnState; error, extended: Longint); stdcall;

implementation

Uses EncryptIt, Module, Main, Passwort, Multi, Optionen, connect, ConnectionChange, RasMan;

{ Debug }


{ TConnectionThread }

constructor TConnectionTHread.Create(Connection: TRitConnection; CreateSuspended: Boolean);
begin
  inherited Create(CreateSuspended);
  FreeOnTerminate := True;
  Priority:=tpLower;
  FConnection:=connection;
  FCheckAliveTime:=FConnection.FActiveSince;
  FCheckDisconnectTime:=FConnection.FActiveSince;
  FCheckRec := MainForm.StatsThread.RasBytesStats.BytesReceived;
  FCheckTrs := MainForm.StatsThread.RasBytesStats.BytesTransmitted;

end;

procedure TConnectionThread.KeepAlive;
var connection: TRitConnection;
begin
if FConnection.FMultiDial.FSourceIndex <> -1 then
 connection:=TRitConnection(MainForm.RasConnections[FConnection.FMultiDial.FSourceIndex])
else
 connection:=FConnection;
if Connection.FAlive.AliveType <> ktNone then
   begin
    if (integer(getTickCount) - FcheckAliveTime) > Connection.FAlive.Minutes * 60 * 1000 then
     begin
      Connection.SaveTheLive;
      FCheckAliveTime:=getTickCount;
     end;
   end;
end;

procedure TConnectionThread.Disconnect;
var connection:TRitConnection;
begin
if FConnection.FMultiDial.FSourceIndex <> -1 then
 connection:=TRitConnection(MainForm.RasConnections[FConnection.FMultiDial.FSourceIndex])
else
 connection:=FConnection;
Case connection.FDisconnect.DcType of
   dtAlways:   begin
                if (integer(getTickCount) - FCheckDisConnectTime) > Connection.FDisconnect.DcTime * 60 * 1000 then
                 begin
                  FCheckDisConnectTime := getTickCount;
                  Connection.ChangeConnection(false); //Disconnect, but display the Window first
                 end;
               end;
dtIntelligent: begin
                if (integer(getTickCount) - FCheckDisConnectTime) > Connection.FDisconnect.DcTime * 60 * 1000 then
                 begin
                  FCheckDisConnectTime := getTickCount;
                  if ((not(FCheckRec > MainForm.StatsThread.RasBytesStats.BytesReceived)) OR (not(FCheckTrs > MainForm.StatsThread.RasBytesStats.BytesTransmitted))) then
                    Connection.ChangeConnection(false);
                  FCheckRec := MainForm.StatsThread.RasBytesStats.BytesReceived;
                  FCheckTrs := MainForm.StatsThread.RasBytesStats.BytesTransmitted;
                 end;
               end;
  end;
end;


procedure TConnectionThread.Execute;
begin
 while not Terminated do
  begin
  Synchronize(KeepAlive);
  Synchronize(Disconnect);
  sleep(30000);
  end;          //I let the thread sleep for 30 seconds: KeepAlive and AutoDisconnect
end;            //have intervals of 1 Minute to set up. Calling this function every
                //second will use too much processor-time...


procedure TConnectionThread.Resume;
begin
 Inherited Resume;
 FCheckAliveTime      := FConnection.FActiveSince;
 FCheckDisconnectTime := FConnection.FActiveSince;
 FCheckRec            := MainForm.StatsThread.RasBytesStats.BytesReceived;
 FCheckTrs            := MainForm.StatsThread.RasBytesStats.BytesTransmitted;
end;

{ TRitConnection }

procedure TRitConnection.SetAutoDial(state:boolean);
  var
    entry: LPRasEntry;
    entrySize, devinfoSize: Integer;
    dll, func: string;
    ret: dword;
  begin
  if state then
    begin
     dll:=ExtractFilePath(Application.ExeName)+'RitAutoDial.dll';
     func:='RitAutoDial';
    end
  else
    begin
     dll:='';
     func:='';
    end;
  entrySize := 0;
  devinfoSize := 0;
  ret:= RasGetEntryProperties(nil, PChar(FName),
      nil, entrySize, nil, devinfoSize);
  if ret <> ERROR_BUFFER_TOO_SMALL then
    begin
    Exit;
    end;
  entry := AllocMem(entrySize);
  try
    entry^.dwSize := SizeOf(TRasEntry);
    if RasGetEntryProperties(nil, PChar(FName),
        entry, entrySize, nil, devinfoSize) = 0 then
      begin
       StrPCopy(entry^.szAutoDialDll, dll);
       StrPCopy(entry^.szAutoDialFunc, func);
       ret:= RasSetEntryProperties(nil, PChar(FName), entry, entrySize, nil, 0);
       if ret <> 0 then
        ShowMessage('fuck');
    end
  finally
    FreeMem(entry);
    end;
  end;

function TRitConnection.GetAutoDial: Boolean;
  var
    entry: LPRasEntry;
    entrySize, devinfoSize: Integer;
    ret: dword;
  begin
  result:=False;
  entrySize := 0;
  devinfoSize := 0;
  ret:= RasGetEntryProperties(nil, PChar(FName),
      nil, entrySize, nil, devinfoSize);
  if ret <> ERROR_BUFFER_TOO_SMALL then
    begin
    Exit;
    end;
  entry := AllocMem(entrySize);
  try
    entry^.dwSize := SizeOf(TRasEntry);
    if RasGetEntryProperties(nil, PChar(FName),
        entry, entrySize, nil, devinfoSize) = 0 then
      begin
       result := lowercase(entry^.szAutoDialDll) = lowercase(ExtractFilePath(Application.exename)+'RitAutoDial.dll');
      end;
  finally
    FreeMem(entry);
    end;
  end;



procedure TRitConnection.SetIsSaved(new: Boolean);
begin
 FIsSaved:=new;
 FMultiDial.IsSaved:=new;
end;


procedure TRitConnection.ChangeConnection(state: Boolean);
var ConnectionChangeForm: TConnectionChangeForm;
    ret: Integer;
begin
if not FConWinIsOpen then
 FConWinIsOpen := True
else
 Exit;
if MainFOrm.Options.Countdown = 0 then
 begin
 Case state of
 true:  begin
        if FHandle <> 0 then exit;
        Connect('');
        if MainForm.Options.Logging then
             RasManForm.CreateLogEntry(leInfo, Format(MainForm.languages.getString(308, MainForm.Options.language),[self.FName]));
        end;
 false: begin
        HangUp;
        if MainForm.Options.Logging then
         RasManForm.CreateLogEntry(leInfo, Format(MainForm.languages.getString(309, MainForm.Options.language),[self.FName]));
        end;
 end;
 exit;
 end;

ConnectionChangeForm:=TConnectionChangeForm.Create(Application);
with ConnectionChangeForm do
 begin
 Caption   :=FName;
 NewState  :=state;
 CountDown :=MainForm.Options.Countdown;
 end;
Try
 ret := ConnectionChangeForm.ShowModal;
finally
 ConnectionChangeForm.Free;
end;
Case state of
 true:  begin
        if ret = idOk then
         begin
         Connect('');
         if MainForm.Options.Logging then
            RasManForm.CreateLogEntry(leInfo, Format(MainForm.languages.getString(308, MainForm.Options.language),[self.FName]));
         end
        else
         begin
         HangUp; //This does not disconnect. We are already disconnected.
          end;
        end;     //thhe call is only for synchronizing the object with the reality
 false: begin
        if ret = idOk then
         begin
         if MainForm.Options.Logging then
            RasManForm.CreateLogEntry(leInfo, Format(MainForm.languages.getString(309, MainForm.Options.language),[self.FName]));
         HangUp;
         end
        end;
end;
FConWinIsOpen := false;

end;


procedure TRitConnection.EventTriggered;
begin
FHandle:=getHandle;
if FHandle <> 0 then
 begin
 FActive:=True;
 FRitState:=3;
 FLonger:=False;
 FActiveSince:=getTickCount;
 FConnectionThread.Resume;
 end
else
 begin
 if not FDisConnectionAllowed then
  begin
  if MainForm.Options.Logging then
    RasManForm.CreateLogEntry(leInfo, Format(MainForm.languages.getString(307, MainForm.Options.language),[self.FName]));
  if Freconnect then
   ChangeConnection(true) //Reconnect if disconnected
  else
   begin
   FDisConnectionAllowed:=False;
   FConnectionThread.Suspend;
   Active:=False;
   FRitState:=1;
   FLonger:=False;
   FActiveSince:=0;
   end
  end
 else
  begin
  FDisConnectionAllowed:=False;
  FConnectionThread.Suspend;
  Active:=False;
  FRitState:=1;
  FLonger:=False;
  FActiveSince:=0;
  end
 end;
end;


function TRitConnection.GetHandle: THandle;
var
  bufsize: Longint;
  numEntries: Longint;
  x: Integer;
  entries: Array[1..100] of TRasConn;
begin
Result:=0;
entries[1].dwSize := SizeOf(TRasConn);
bufsize := SizeOf(TRasConn) * 100;
if RasEnumConnections(@entries[1], bufsize, numEntries) = 0 then
  begin
  if numEntries > 0 then
    begin
    for x := 1 to numEntries do
      if FName = entries[x].szEntryName then
        Result:=entries[x].HRasConn;
    end;
  end
else
  ShowMessage('RasEnumConnections failed.');
end;

{
 This procedure reloads the Settings that are stored by the system. i use
 this procedure in the "Reload"-Button of the Options-Screen. I do not want that
 the User loses all his settings.

 Possibly, Renaming the connection within the DUN-Applet and then click
 on "Reload" will confuse RasInTask. I do not check this, since a workaround
 would be too much work:

 I'll put some lines into the readme.txt under "known issues"
}

procedure TRitConnection.ReloadRasOnly;
var tmp: String;
begin
FUserName:='';
FPassword:='';
GetRasOptions; //FUserName: set FPassword: set
tmp:=FPassWord;
getPassword;
if tmp <> FPassWord then //If getPassword sets FPassWord, then the user has checked the box
  FBugFix :=True;
end;

function TRitConnection.GetIsSaved: Boolean;
begin
Result:=False;
if (FIsSaved AND FMultiDial.IsSaved) then
 Result:=True;
isSaved:=Result;
end;

procedure TRitConnection.SetDialPause(new: Byte);
begin
 FDialPause :=new;
 FCountDown :=FDialPause+1;
 FIsSaved   :=False;

end;

procedure TRitConnection.Connect(source: String);
begin
//if (source <> '') then
// begin
// FSourceConnection:=source;
// FMultiDial.SourceConnection:=source;
// end;
 FCurrentAttemp:=0;
 Dial;
end;

procedure TRitConnection.TimerEventProc(Sender: TObject);
var i, ret:Integer;
begin
FDialTimer.Enabled:=False; //Turn the dammed timer off
Case FTimerType of
 ttHangUp: begin FTimerType:=ttNone; HangUp; end;
 ttRedial:
  begin
  HangUp;
  while FCountdown > 0 do
   begin
   dec(FCountdown);
   FDialTimer.Enabled :=True;
   FDialTimer.Interval:=1000;
   if Assigned(OnStateChange) then OnStateChange(self, 999, FCountdown, 0);
   Exit;
   end;
  FCountDown:=FDialPause + 1;
  FTimerType:=ttNone;
  Dial(true);
  end; //-->ttRedial: begin ....
 ttMultiDial:
 begin
HangUp;
 if FMultiDial.ListIndex > -1 then //This is only bigger than -1 when The rest of this procedure was
  begin                            //used once.
  if Assigned(FOnStateChange) then
   OnStateChange(self, 333, 0, 0);//MainForm has to proceed in MultiDialing!
  Exit;
  end;
 FCurrentAttemp:=0;//<--------------- MultiDial is enabled. Reset the Redial
                                   // counter, because the user may have selected
 If ConnectForm.Visible then       // this procedure again...
  begin
  connectForm.DoNotAsk:=true;
  ConnectForm.Close;
  connectForm.DoNotAsk:=False;
  end;
 FTimerType:=ttNone;
 if (FmultiDial.ShowWindow AND (FShowed = False)) then
  begin
   MultiForm:=TMultiForm.Create(Application);
   MultiForm.lvSrc.Items.Clear;
   MultiForm.lvDst.Items.Clear;
   For i:=0 to MainForm.RasConnections.Count - 1 do
    begin
    if (TRitConnection(MainForm.RasConnections[i]).Name) <> FName then //This connection should be the last
    with MultiForm.lvSrc.Items.Add do
     begin
      ImageIndex:=0;
      Caption:=TRitConnection(MainForm.RasConnections[i]).Name;
     end;
    end;
   with MultiForm.lvSrc.Items.Add do
    begin
     ImageIndex:=0;
     Caption:=FName;
    end;
   ret:=MultiForm.ShowModal;
   Case ret of
    idOk: begin
           if MultiForm.lvDst.Items.Count > 0 then
            begin
            for i:=0 to MultiForm.lvDst.Items.Count - 1 do
             FMultiDial.DialList.Add(MultiForm.lvDst.Items[i].Caption);
            MultiForm.Free;
            FShowed:=True;
            FTimerType := ttMultiDial;
            FDialTimer.Enabled:= True;
            Exit;
            end
           else
            begin
            HangUP; //Possibly, our connection is active --> Kill it!
            MultiForm.Free;
            FDialTimer.Enabled := False;
            FShowed:=False;
            Exit;
            end;
          end;
 idCancel:begin
            HangUP; //Possibly, our connection is active --> Kill it!
            MultiForm.Free;
            FDialTimer.Enabled := False;
            FShowed:=False;
            Exit;
          end;
   end;  //case ret of
  end; //if ShowWindow;
  FDialTimer.Enabled:=False;
  FTimerType:=ttNone;
  FShowed:=True;
  if Assigned(FOnStateChange) then
   OnStateChange(self, 222, 0, 0);
  FMultiDial.ListIndex:=MainForm.getMultiIndex(FName, FMultiDial.DialList);
 end; //ttMultiDial
end; //-->Case
end;

function TRitConnection.Dial(redial: boolean = false): Boolean;
var
  r: integer;
  c: Array[0..100] of Char;
  dialparams: TRasDialParams;
  PassForm: TPasswortForm;
begin
{
 HEEEEEEELLLLP!

 Please help me to find a solution to remove the next two lines from this part of
 the code! When I try to Open the ConnectForm from the Target of the OnStateChange-
 Event (MainForm.ConnectionEvent), My Application, somethimes Delpi and sometimes
 Windows will crash! I tried everything! I have full access to all objects
 (-> no memory-confilict, I think) and every other function of RasInTask works.

 Only if I try to show the Form in the Event, I will Crash my Application.

 The Debbuger of Delphi says the the Application is "running", but it does
 not go further with the connection. It stops, but it gets and handles every other
 events.

 Oh, yes: Closing the WIndow from teh event-procedure is no problem...

 Is this a Bug of the VCL (probably)? If anybody on this dammed world would pay
 for RasInTask althought it is Freeware, I could buy me Delphi 4 and test it..
}
If MainForm.Options.ConnectWindow then
 If not ConnectForm.Visible then
  ConnectForm.Show;
Result:=False;
Screen.Cursor := crHourglass;
if FMultiDial.SourceIndex = -1 then
 if not redial then
  RunProgs(true)
else
 begin
  if TRitConnection(MainForm.RasConnections[FMultiDial.SourceIndex]).MultiDial.UseProgs then
    if not redial then
     TRitConnection(MainForm.RasConnections[FMultiDial.SourceIndex]).RunProgs(true)
 end;
FillChar(dialparams, SizeOf(TRasDialParams), 0);
if FAskLater.Timeout = 0 then FAskLater.Timeout := -1;
if (FAskLater.AskName or FAskLater.AskPassword) then
 begin
 passForm:=TPasswortForm.Create(Application);
 passForm.labConnection.Caption :=FName;
 passForm.editUser.Text         :=FUserName;
 passForm.editPass.Text         :=FPassWord;
 if FAskLater.AskName then
      begin
       passForm.editUser.Enabled:=True;
       passForm.editUser.Color  :=clWindow;
       if FAskLater.SavePassword then passForm.editUser.Text := FUserName else passForm.editUser.Text:='';
//       passForm.editUser.Text   :=FUserName;
       if ((FUserName <> '') AND (FAskLater.Timeout<> -1)) then
        begin
        passForm.EnableTimer := True;
        passForm.Timeout     := FAskLater.Timeout;
        end;
      end;
     if FAskLater.AskPassword then
      begin
       passForm.editPass.Enabled:=True;
       passForm.editPass.Color  :=clWindow;
       if FAskLater.SavePassword then passForm.editPass.Text := FPassword else passForm.editPass.Text:='';
       if ((FPassword <> '') AND (FAskLater.Timeout <> -1)) then
        begin
        passForm.EnableTimer := True;
        passForm.Timeout     := FAskLater.Timeout;
        end;
       end;
     r:=passForm.ShowModal;
     if r = idCancel then begin passForm.Free; if FAskLater.Timeout = -1 then FAskLater.Timeout:=0; if ConnectForm.Visible then ConnectForm.CloseImmediately; Exit; end;
     Fusername:=passForm.editUser.Text;
     Fpassword:=passForm.editPass.Text;
     passForm.Free;
 end;
if FAskLater.Timeout = -1 then FAskLater.Timeout := 0;
with dialparams do
  begin
  dwSize := Sizeof(TRasDialParams);
  StrPCopy(szEntryName, FName);
  StrPCopy(szUserName, FUserName);
  StrPCopy(szPassword, FPassword);
  end;
if FHandle <> 0 then
 HangUp;
FHandle := 0;
  // Async dial
r := RasDial(nil,   // This field is ignored in Windows95
     nil,  // Phonebook: use default (not used on Win95)
     dialparams,
     1, // use callback function of type RASDIALFUNC1
     @RasCallback,   // callback function
     FHandle);
Inc(FCurrentAttemp);
if r <> 0 then
  begin
  FCurrentAttemp:=0;
  RasGetErrorString(r, c, 100);
  ShowMessage('RasDial failed: ' + c);
  end
else
 begin
 if FCurrentAttemp <> 1 then
  if assigned(OnStateChange) then OnStateChange(Self, 888, FCurrentAttemp, FDialAttemps);
 Result:=True;
 end;
Screen.Cursor := crDefault;
end;

function  TRitConnection.HangUp(ask: boolean = false): Boolean;
var stat: TRasConnStatus;
begin
result:=True;
{ Little comment about the following if-clause after itself...}
if ask then
 begin
 ChangeConnection(false);
 exit;
 end;
if FHandle = 0 then
 begin
 if MainForm.Options.Logging then
   RasManForm.CreateLogEntry(leInfo, Format(MainForm.languages.getString(307, MainForm.Options.language),[self.FName]));
 FRitState:=1;
 FConnectionThread.Suspend;
 FActive:=False;
 FLonger:=False;
 FMultiDial.SourceIndex:=-1;
 MainForm.createMenu;
 Exit;
 end;
{ The calls above seem first to be unnecessary. But in fact, the are. Let me
  explain this: If the user disconnects over the popup-menu of rasintask, the
  synchronisation of this object is doe at the end of this procedure since
  the disconnection is done in the next lines.

  But if the connection is cancelled or disconnected with another progam,
  this function gets called by ChangeConnection, if the user decided not
  to reconnect. Now fHandle is correctely set to 0, but the other values still
  have to be synchronized. I do this here.
}
FillChar(stat, SizeOf(TRasConnStatus), 0);
stat.dwSize:=SizeOf(TRasConnStatus);
Result:=True;
FDisConnectionAllowed:=True;
RasHangUp(FHandle);
sleep(500);
While RasGetConnectStatus(FHandle, stat) <> ERROR_INVALID_HANDLE do
 begin;
 sleep(100);
 Application.ProcessMessages;
 end;
FHandle:=0;
FRitState:=1;
FConnectionThread.Suspend;
FActive:=False;
FLonger:=False;
FMultiDial.SourceIndex:=-1;
MainForm.CreateMenu;
end;

procedure TRitConnection.SetDialAttemps(new: Integer);
begin
{
 First: Byte would be enough: I do not think that anyone on this world
        would let dial his modem more than 255 times the same number, but
        you never know...
}
FDialAttemps:=new;
FIsSaved:=False;
end;

procedure TRitConnection.SetActive(new: Boolean);
begin
 Case new of
  true: begin
        FActive      :=True;
        FRitState    :=3;
        FActiveSince :=GetTickCount;
        FLonger      :=False;
        FConnectionThread.Resume;
         if Assigned(OnStateChange) then OnStateChange(self, 3 , 0, 0);
        end;
  false:begin
        FConnectionThread.Suspend;
        FActive      :=False;
        FRitState    :=1;
        FActiveSince :=0;
        FLonger      :=False;
        if Assigned(OnStateChange) then OnStateChange(self, 1,0,0);
        end;
 end;
FDisConnectionAllowed:= not FActive;
end;

procedure TRitConnection.SetMultiDial(new: TMultiDial);
begin
 FMultiDial.DialList   := new.DialList;
 FMultiDial.UseProgs   := new.UseProgs;
 FMultiDial.Active     := new.Active;
 FMultiDial.ShowWindow := new.ShowWindow;
 FMultiDial.IsSaved    := False;
 FIsSaved:=False;
end;

{ I have to delete the Keys recursive, because under NT, the DeleteKey-
  method will fail if the key has some subkeys.

  This is a limitation from which Borland seems not to know anything:
  In the Delphi-Helpfile you can't read about this. You must have a look
  at Win32.hlp!
}

procedure TRitConnection.DeleteEntries;
var Reg:Tregistry;
begin
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_CURRENT_USER;
Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\MultiDial', true);
Reg.DeleteKey('DialList');
Reg.CloseKey;
Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName, true);
Reg.DeleteKey('Programs');
Reg.DeleteKey('KeepAlive');
Reg.DeleteKey('MultiDial');
Reg.CloseKey;
Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\', true);
Reg.DeleteKey(FName);
Reg.CloseKey;
Reg.Free;
FIsSaved:=True;           //I do that to be sure, that the object will not write it's settings
FMultiDial.IsSaved:=True; //again...
end;

procedure TRitConnection.SaveTheLive;
begin
if FAlive.AliveType <> ktNone then
begin
TCPModule.http.URL:=FAlive.URL;
if FAlive.AliveType = ktPing then
 begin
    TCPModule.Ping.DnsLookup(FAlive.URL);
 end //if
else
 begin
 TCPModule.http.get;
 end;
end;
end;


procedure TRitConnection.SetAlive(new: TKeepAlive);
begin
FisSaved:=False;
FAlive.AliveType:=new.AliveType;
FAlive.URL:=new.URL;
FALive.Minutes:=new.Minutes;
end;

procedure TRitConnection.SetDisconnect(new: TAutoDisconnect);
begin
FisSaved:=False;
FDisconnect.DcType:=new.DcType;
FDisconnect.DcTime:=new.DcTime;
end;

procedure TRitConnection.SetAskLater(new: TAskLater);
begin
FisSaved:=False;
FAskLater.AskName     :=new.AskName;
FAskLater.AskPassword :=new.AskPassword;
FAskLater.Timeout     :=new.Timeout;
FAskLater.SavePassword:=new.SavePassword;
end;


procedure TRitConnection.SetBugFix(new: Boolean);
begin
FIsSaved:=False;
if new = True then
 begin
  If CanSave then
   if MessageBox(Application.Handle, PChar(MainForm.Languages.getString(113, MainForm.Options.Language)), PChar(MainForm.Languages.getString(109, MainForm.Options.Language)),mb_YesNo or mb_iconQuestion or MB_SETFOREGROUND) = idYes then
    FBugFix:=True
   else
     FBugFix:=False;
 end
else
 FBugFix:=False;
end;

procedure TRitConnection.SetReconnect(new: Boolean);
begin
FIsSaved:=False;
FReconnect := new;
end;

procedure TRitConnection.Setsinautodial(new: Boolean);
begin
FIsSaved:=False;
Fsinautodial := new;
end;


procedure TRitConnection.SetName(new: String);
begin
FisSaved:=False;
FNewName:=new;
end;

procedure TRitConnection.SetUserName(new: String);
begin
FisSaved:=False;
FUserName:=new;
end;

procedure TRitConnection.SetPassWord(new: String);
begin
FisSaved:=False;
FPassWord:=new;
end;


constructor TRitConnection.Create(name: String; virt:Boolean);
begin
inherited Create;
if name = '' then
 begin
 Raise Exception.Create('Parameter ''name'' not correct!');
 Free;
 end;
FConnectionThread:=TConnectionThread.Create(self, true);
FSourceConnection:=''; //-->You know....
FName:=name;   //FName: set
FUserName:='';
FPassword:='';
FProgList:=TStringList.Create;
FDialAttemps:=1;
FProgList.Clear;
FIsSaved:=True;
FCurrentAttemp:=0;
FNewName:='';
FShowed:=False;
FTimerType:=ttNone;
FMultiDial:=TMultiDial.Create(FName);
FReconnect:=False;
FDisconnect.DcType:=dtNone;
FDisconnect.DcTime:=3;
with FAlive do
 begin
  AliveType:=ktNone;
  URL:='www.microsoft.com';
  Minutes:=10;
 end;
FDialTimer:=TTimer.Create(nil);
FDialTImer.Enabled:=False;
with FAskLater do
 begin
  AskName    :=False;
  AskPassword:=False;
 end;
Fad:=GetAutoDial;
loadSettings;
FHandle := getHandle;
if FHandle <> 0 then
 begin
 FActive      := True;
 FRitState    := 3;  //-->Connected
 FActiveSince := GetTickCount; //-->Set a time stamp
 FConnectionThread.Resume;
 FLonger      := True;         // --> Already connected when created: Time not correct!
 if Assigned(OnStateChange) then OnStateChange(self, 3, 0, 0); //-->Fire the Event (I don't think that this will reach the                                                                               {program}
 end;
FDisConnectionAllowed:= not FActive;
end;

procedure TRitConnection.getRasOptions;
var fp         : LongBool;
    r          : Longint;
    dialparams : TRasDialParams;
       entry   : LPRasEntry;
    entrySize, devinfoSize: Integer;
    ret:Dword;
begin
  FillChar(dialparams, SizeOf(TRasDialParams), 0);
  with dialparams do
    begin
    dwSize := Sizeof(TRasDialParams);
    StrPCopy(szEntryName, FName);
    end;
  r := RasGetEntryDialParams(nil, dialparams, fp);
  if r = 0 then
    with dialparams do
      begin
      FUserName := szUserName;
      if fp then
        FPassWord := szPassword;
      end;
 entrySize := 0;
 devinfoSize := 0;
 if RasGetEntryProperties(nil, PChar(FName),
      nil, entrySize, nil, devinfoSize) <> ERROR_BUFFER_TOO_SMALL then
    begin
    ShowMessage('RasGetEntryProperties failed. --');
    Exit;
    end;
  entry := AllocMem(entrySize);
  try
    entry^.dwSize := SizeOf(TRasEntry);
    ret:= RasGetEntryProperties(nil, PChar(FName),
        entry, entrySize, nil, devinfoSize);
    if ret = 0 then
      begin
        FDeviceName := entry.szDeviceName;
        FDeviceType := entry.szDeviceType;
      end
    else
      ShowMessage('RasGetEntryProperties failed.' + IntToStr(ret))
  finally
    FreeMem(entry);
  end;
end;



procedure TRitConnection.getPassword;
var Reg:TRegIniFile;
    pass:String; //The password
begin
 Reg:=TRegIniFile.Create('\Software\PH-Arts\RasInTask\');
 pass:=Reg.ReadString('Connections\'+FName, 'password', '');
 Reg.Free;
  if pass = '' then
   begin
    exit;
   end;
 FPassWord:=Decrypt(pass, 8533);
end;

procedure TRitConnection.loadSettings;
var tmp: String;
    Reg: TRegistry;
begin
UndoAutoDial;
FMultiDial.load;
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_CURRENT_USER;
GetRasOptions; //FUserName: set FPassword: set
tmp:=FPassWord;
getPassword;
if tmp <> FPassWord then //If getPassword sets FPassWord, then the user has checked the box
  FBugFix :=True;

Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\', true);

With FAskLater do
 begin
  if Reg.ValueExists('AskForName') then
   AskName:=Reg.ReadBool('AskForName');
  if Reg.ValueExists('AskForPassword') then
   AskPassword:=Reg.ReadBool('AskForPassword');
  if Reg.ValueExists('SavePwdInAsk') then
   SavePassword:=Reg.ReadBool('SavePwdInAsk');
  if Reg.ValueExists('TimeInAsk') then
   Timeout:=Reg.ReadInteger('TimeInAsk');
 end;
if FAskLater.AskName then
 FUserName:='';
if FAskLater.AskPassword then
 FPassword:='';
With FDisconnect do
 begin
  if Reg.ValueExists('DisconnectType') then
   Case Reg.ReadInteger('DisconnectType') of
    0: DcType:=dtNone;
    1: DcType:=dtAlways;
    2: DcType:=dtIntelligent;
   end;
  if Reg.ValueExists('DisconnectTime') then
   DcTime:=Reg.ReadInteger('DisconnectTime');
 end;
If Reg.ValueExists('SInAutoDial') then
 Fsinautodial:=Reg.ReadBool('SInAutoDial');
if Reg.ValueExists('DialAttemps') then
 FDialAttemps:=Reg.ReadInteger('DialAttemps');
if Reg.ValueExists('DialPause') then
 FDialPause:=Reg.ReadInteger('DialPause');
FCountDown := FDialPause + 1;
Reg.CloseKey;

Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\Programs\', true);
Reg.GetValueNames(FProgList);
Reg.CloseKey;

Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\KeepAlive\', true);
If Reg.GetDataType('Active') = rdString	then
 Reg.DeleteValue('Active');
If Reg.ValueExists('Reconnect') then
 FReconnect:=Reg.ReadBool('Reconnect');
If Reg.ValueExists('Active') then
 If not Reg.ReadBool('Active') then
  FAlive.AliveType:=ktNone
 else
  begin
   FAlive.URL:=Reg.ReadString('Server');
   if Reg.ReadString('Method') = 'http' then
    FAlive.AliveType:=ktHttp
   else
    FAlive.AliveType:=ktPing;
   FAlive.Minutes:=Reg.ReadInteger('BeginAfter');
  end
else
 FAlive.AliveType:=ktNone;
Reg.CloseKey;
Reg.Free;
FIsSaved:=True;
end;

procedure TRitConnection.writeSettings;
var Reg: TRegistry;
    i  : Integer;
begin
FMultiDial.save;
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_CURRENT_USER;
if FNewName <> '' then
 begin
 if RasRenameEntry(nil, PChar(FName), PChar(FNewName)) <> 0 then
  begin
  Raise Exception.Create('Cannot rename RAS-Entry');
  FNewName := '';
  exit;
  end
 else
  begin
  Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\MultiDial', true);
  Reg.DeleteKey('DialList');
  Reg.CloseKey;
  Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName, true);
  Reg.DeleteKey('KeepAlive');
  Reg.DeleteKey('Programs');
  Reg.DeleteKey('MultiDial');
  Reg.CloseKey;
  Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\', true);
  Reg.DeleteKey(FName);
  Reg.CloseKey;
  FName:=FNewName;
  FNewName:='';
  end;
 end;
SavePassword; //Determines if BugFix neccesary...
Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\', true);
With FAskLater do
 begin
  Reg.WriteBool('AskForName', AskName);
  Reg.WriteBool('AskForPassword', AskPassword);
  Reg.WriteBool('SavePwdInAsk', SavePassword);
  Reg.WriteInteger('TimeInAsk', Timeout);
 end;
With FDisconnect do
 begin
  Case DcType of
   dtNone:        i:=0;
   dtAlways:      i:=1;
   dtIntelligent: i:=2;
   else i:=0; //To get the compiler to stop warning me
  end;
  Reg.WriteInteger('DisconnectType', i);
  Reg.WriteInteger('DisconnectTime', DcTime);
 end;

Reg.WriteInteger('DialAttemps', FDialAttemps);
Reg.WriteBool('SInAutoDial', FsInAutoDial);
Reg.WriteInteger('DialPause', FDialPause);

Reg.DeleteKey('Programs');
Reg.CloseKey;

Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\Programs\', true);
for i:=0 to FProgList.Count-1 do
 Reg.WriteString(FProgList[i], 'dedicated to barbara');
Reg.CloseKey;

Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\KeepAlive\', true);
if FAlive.AliveType <> ktNone then
 begin
  Reg.WriteString('Server', FAlive.URL);
  If FAlive.AliveType=ktHttp then
   Reg.WriteString('Method', 'http')
  else
   Reg.WriteString('Method', 'ping');
  Reg.writeBool('Active', true);
  Reg.WriteInteger('BeginAfter', FAlive.Minutes);
 end
else
 Reg.writeBool('Active', false);
Reg.WriteBool('Reconnect', FReconnect);
if FAlive.URL = '' then
begin
 FAlive.AliveType:=ktNone;
 Reg.writeBool('Active', false);
end;

FIsSaved:=True;
Reg.CloseKey;
Reg.Free;
fad:=getautodial;
end;

procedure TRitConnection.SavePassword;
var Reg      :TRegistry;
    dialparam:TRasDialParams;
begin
if FBugFix then
 begin
  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_CURRENT_USER;
  Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FName+'\', true);
  Reg.WriteString('password', Encrypt(FPassWord, 8533));
  Reg.CloseKey;
  Reg.Free;
 end;
  FillChar(dialparam, SizeOf(TRasDialParams), 0);
  with dialparam do
   begin
    dwSize := Sizeof(TRasDialParams);
    StrPCopy(szEntryName, FName);
    StrPCopy(szUserName,  FUserName);
    StrPCopy(szPassword,  FPassword);
   end; //end with
  if RasSetEntryDialParams(nil, dialparam, False) <> 0 then
      ShowMessage ('RasSetEntryDialParams failed.');
end;

function CountCharInString(Ch : Char; const S : string) : Integer;
var
  I : Integer;
begin
Result := 0;
for I := 1 to Length(S) do
  if Ch = S[I] then Inc(Result);
end;

function countExpressions(input: String): Integer;
begin
result:=(CountCharInString('"', input) div 2);
if Result = 0 then result:=-(CountCharInString(' ', input)+1);
end;

function getExpression(str: String; nr: Integer): String;
var i, j: Integer;
begin
 if nr < 0 then nr:= -nr;
 if countExpressions(str) <= -2 then
  begin
  i:=0;
  j:=0;
  while ((i < Length(str)) AND (j < nr )) do
   begin
   Result:=Copy(str,i+1,pos(' ', Copy(str,i+1,length(str)-i)) - 1);
   i:=pos(' ', Copy(str,i+1,length(str)-i))+i;
   inc(j);
   end;
  if j > nr then
   Result:='';
  end;
 if ((countExpressions(str)=0) OR (countExpressions(str) = -1)) then
  Result:=str;
 if countExpressions(str) >= 1 then
  begin
  i:=0;
  j:=0;
   while ((i < Length(str)) AND (j < nr )) do
   begin
   Result:=Copy(str,pos('"', Copy(str,i,length(str)-i)) - 1 + i, pos('"', Copy(str,i+2,length(str)-i))+1);
   i:=Pos('"', Copy(str,pos('"', Copy(str,i+2,length(str)-i))+2, length(str)-(i+1)+1))+ pos('"', Copy(str,i+2,length(str)-i))+i;
   inc(j);
   end;
  if j > nr then
   Result:='';
  end;
end;

procedure TRitConnection.runProgs(before: Boolean);  //Was in dial.pas the versions before
var x, ltime, ltype:integer;     // \
    cmd, param, prog:String;            //  -> Will be true if the function should call the programs before connection
begin
 if FProgList.count > 0 then
 begin
  for x:=0 to FProgList.count-1 do
   begin
    prog  :=GetToken(FProgList[x], '|', 1);
    if GetToken(FProgList[x], '|', 2) <> '' then ltype :=StrToInt(GetToken(FProgList[x], '|', 2)) else ltype:=0;
    if GetToken(FProgList[x], '|', 3) <> '' then ltime :=StrToInt(GetToken(FProgList[x], '|', 3)) else ltime:=1;
    Case ltype of
     0: ltype:=SW_SHOWNOACTIVATE;
     1: ltype:=SW_SHOWMAXIMIZED;
     2: ltype:=SW_SHOWMINNOACTIVE;
    end;
    if (((ltime = 0) AND (before = true)) OR ((ltime <> 0) AND (before = false))) then
    begin
     param:=GetToken(FProgLIst[x], '|', 4);
     param:=trim(param);

     //if
     ShellExecute(Application.Handle,
                     'open',
                     PChar(prog),
                     PChar(param),
                     PChar(ExtractFilePath(cmd)),
                     ltype);// < 31 then
        //MessageBox(Application.Handle, PChar(Format(MainForm.Languages.getString(81, MainForm.Options.Language), [prog])), PChar(MainForm.Languages.getString(93, MainForm.Options.Language)), mb_ok or mb_iconstop or MB_SETFOREGROUND);
   end;
  end; //for...
 end;  //if not lbprog.items.count=0
end;   //procedure...

procedure TRitConnection.Save;
begin
 writeSettings;
end;

procedure TRitConnection.UnDo;
begin
 loadSettings;
end;

destructor TRitConnection.Destroy;
begin
FDialTimer.Free;
FProgList.Free;
FConnectionThread.Terminate;
FMUltiDial.Free;
inherited destroy;
end;

procedure TRitConnection.UndoAutoDial;
begin
if fad <> getAutoDial then
 setAutoDial(fad);
end;

function TRitConnection.CanSave:Boolean;
 var old, akt:String;
     dialparams: TRasDialParams;
begin
FillChar(dialparams, SizeOf(TRasDialParams), 0);
akt:=FPassword;
old:=akt;
if akt <> '' then akt:='test';

 with dialparams do //Try to save;
      begin
      dwSize := Sizeof(TRasDialParams);
      StrPCopy(szEntryName, FName);
      StrPCopy(szUserName,  FUserName);
      StrPCopy(szPassword,  FPassword);
      end;
    if RasSetEntryDialParams(nil, dialparams, False) <> 0 then
      begin
       Result:=False;
       exit;
      end;
getRasOptions;
akt:=FPassword;

if akt <> old then //Compare saved entry with loaded
 Result:=False
else
 Result:=True;

FPassword:=old; //undo changes during the test
end;

{ TMultiDial }

procedure TMultiDial.SetDialList( new: TStringList );
begin
 FDialList.Clear;
 FDialList.Assign(new);
 fIsSaved:=False;
end;

procedure TMultiDial.SetUseProgs( new: Boolean );
begin
 FUseProgs:=new;
 fIsSaved:=False;
end;

procedure TMultiDial.SetUseKeep( new: Boolean );
begin
 FUseKeep:=new;
 fIsSaved:=False;
end;

procedure TMultiDial.SetUseDisc( new: Boolean );
begin
 FUseDisc:=new;
 fIsSaved:=False;
end;


procedure TMultiDial.SetActive( new: Boolean );
begin
 FActive:=new;
 fIsSaved:=False;
end;

procedure TMultiDial.SetShowWindow( new: Boolean );
begin
 FShowWindow:=new;
 fIsSaved:=False;
end;


constructor TMultiDial.Create(Connection: String);
begin
  FDialList    :=TStringList.Create;
  FConnection  := connection;
  FUseProgs    := False;
  FActive      := False;
  FShowWindow  := False;
  FIsSaved     := True;
  FListIndex   :=-1;
  FSourceIndex :=-1;
  load;
end;

destructor TMultiDial.Destroy;
begin
 FDialList.Free;
 inherited destroy;
end;

procedure TMultiDial.load;
var Reg: TRegistry;
begin
 Reg:=TRegistry.Create;
 Reg.RootKey := HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FConnection+'\MultiDial\', true);
 if Reg.ValueExists('UseProgs') then
  FUseProgs := Reg.ReadBool('UseProgs');
 if Reg.ValueExists('UseDisc') then
  FUseDisc := Reg.ReadBool('UseDisc');
 if Reg.ValueExists('UseKeep') then
  FUseKeep := Reg.ReadBool('UseKeep');
 if Reg.ValueExists('Active') then
  FActive := Reg.ReadBool('Active');
 if Reg.ValueExists('ShowWindow') then
  FShowWindow := Reg.ReadBool('ShowWindow');
 Reg.CloseKey;

 Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FConnection+'\MultiDial\DialList', true);
 Reg.GetValueNames(FDialList);
 Reg.CloseKey;

 Reg.Free;
 fIsSaved:=True;
end;

procedure TMultiDial.save;
var Reg: TRegistry;
    x  : Integer;
begin
 Reg:=TRegistry.Create;
 Reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FConnection+'\MultiDial\', true);
 Reg.WriteBool('UseProgs', FUseProgs);
 Reg.WriteBool('UseKeep', FUseKeep);
 Reg.WriteBool('UseDisc', FUseDisc);
 Reg.WriteBool('Active', FActive);
 Reg.WriteBool('ShowWindow', FShowWindow);
 Reg.CloseKey;
 Reg.OpenKey('\Software\PH-Arts\RasInTask\Connections\'+FConnection+'\MultiDial\DialList', true);
 for x:=0 to FDialList.Count-1 do
  Reg.WriteString(FDialList[x], IntToStr(x));
 Reg.CloseKey;
 Reg.Free;
 fissaved:=True;
end;


{
 Maybe you are shoked about the fact that I have full access to the private
 members of the RitConnection object. This is not a bug. This is a feature
 (and it is documented): Every Procedures and every Classes in one unit
 are "friends".

 This is a stupid technique of the OOP, but it is quite usably...
}

procedure RasCallback(handle: ThRasConn; msg: Integer; state: TRasConnState; error, extended: Longint); stdcall;
var i  : Integer;
    obj: TRitConnection;
begin
//First, let us get the correct Connection-Object
obj:=nil;
for i:=0 to MainForm.RasConnections.Count - 1 do
 if TRitConnection(MainForm.RasConnections[i]).Handle = handle then
  obj := TRitConnection(MainForm.RasConnections[i]);
if not Assigned(obj) then
 Exit;
{
 Of course, I could pack the following lines in a with obj do begin-clause,
 but I had to worry about one 'end' more and I think that 7 end's in only
 onde procedure are enought...
}

if error <> 0 then   //If we have an error, close the connection
 begin
  Case error of
   ERROR_REMOTE_DISCONNECTION, ERROR_SERVER_OUT_OF_RESOURCES, ERROR_SERVER_NOT_RESPONDING,
   ERROR_UNRECOGNIZED_RESPONSE, ERROR_NO_RESPONSES, ERROR_NO_CONNECTION,
   ERROR_READING_MAXCONNECTBPS, ERROR_READING_MAXCARRIERBPS, ERROR_LINE_BUSY,
   ERROR_VOICE_ANSWER, ERROR_NO_ANSWER, ERROR_NO_CARRIER, ERROR_PPP_TIMEOUT,
   ERROR_PPP_REMOTE_TERMINATED, ERROR_PPP_NO_RESPONSE : obj.FAllowedToRedial:=True;
  else
   obj.FAllowedToRedial:=False;
  end; //case error of
 If Assigned(obj.OnStateChange) then obj.OnStateChange(obj, 2, state, error);
 end //if error <> 0
else //ok: No error
 begin
  if state = RASCS_Connected then
   begin
    if obj.AskLater.AskName then
     obj.FName:='';
    if obj.AskLater.AskPassword then
     obj.FPassword:='';
    obj.FActive     :=True;
    obj.FRitState   :=3;
    obj.FActiveSince:=GetTickCount;
    obj.FConnectionThread.Resume;
    obj.FMultiDial.FListIndex:=-1;
    obj.FDisConnectionAllowed:= false;
    if MainForm.Options.Anim then
         if MainForm.NT then
          MainForm.LaunchRasMon;
    if obj.FMultiDial.SourceIndex = -1 then
     obj.RunProgs(false)
    else
     begin
     if TRitConnection(MainForm.RasConnections[obj.FMultiDial.SourceIndex]).MultiDial.UseProgs then
      TRitConnection(MainForm.RasConnections[obj.FMultiDial.SourceIndex]).RunProgs(false)
     end;
    if Assigned(obj.OnStateChange) then obj.OnStateChange(obj, 3,state, error);
   end
  else //-->Standart, RasEvent
    begin
    obj.FRitState:=2;
    if Assigned(obj.OnStateChange) then obj.OnStateChange(obj, 2, state, error);
    end;
 end; // Else of if error <> 0
 if (((obj.FCurrentAttemp >= obj.FDialAttemps) AND (obj.FMultiDial.Active) AND (error <> 0)) OR (obj.FSourceConnection <> '')) then
  begin
  obj.FTimerType:=ttMultiDial;
  obj.FDialTimer.Enabled:=False;
  obj.FDialTimer.Interval:=500;
  obj.FDialTimer.OnTimer:=obj.TimerEventProc;
  obj.FDialTimer.Enabled:=True;
  Exit;
  end
 else                                            //see helpfile for this!
 if ((error <> 0) AND (NOT obj.FallowedToRedial) AND (error <> ERROR_USER_DISCONNECTION)) then
  begin
  if Assigned(obj.OnStateChange) then obj.OnStateChange(obj, 777, state, error);
  if obj.AskLater.AskName then
   obj.FName:='';
  if obj.AskLater.AskPassword then
   obj.FPassword:='';
  obj.FRitState:=1;
  obj.FLonger:=False;
  obj.FTimerType:=ttHangUp;
  obj.FDialTimer.Enabled:=False;
  obj.FDialTimer.Interval:=500;
  obj.FDialTimer.OnTimer:=obj.TimerEventProc;
  obj.FDialTimer.Enabled:=True;
  obj.FConnectionThread.Suspend;
  Exit;
  end;
 if ((error <> 0) AND (error = ERROR_USER_DISCONNECTION)) then
  begin
  if obj.AskLater.AskName then
   obj.FName:='';
  if obj.AskLater.AskPassword then
   obj.FPassword:='';
  if Assigned(obj.OnStateChange) then obj.OnStateChange(obj, 555, state, error);
  obj.FAllowedToRedial:=False;
  obj.FLonger:=False;
  obj.FRitState:=1;
  obj.FTimerType:=ttHangUp;
  obj.FDialTimer.Enabled:=False;
  obj.FDialTimer.Interval:=500;
  obj.FDialTimer.OnTimer:=obj.TimerEventProc;
  obj.FDialTimer.Enabled:=True;
  Exit;
  end;
 obj.FAllowedToRedial := (obj.FCurrentAttemp < obj.FDialAttemps);
 if ((error <> 0) AND obj.FallowedToRedial) then
  begin
  obj.FTimerType := ttRedial;
//  obj.HangUP;
  obj.FDialTimer.Enabled:=False;
  obj.FDialTimer.Interval:=500;
  obj.FDialTimer.OnTimer:=obj.TimerEventProc;
  obj.FDialTimer.Enabled:=True;
  end;
 if ((NOT obj.FAllowedTORedial) AND (error <> 0)) then //->Last Try overpassed. No MultiDial
  begin
  if Assigned(obj.OnStateChange) then obj.OnStateChange(obj, 666, state, error);
  obj.FRitState:=1;
  obj.FLonger:=False;
  obj.FTimerType:=ttHangUp;
  obj.FDialTimer.Enabled:=False;
  obj.FDialTimer.Interval:=500;
  obj.FDialTimer.OnTimer:=obj.TimerEventProc;
  obj.FDialTimer.Enabled:=True;
  Exit;
  end;
end;

{
  ****************
  * MultiDial    *
  ****************

  As I said many times bevore: This is really compley, since every connection has it's own
  Dialing routines. The Problem was: How to dial the next Connection in the list? How to find it?
  How to get Login-Values and finally: How to do it clean?

  What I first tried was theoretically ok, but did not work, because it was too
  OOP for Delphi..

  First the program did not What I wished that it does and second, I got many
  gpf's in RNAAPP.DLL and even access violations in Kernel32.dll!

  I thought that I must do the MultiDial in a different way which is unfortunally
  not as clean as my first way:

  My big problem was that the stuff must also work if more than one connection
  is beeing dialed at a time. Where to store the administrative data?

  If MultiDial is fired first, this object will call MaiNForm.getListIndex.
  This function creates a pMultiInfo-pointer-of-record and the stringlist in it, to
  which the current FMutliDial.DialIndex will be assigend. The rest does MainForm!

  Now MainForm reads the DialList of the MultiDial-Object of the connection that
  failed in a dynamically created _TList of TStringList_ (!!!!). This TList
  (I love this object!) is created in TMainForm.FormCreate and freed in
  TMainForm.destroy (finally It does not matter to create one TList more since
  the "default-user" has more than 16MB of RAM, but anyway: I hate it to
  request much of memory, but the better solution did not work, because Delphi
  is so stupid).

  But back to the MultiDial: Now MainForm has the full control of the whole
  MultiDial. Over the ConnectionEvent-Procedure, MainForm knows when to dial the
  next Connection (one if more...).
  The index of the currentely active connection is stored in the second member of
  the TRitInfo-Record: "Index".
  You do not understand this? Read Main.pas! The essential procedures are

         -TMainForm.FormCreate;
         -TMainForm.Destroy;
         -TMainForm.ConnectionEvent;
  }

end.


