unit ieoptions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Registry, Rasext;

type

  TIEOptions = class(TObject)
  private
   FIE4: Boolean;
   FCompanyName: String;
   FUseCache: Boolean;
   FWinTitle: String;
   FURLS: TStringList;
   FIsSaved: Boolean;

   procedure loadSettings;
   procedure saveSettings;

   procedure SetCompanyName(new: String);
   procedure SetUseCache(new: Boolean);
   procedure SetWinTitle(new:String);
   procedure SetURLS(new:TStringList);
  public
    constructor Create;
    destructor  Destroy; Override;

    procedure undo;
    procedure save;

    property IE4          : Boolean     read FIE4;
    property CompanyName  : String      read FCompanyName write SetCompanyName;
    property UseCache     : Boolean     read FUseCache    write SetUseCache;
    property WinTitle     : String      read FWinTitle    write SetWinTitle;
    property URLS         : TStringList read FURLS        write SetURLS;
    property IsSaved      : Boolean     read FIsSaved     write FIsSaved;
  end;

implementation

procedure TIEOptions.setCompanyName(new:String);
begin
FIsSaved:=False;
FCompanyName:=new;
end;

procedure TIEOptions.setUseCache(new:Boolean);
begin
FIsSaved:=False;
FUseCache:=new;
end;


procedure TIEOptions.setWinTitle(new:String);
begin
FIsSaved:=False;
FWinTitle:=new;
end;


procedure TIEOptions.setURLS(new:TStringList);
begin
FIsSaved:=False;
FURLS.Clear;
FURLS.Assign(new);
end;


constructor TIEOptions.Create;
begin
inherited Create;
FIE4         :=False;
FIsSaved     :=True;
FUseCache    :=True;
FCompanyName :='';
FWinTitle    :='';
FURls:=TStringList.Create;
loadSettings;
end;

destructor TIEOptions.Destroy;
begin
FUrls.Free;
inherited destroy;
end;

procedure TIEOptions.LoadSettings;
var Reg     :TRegistry;
    templist:TStringList;
    i       :Integer;
begin
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_LOCAL_MACHINE;
if not Reg.KeyExists('\SOFTWARE\Microsoft\IE4\') then
 begin
 Reg.Free;
 FIE4:=False;
 Exit;
 end;
FIE4:=True;
Reg.OpenKey('\SOFTWARE\Microsoft\Internet Explorer\Main', True);
if Reg.ValueExists('Enable_Disk_Cache') then
 FUseCache    := (Reg.ReadString('Enable_Disk_Cache') = 'yes');
if Reg.ValueExists('CompanyName') then
 FCompanyName := Reg.ReadString('CompanyName');
if Reg.ValueExists('Window Title') then
 FWinTitle := Reg.ReadString('Window Title');
Reg.CloseKey;
Reg.OpenKey('\SOFTWARE\Microsoft\Internet Explorer\Main\UrlTemplate', True);
templist:=TStringList.Create;
Reg.GetValueNames(templist);
For i:=0 to templist.Count -1 do
 FUrls.Add(Reg.ReadString(templist[i]));
templist.Free;
Reg.CloseKey;
Reg.Free;
FIsSaved:=True;
end;

procedure TIEOptions.saveSettings;
var Reg:TRegistry;
    i  :Integer;
begin
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_LOCAL_MACHINE;
Reg.OpenKey('\SOFTWARE\Microsoft\Internet Explorer\Main', true);
If FUseCache then
 Reg.WriteString('Enable_Disk_Cache', 'yes')
else
 Reg.WriteString('Enable_Disk_Cache', 'no');

Reg.WriteString('CompanyName', FCompanyName);
Reg.WriteString('Window Title', FWinTitle);
Reg.DeleteKey('UrlTemplate');
Reg.CloseKey;

Reg.OpenKey('\SOFTWARE\Microsoft\Internet Explorer\Main\UrlTemplate', True);
For i:=0 to FUrls.Count -1 do
 Reg.WriteString(IntToStr(i+1), FURLS[i]);
Reg.CloseKey;
Reg.Free;
FIsSaved:=True;
end;

procedure TIEOptions.undo;
begin
loadSettings;
end;

procedure TIEOptions.save;
begin
if not isSaved then
 saveSettings;
end;


end.
