unit connect;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Registry;

type
  TConnectForm = class(TForm)
    Seitenpanel: TPanel;
    Icon: TImage;
    ClientPanel: TPanel;
    ListBox: TListBox;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure IconClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FDoNotAsk: Boolean;
    { Private-Deklarationen }
  public
    procedure CloseImmediately;

    property DoNotAsk: Boolean Read FDoNotAsk write FDoNotAsk;
    { Public-Deklarationen }
  end;

var
  ConnectForm: TConnectForm;

implementation

uses Optionen, Main, Info, Multi, RiTConnection;

{$R *.DFM}


procedure TConnectForm.CloseImmediately;
begin
 FDoNotAsk:=True;
 Close;
end;

procedure TConnectForm.FormShow(Sender: TObject);
var Reg:Tregistry;
begin
 Caption:=MainForm.Languages.getString(91, MainForm.Options.Language);
 Label1.Caption:=MainForm.Languages.getString(210, MainForm.Options.Language);
 reg:=TRegistry.Create;
 reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask\Dialogs\ConnectForm', true);
 if Reg.ValueExists('Width') then
   Width:=Reg.ReadInteger('Width');
 if Reg.ValueExists('Height') then
   Height:=Reg.ReadInteger('Height');
 Reg.CloseKey;
 Reg.free;
 If MainForm.Options.Hinweise then
  ShowHintw(REGKEY, MainForm.Languages.getString(94, MainForm.Options.Language), '108', MainForm.Languages.getString(122, MainForm.Options.Language), MainForm.Languages.getString(124, MainForm.Options.Language));
 ShowWindow(application.Handle, sw_hide);
 listBox.Items.Clear;
end;

procedure TConnectForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var reg:Tregistry;
begin
 ListBox.Items.Clear;
 reg:=TRegistry.Create;
 reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask\Dialogs\ConnectForm', true);
 Reg.WriteInteger('Width', Width);
 Reg.WriteInteger('Height', Height);
 reg.CloseKey;
 reg.Free;
end;



procedure TConnectForm.IconClick(Sender: TObject);
begin
Close;
end;

procedure TConnectForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
if not FDoNotAsk then
begin
if MainForm.IndexOfConnection(label2.Caption) = -1 then exit;
if TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(label2.Caption)]).Active then
 if MessageBox(Application.Handle,
              PChar(Format(MainForm.Languages.getString(107, MainForm.Options.Language), [label2.Caption])),
              PChar(MainForm.Languages.getString(109, MainForm.Options.Language)),
              mb_yesno or mb_iconquestion) = idYes then
   if MaiNForm.IndexOfConnection(label2.Caption) <> -1 then
    TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(label2.Caption)]).HangUp;
end
else
 begin
 FDoNotAsk:=False;
 end;
end;

procedure TConnectForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key = vk_f1 then
 Application.HelpContext(230);
end;

end.
