unit RitLanguage;

interface

uses
  Windows, SysUtils, Classes, Dialogs, forms, inifiles, controls;

type
  TRitLanguage = class(TObject)
  private
    { Private declarations }
  protected
    FLangIndex: Integer;
    FDir: string;
    FDllHandle: Hinst;
    procedure LoadLanguage(index: Integer);
    function GetResString(Index: Integer): string;
    { Protected declarations }
  public
    AvailableLanguages: TStringList;

    procedure AutoChange(LangIndex: Integer);
    function  getString(index, LangIndex: Integer): String;
    function  LanguageName(LangIndex: Integer): String;
    procedure reloadLanguageList;


    constructor Create(dir: string);
    destructor  Destroy; Override;

  end;

implementation

uses StdCtrls, ExtCtrls, menus, Buttons, comctrls,ToolEdit, Main,
     sTrans, sCtrls, sEdits, sCombos;


function TRitLanguage.LanguageName(LangIndex: Integer):String;
begin
 if Langindex > -1 then
  Result:=AvailableLanguages[LangIndex]
 else
  Result:='';
end;

procedure TRitLanguage.AutoChange(LangIndex: Integer);
var i,j: integer;
    c  : TObject;
begin
 Screen.Cursor:=crHourglass;
 if LangIndex = 1000 then LangIndex:=AvailableLanguages.IndexOf('English');
  if LangIndex <> FLangIndex then LoadLanguage(LangIndex);
   //MainForm.RxTrayIcon.Hint:='RasInTask ('+AvailableLanguages[FLangIndex]+')';

  with application do for i := 0 to ComponentCount-1 do begin
    for j := 0 to Components[i].ComponentCount-1 do begin
      if Components[i].Components[j].tag <> 0 then begin
        c := Components[i].Components[j];

        if (c is TLabel) then
         begin
          (c as TLabel).caption := getString((c as TLabel).tag, FLangIndex);
          if (c as TLabel).ShowHint = True then
           (c as TLabel).Hint := getString((c as TLabel).tag+1, FLangIndex);
         end;

        if (c is TStaticText) then
         begin
          (c as TStaticText).caption := getString((c as TStaticText).tag, FLangIndex);
          if (c as TStaticText).ShowHint = True then
           (c as TStaticText).Hint := getString((c as TStaticText).tag+1, FLangIndex);
         end;

        if (c is TButton) then
         begin
          (c as TButton).caption := getString((c as TButton).tag, FLangIndex);
           if (c as TButton).ShowHint = True then
            (c as TButton).Hint := getString((c as TButton).tag+1, FLangIndex);
         end;

        if (c is TCheckbox) then
         begin
         (c as TCheckbox).caption := getString((c as TCheckbox).tag, FLangIndex);
         if (c as TCheckbox).ShowHint = True then
          (c as TCheckbox).Hint := getString((c as TCheckbox).tag+1, FLangIndex);
         end;

        if (c is TEdit) then
         begin
         if (c as TEdit).ShowHint = True then
          (c as TEdit).Hint := getString((c as TEdit).tag, FLangIndex);
         end;

        if (c is TFilenameEdit) then
         begin
         if (c as TFilenameEdit).ShowHint = True then
          (c as TFilenameEdit).Hint := getString((c as TFilenameEdit).tag, FLangIndex);
         end;
/////////////////// sEditTools /////////////////////////////

        if (c is TsSpeedButton) then
         begin
          (c as TsSpeedButton).caption := getString((c as TsSpeedButton).tag, FLangIndex);
           if (c as TsSpeedButton).ShowHint = True then
            (c as TsSpeedButton).Hint := getString((c as TsSpeedButton).tag+1, FLangIndex);
         end;

        if (c is TsCheckbox) then
         begin
         (c as TsCheckbox).caption := getString((c as TsCheckbox).tag, FLangIndex);
         if (c as TsCheckbox).ShowHint = True then
          (c as TsCheckbox).Hint := getString((c as TsCheckbox).tag+1, FLangIndex);
         end;

        if (c is TsEdit) then
         begin
         if (c as TsEdit).ShowHint = True then
          (c as TsEdit).Hint := getString((c as TsEdit).tag, FLangIndex);
         end;

        if (c is TsFilenameEdit) then
         begin
         if (c as TsFilenameEdit).ShowHint = True then
          (c as TsFilenameEdit).Hint := getString((c as TsFilenameEdit).tag, FLangIndex);
         end;

        if (c is TRadioButton) then
         begin
          (c as TRadioButton).caption := getString((c as TRadioButton).tag, FLangIndex);
          if (c as TRadioButton).ShowHint = True then
           (c as TRadioButton).Hint := getString((c as TRadioButton).tag+1, FLangIndex);
         end;

        if (c is TForm) then (c as TForm).caption := getString((c as TForm).tag, FLangIndex);

        if (c is TPanel) then (c as TPanel).caption := getString((c as TPanel).tag, FLangIndex);

        if (c is TTabSheet) then (c as TTabSheet).caption := getString((c as TTabSheet).tag, FLangIndex);

        if (c is TBitBtn) then (c as TBitBtn).caption := getString((c as TBitBtn).tag, FLangIndex);
        if (c is TGroupBox) then (c as TGroupBox).caption := getString((c as TGroupBox).tag, FLangIndex);

        if (c is TMenuitem) then (c as TMenuitem).caption := getString((c as TMenuitem).tag, FLangIndex);

      end; 
    end;
  end;
  Screen.Cursor:=crDefault;
end;

function TRitLanguage.GetResString(Index: Integer): string;
var
  Buffer: array[0..1023] of Char;
begin
  LoadString(FDLLHandle,index,@Buffer,1024);
  Result:=string(Buffer);
end;


function TRitLanguage.getString(index, LangIndex: Integer): String;
begin
 if LangIndex <> FLangIndex then LoadLanguage(LangIndex);
 Result:=GetResString(index);
end;

procedure TRitLanguage.LoadLanguage(index: Integer);
begin
 if FDllHandle <> 0 then
  FreeLibrary(FDllHandle);
 FDllHandle:=LoadLibrary(PChar(FDir+'lang\'+AvailableLanguages[index]+'.dll'));
 FLangIndex:=index;
end;

constructor TRitLanguage.Create(dir: string);
begin
 inherited Create;
 FDir:=dir;
 FDllHandle:=0;
 FLangIndex:=-1;
 AvailableLanguages := TStringLIst.Create;
 AvailableLanguages.Sorted:=True;
 reloadLanguageList;
 if AvailableLanguages.Count = 0 then
  begin
  Raise Exception.Create('No languages Found!');
  Application.Terminate;
  end;
 if AvailableLanguages.IndexOf('English') = -1 then
  begin
  Raise Exception.Create('English language not found');
  Application.Terminate;
  end;
end;

destructor TRitLanguage.Destroy;
begin
 if FDllHandle <> 0 then
  FreeLibrary(FDllHandle);
 AvailableLanguages.Free;
 inherited Destroy;
end;

procedure TRitLanguage.reloadLanguageList;
var found: Integer;
    SearchRec: TSearchRec;
begin
 AvailableLanguages.Clear;
 Found := FindFirst(fdir+'lang\*.dll', $0000003F , SearchRec);
 while Found = 0 do
  begin
  AvailableLanguages.Add(Copy(SearchRec.Name, 0, length(SearchRec.Name)-4));
  Found := FindNext(SearchRec);
  end;
 FindClose(SearchRec);
end;

end.
