unit Rasman;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, SpeedBar, Buttons, Grids, ImgList, sCombos,
  sCtrls, sEdits, sTrans, Spin, Chkgroup;

type
  tLogEntry = (leInfo, leError, leOther);

  tLogRecord = packed Record
     typ: tLogEntry;
     text: string[255];
     time: TDateTIme;
     date: TDateTime;
  end;


  TRasmanForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    GroupBox1: TGroupBox;
    Panel1: TPanel;
    Panel2: TPanel;
    tsEvents: TTabSheet;
    SpeedBar2: TSpeedBar;
    SpeedbarSection2: TSpeedbarSection;
    btnClearAll: TSpeedItem;
    btnHelpme: TSpeedItem;
    ilIcons: TImageList;
    lvEvents: TListView;
    btnSave: TSpeedItem;
    SaveDialog1: TSaveDialog;
    NoteBookLeitung: TNotebook;
    Label5: TStaticText;
    Label6: TStaticText;
    Label7: TStaticText;
    Label8: TStaticText;
    Label9: TStaticText;
    Label10: TStaticText;
    Label11: TStaticText;
    Label4: TStaticText;
    labErrorAll: TLabel;
    labErrorTimeout: TLabel;
    labErrorAlign: TLabel;
    labErrorRunouts: TLabel;
    labErrorOverrun: TLabel;
    BufferOverrun: TLabel;
    labErrorCRC: TLabel;
    labErrorFraming: TLabel;
    Label20: TStaticText;
    Label21: TStaticText;
    labCompressionRec: TLabel;
    labCompressionSent: TLabel;
    Label24: TLabel;
    labConnFor: TLabel;
    GroupBox2: TGroupBox;
    labKeepType: TLabel;
    GroupBox3: TGroupBox;
    editIP: TEdit;
    GetDataTimer: TTimer;
    GetTimeTimer: TTimer;
    GroupBox4: TGroupBox;
    Label3: TLabel;
    labinmom: TLabel;
    labinmax: TLabel;
    Label13: TLabel;
    progRec: TProgressBar;
    GroupBox5: TGroupBox;
    Label1: TLabel;
    laboutmom: TLabel;
    laboutmax: TLabel;
    Label16: TLabel;
    progTrans: TProgressBar;
    labPeekIn: TLabel;
    Label18: TLabel;
    labPeekOut: TLabel;
    Label22: TLabel;
    Label2: TLabel;
    btnOk: TsSpeedButton;
    btnHelp: TsSpeedButton;
    combConnection: TsComboBox;
    comboLeitung: TsComboBox;
    tsWinWatch: TTabSheet;
    Label12: TLabel;
    Image1: TImage;
    Label14: TLabel;
    editWintitle: TEdit;
    Bevel1: TBevel;
    Bevel2: TBevel;
    labhinw: TLabel;
    Label15: TLabel;
    sbWinW: TSpeedButton;
    sbRemove: TSpeedButton;
    GroupBox6: TGroupBox;
    radBytes: TsRadioButton;
    radKbytes: TsRadioButton;
    radmbytes: TsRadioButton;
    checkKeepActive: TsCheckBox;
    checkReconnectActive: TsCheckBox;
    checkDisconnectActive: TsCheckBox;
    checkProtoIp: TsCheckBox;
    checkProtoNetBEUI: TsCheckBox;
    checkProtoIPX: TsCheckBox;
    sSpeedButton1: TsSpeedButton;
    sSpeedButton2: TsSpeedButton;
    lvWWConnections: TListView;
    procedure FormCreate(Sender: TObject);
    procedure comboLeitungChange(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure GetDataTimerTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure groupSortClick(Sender: TObject);
    procedure GetTimeTimerTimer(Sender: TObject);
    procedure combConnectionChange(Sender: TObject);
    procedure sbWinWClick(Sender: TObject);
    procedure sbRemoveClick(Sender: TObject);
    procedure btnClearAllClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure lvEventsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure checkProtoIpMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure sSpeedButton1Click(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure sSpeedButton2Click(Sender: TObject);
    procedure checkDasClick(Sender: TObject);
    procedure btnHelpmeClick(Sender: TObject);
    procedure lvEventsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
  private
    FInMax: Integer;
    FOutMax: Integer;

    FPeekRec: Integer;     //Peek of received data/received speed
    FPeekSent: Integer;    //the same, but sent
    FLastPeeked: DWord;  //when have we made the last peek?

    FWWHwnd: THandle;
{ I use all the above stuff to compute the position of the two
  progressbars. The problem is that they are not designed to handle
  changing data with changing Maximums
}
    { Private declarations }
    procedure buildConnectionInfo(Connection: String);
    procedure AppDeactivate(Sender: Tobject); //for WinWatch-Catcher
    procedure AddRandom; //a small joke
    procedure SetupVisibility;
  public
    procedure rebuildConnectionCombo;
    function  formatval(input: Integer): String;
    procedure createLogEntry(typ: TLogEntry; str: String);
    function saveLogfile(filename: String; textonly:boolean): boolean;
    { Public declarations }
  end;


var
  RasmanForm: TRasmanForm;

implementation

uses Main, ritconnection, rasext, Info;

{$R *.DFM}
function TRasManForm.saveLogfile(filename: String; textonly: Boolean): boolean;
var lr: TLogRecord;
    f : File of TLogRecord;
    ft: Textfile;
    x:Integer;
    tstr: String;
begin
result:=true;
if not textonly then
 begin
 AssignFile(f, filename);
 rewrite(f);
 for x:=0 to lvEvents.Items.Count -1 do
  begin
  case lvEvents.Items[x].ImageIndex of
   0: lr.typ:=leInfo;
   2: lr.typ:=leError;
   3: lr.Typ:=leOther;
  end;
  lr.text:=lvEvents.Items[x].Caption;
  lr.date:=StrToDate(lvEvents.Items[x].subitems[0]);
  lr.time:=StrToTime(lvEvents.Items[x].subitems[1]);
  write(f, lr);
  end;
 CloseFile(f);
 end;
if textonly then
 begin
 AssignFile(ft, filename);
 rewrite(ft);
 for x:=0 to lvEvents.Items.Count -1 do
  begin
  case lvEvents.Items[x].ImageIndex of
   0: tstr:='info';
   2: tstr:='error';
   3: tstr:='other';
  end;
  lr.text:=lvEvents.Items[x].Caption;
  lr.date:=StrToDate(lvEvents.Items[x].subitems[0]);
  lr.time:=StrToTime(lvEvents.Items[x].subitems[1]);
  write(ft, Format('%s\t%s\t%s\t%s', [tstr, lr.text, DateToStr(lr.Date), TimeTOStr(lr.time)]));
  end;
 CloseFile(f);
end;
end;

procedure TRasManForm.createLogEntry(typ: TLogEntry; str: String);
begin
 lvEvents.Items.BeginUpdate;
 if lvEvents.Items.Count >= MainForm.Options.LogCount then
  lvEvents.Items.Clear;
  with lvEvents.Items.Add do
   begin
     Case typ of
       leInfo: imageIndex:=0;
       leError: imageIndex:=2;
       leOther: imageIndex:=3
     end;
     Caption:=str;

     subitems.Add(DateToStr(date));
     subitems.Add(TimeToStr(now));
   end; // with ... do
  lvEvents.Items.EndUpdate;
  //second small joke: This will ad a tupid comment (see resourcefiles)
  //every 30 entries
  if lvEvents.Items.Count mod 30 = 0 then
   addRandom;

end;

procedure TRasManForm.AddRandom;
begin
 randomize;
 createLogEntry(leOther, MainForm.Languages.getString(310+random(6), MainForm.Options.Language));
end;

procedure TRasManForm.buildConnectionInfo(Connection: String);
var obj: TRitConnection;
    projinfo: Pointer;
    bufsz: Integer;
begin
 if MainForm.IndexOfCOnnection(Connection) = -1 then exit;
 obj:=TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(Connection)]);
 Case obj.Alive.AliveType of
  ktNone : begin
           labKeepType.Visible:=False;
           CheckKeepActive.Checked := False;
           end;
  ktPing : begin
           labKeepType.Visible:=True;
           labKeepType.Caption:='Ping';
           CheckKeepActive.Checked:=True;
           end;
  ktHTTP : begin
           labKeepType.Visible:=True;
           labKeepType.Caption:='HTTP';
           CheckKeepActive.Checked:=True;
           end;
 end;
 checkReconnectActive.Checked := obj.Reconnect;
 checkDisconnectActive.Checked := (obj.Disconnect.DcType <> dtNone);

 //check for NETBEUI
 projinfo := New(LpRasPPPNbf);
 bufsz := SIzeOf(TRASPPPNBF);
 TRasPPPNbf(projinfo^).dwSize:=bufsz;
 if RasGetProjectionInfo(obj.handle,
                         RASP_PppNbf,
                         projinfo,
                         bufsz) <> ERROR_PROTOCOL_NOT_CONFIGURED then
   CheckProtoNetBEUI.Checked:=true
 else
   CheckProtoNetBEUI.Checked:=false;
 freemem(projinfo);

 //check for IPX/SPX
 projinfo := New(LpRASPPPIPX);
 bufsz := SIzeOf(TRASPPPIPX);
 TRasPPPIPX(projinfo^).dwSize:=bufsz;
 if RasGetProjectionInfo(obj.handle,
                         RASP_PppIpx,
                         projinfo,
                         bufsz) <> ERROR_PROTOCOL_NOT_CONFIGURED then
   CheckProtoIPX.Checked:=true
 else
   CheckProtoIPX.Checked:=false;
 freemem(projinfo);

 //check for TCP/IP and get the IP-Adress
 projinfo := New(LpRASPPPIP);
 fillChar(projinfo^, sizeof(TRASPPPIP), 0);
 bufsz := SIzeOf(TRASPPPIP);
 TRasPPPIP(projinfo^).dwSize:=bufsz;
 if RasGetProjectionInfo(obj.handle,
                         RASP_PppIp,
                         projinfo,
                         bufsz) <> ERROR_PROTOCOL_NOT_CONFIGURED then
   begin
   CheckProtoIP.Checked:=true;
   EditIP.Text:=LpRASPPPIP(projinfo)^.szIpAddress;
   EditIP.Visible:=True;
   EditIP.Enabled:=true;
   EditIP.Color:=clInfoBk;
   end
 else
   begin
   CheckProtoIP.Checked:=false;
   EditIp.text:='';
   EditIP.Visible:=false;
   EditIP.Enabled:=false;
   end;
 freemem(projinfo);
end;

function TRasManForm.formatval(input: Integer): String;
begin
 if radBytes.Checked then
   Result:=FormatFloat(',#,0,.## Bytes', input);
 if radKBytes.Checked then
   Result:=FormatFloat(',#,0,.## KB',(input / 1024));
 if radMBytes.Checked then
   Result:=FormatFloat(',#,0,.## MB',((input / 1024)) / 1024);
end;

procedure TRasManForm.rebuildConnectionCombo;
var x: Integer;
begin
combconnection.Items.Clear;
lvWWConnections.Items.BeginUpdate;
lvWWConnections.Items.Clear;
for x:=0 to MainForm.RasConnections.Count - 1 do
 if TRitConnection(MainForm.RasConnections[x]).Active then
  begin
  combconnection.Items.Add(TRitConnection(MainForm.RasConnections[x]).Name);
  with lvWWConnections.Items.Add do
   begin
   Caption:=TRitConnection(MainForm.RasConnections[x]).Name;
   ImageIndex:=2
   end;
  end;
lvWWConnections.Items.EndUpdate;
if combConnection.Items.Count > 0 then
  begin
  combConnection.Visible:=true;
  lvWWConnections.Enabled:=True;
  lvWWConnections.Color:=clWindow;
  GetTimeTimer.Enabled:=True;
  Panel2.Visible:=True;
  combConnection.ItemIndex:=0;
  end
else
  begin
  combConnection.Visible:=false;
  lvWWConnections.Enabled:=False;
  lvWWConnections.Color:=clBtnFace;
  GetTimeTimer.Enabled:=false;
  Panel2.Visible:=false;
  end
end;



procedure TRasmanForm.FormCreate(Sender: TObject);
var f:File of TLogRecord;
    temprec: TLogRecord;
    x: integer;
begin
 if FileExists(ExtractFilePath(Application.ExeName)+'log.dat') then
  begin
  AssignFile(f, ExtractFilePath(Application.ExeName)+'log.dat');
  Reset(f);
  lvEvents.Items.BeginUpdate;
  lvEvents.Items.Clear;
  if Assigned(msplf) then
    msplf.PutString('Reading logfile...');
  while not eof(f) do
  begin
    Read(f, temprec);
    with lvEvents.Items.Add do
     begin
      Case temprec.typ of
        leInfo: imageIndex:=0;
        leError: imageIndex:=2;
        leOther: imageIndex:=3
      end;
      Caption:=temprec.text;
      subitems.Add(DateToStr(temprec.date));
      subitems.Add(TimeToStr(temprec.time));
     end; // with ... do
    end; //while
  CloseFile(f);
  lvEvents.Items.EndUpdate;
  end; //file exists


 PageControl1.ActivePage:=PageControl1.Pages[0];
 for x:=0 to 3 do
  ComboLeitung.Items.Add(MainForm.Languages.getString(320 + x, MainForm.Options.Language));
 ComboLeitung.ItemIndex:=0;
 NotebookLeitung.PageIndex:=0;
 if not MainForm.NT then
  comboLeitung.Items.Delete(comboLeitung.Items.Count - 1); //remove the compression - tab
//the following is a small joke: Every January the 17th, RasInTask
//will add a logentry about my birthday
 if StrtoInt(FormatDateTime('m', date))=1 then
  if StrtoInt(FormatDateTime('d', date))=17 then
   RasManForm.createLogEntry(leOther, MainForm.Languages.getString(317, MaiNForm.Options.Language));
end;

procedure TRasmanForm.comboLeitungChange(Sender: TObject);
begin
case comboLeitung.ItemIndex of
 0, 1: NotebookLeitung.PageIndex := 0;
 2: NotebookLeitung.PageIndex := 1;
 3: NotebookLeitung.PageIndex := 2;
end;
GetDataTImerTimer(sender); //fill eventually empty labels
GetDataTimer.Enabled:=True;
setupVisibility;
end;

procedure TRasmanForm.btnOkClick(Sender: TObject);
begin
Close;
end;

procedure TRasmanForm.GetDataTimerTimer(Sender: TObject);
var bin, bout, x, tmpi: Integer;
    temps: String;
procedure peek;
begin
  FPeekRec  := bin;
  FPeekSent := bout;
  FLastPeeked := getTickCount;
  labpeekin.Caption:=Inttostr(FPeekRec);
  labpeekout.Caption:=inttostr(FPeekSent);
  progrec.Max:=FPeekRec;
  progtrans.Max:=FPeekSent;
end;

begin
if ((editWinTitle.Text<> '') and (FWWHwnd <> 0) AND NOT (isWindow(FWWHwnd))) then
 begin
  for x:=0 to lvWWConnections.Items.Count - 1 do begin
   if lvWWConnections.Items[x].Checked then
    begin
    FWWHwnd:=0;
    temps:=lvWWConnections.Items[x].Caption;
    tmpi:=MainForm.IndexOfConnection(temps);
    TRitConnection(MainForm.RasConnections[tmpi]).ChangeConnection(false);
    end;
  end; //for
  sbRemove.Click;
 end; //if
if Assigned(MainForm.StatsThread) then
begin
 MainForm.StatsThread.Suspend; //halt the thread when reading values
 if ComboLeitung.ItemIndex = 0 then
  begin
  bin   := MainForm.StatsThread.RasBytesStats.BytesReceived;
  bout  := MainForm.StatsThread.RasBytesStats.BytesTransmitted;
  end;
 if ComboLeitung.ItemIndex = 1 then
  begin
  bin   := MainForm.StatsThread.SpeedStats.BytesRecPerSecond;
  bout  := MainForm.StatsThread.SpeedStats.BytesTransPerSecond;
  if gettickcount - FlastPeeked >= 3 then
   peek;
  if bin > FInMax then
   FInMax:=bin;
  if bout > FOutMax then
   FOutMax:=bout;
  end;
 Case ComboLeitung.ItemIndex of
  0,1:begin
       labInMom.Caption  :=formatval(bin);
       laboutMom.Caption :=formatval(bout);
      end;
    2:begin
       labErrorAll.Caption     := inttostr(MainForm.StatsThread.RasErrors.AllErrors);
       labErrorTimeout.Caption := inttostr(MainForm.StatsThread.RasErrors.Timeout);
       labErrorAlign.Caption   := inttostr(MainForm.StatsThread.RasErrors.Alignment);
       labErrorRunouts.Caption := inttostr(MainForm.StatsThread.RasErrors.Runouts);
       labErrorOverrun.Caption := inttostr(MainForm.StatsThread.RasErrors.Overrun);
       labErrorCRC.Caption     := inttostr(MainForm.StatsThread.RasErrors.CRC);
       BufferOverrun.Caption   := inttostr(MainForm.StatsThread.RasErrors.BufferOverrun);
       labErrorFraming.Caption := inttostr(MainForm.StatsThread.RasErrors.Framing);
      end;
    3:begin
       labCompressionRec.Caption := inttostr(MainForm.StatsThread.RasCompression.Received);
       labCompressionSent.Caption := inttostr(MainForm.StatsThread.RasCompression.Sent);
      end;
 end;
 MainForm.StatsThread.Resume;
 end; //if AssignedMainForm.StatsThread;
end;


procedure TRasmanForm.FormShow(Sender: TObject);
var i: integer;
begin
//MainForm.Languages.AutoChange(MainForm.Options.Language);
for i:=1 to 24 do
 begin
 if FindComponent('label'+inttostr(i)) IS TLabel then
  (FindComponent('label'+inttostr(i)) AS TLabel).Caption:=MainForm.Languages.GetString((FindComponent('label'+inttostr(i)) AS TLabel).Tag, MainForm.Options.Language);
 if FindComponent('label'+inttostr(i)) IS TStaticText then
  (FindComponent('label'+inttostr(i)) AS TStaticText).Caption:=MainForm.Languages.GetString((FindComponent('label'+inttostr(i)) AS TStaticText).Tag, MainForm.Options.Language);
 end;
 for i:=1 to 6 do
 begin
 if FindComponent('GroupBox'+inttostr(i)) IS TGroupBox then
  begin
  if (FindComponent('GroupBox'+inttostr(i)) As TGroupBox).Tag <> 0 then
   (FindComponent('GroupBox'+inttostr(i)) AS TGroupBox).Caption:=MainForm.Languages.GetString((FindComponent('GroupBox'+inttostr(i)) AS TGroupBox).Tag, MainForm.Options.Language);  end;
 end;
btnOk.Caption:=MainForm.Languages.GetString(255, MainForm.Options.Language);
getDataTimer.OnTimer(self);
rebuildConnectionCombo;
getTimeTimer.OnTimer(self);
SpeedBar2.Items(0,0).Button.ShowHint:=true;
SpeedBar2.Items(0,0).Button.Hint:=MainForm.Languages.getString(338, MainForm.Options.Language);
SpeedBar2.Items(0,1).Button.ShowHint:=true;
SpeedBar2.Items(0,1).Button.Hint:=MainForm.Languages.getString(339, MainForm.Options.Language);
SpeedBar2.Items(0,2).Button.ShowHint:=true;
SpeedBar2.Items(0,2).Button.Hint:=MainForm.Languages.getString(340, MainForm.Options.Language);
end;

procedure TRasmanForm.groupSortClick(Sender: TObject);
begin
 GetDataTimer.OnTimer(self);
end;

procedure TRasmanForm.GetTimeTimerTimer(Sender: TObject);
var obj: TRitConnection;
    ts: TTImeStamp;
    dt: TDateTime;
begin
if combConnection.ItemIndex <> -1 then
begin
 if MainForm.IndexOfConnection(combConnection.Items[combConnection.ItemIndex]) = -1 then exit;
 obj:=TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(combConnection.Items[combConnection.ItemIndex])]);
 ts:=MsecsToTimeStamp(gettickcount - obj.ActiveSince);
 dt:=TimeStampToDateTime(ts);
 if obj.longer then
  LabConnFor.Caption:='>'+TimeToStr(dt)
 else
  LabConnFor.Caption:=TimeToStr(dt);
 combConnectionChange(Sender);
end;
end;

procedure TRasmanForm.combConnectionChange(Sender: TObject);
begin
BuildConnectionInfo(combConnection.Items[combConnection.ItemIndex]);
end;

procedure TRasManForm.AppDeactivate(Sender: Tobject);
var wnd:hWnd;
    len:integer;
    s:string;
    point: Tpoint;
begin
  getCursorPos(point);
  wnd:=windowfrompoint(point);
//  if wnd=hpw then exit;
  len:=sendmessage(wnd,wm_gettextlength,0,0)+1;
  setlength(s,len);
  sendmessage(wnd,wm_gettext,len,LongInt(@s[1]));
  EditWintitle.Text:=string(s);
  FWwHwnd:=wnd;
  SbWinW.Down:=False;
  Application.OnDeactivate:=nil;
end;

procedure TRasmanForm.sbWinWClick(Sender: TObject);
begin
if SbWinW.Down then
   Application.OnDeactivate:=AppDeactivate
else
   Application.OnDeactivate:=nil;
end;

procedure TRasmanForm.sbRemoveClick(Sender: TObject);
begin
FWWHwnd:=0;
editWintitle.Text:='';

end;

procedure TRasmanForm.btnClearAllClick(Sender: TObject);
begin
if MessageBox(Application.Handle, 'Do you really ant to delete all Entries?',
              'Question', mb_yesno or mb_iconquestion) = idYes then
 begin;
 lvEvents.Items.BeginUpdate;
 lvEvents.Items.Clear;
 lvEvents.Items.EndUpdate;
 end;
end;

procedure TRasmanForm.btnSaveClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
   saveLogfile(SaveDialog1.FileName, true);
end;

procedure TRasmanForm.lvEventsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var x:Integer;
begin
if lvEvents.SelCount >0 then
 if key = vk_Delete then
  for x:=lvEvents.Items.Count -1 downto 0 do
   if lvEvents.Items[x].Selected then
    lvEvents.Items[x].Delete;
end;

procedure TRasmanForm.FormDestroy(Sender: TObject);
begin
SaveLogfile(ExtractFilePath(Application.ExeName)+'log.dat', false);
end;

procedure TRasManForm.SetupVisibility;
begin
 Case comboLeitung.ItemIndex of
  1:begin
    labPeekIn.Visible  :=true;
    label13.Visible    :=true;
    labinmax.visible   :=true;
    label18.Visible    :=true;
    labPeekOut.Visible :=true;
    label22.Visible    :=true;
    label16.Visible    :=true;
    laboutmax.Visible  :=true;
    progRec.Visible    :=true;
    progTrans.Visible  :=true;
    end
  else
    begin
    labPeekIn.Visible  :=false;
    label13.Visible    :=false;
    labinmax.visible   :=false;
    label18.Visible    :=false;
    labPeekOut.Visible :=false;
    label22.Visible    :=false;
    label16.Visible    :=false;
    laboutmax.Visible  :=false;
    progRec.Visible    :=false;
    progTrans.Visible  :=false;
    end
 end;
end;

procedure TRasmanForm.Button1Click(Sender: TObject);
begin
 TRitConnection(MainForm.RasCOnnections[-1]).UserName:='depp';
end;

procedure TRasmanForm.checkProtoIpMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
(Sender as TSCheckBox).Checked:=not (Sender as TSCheckBox).Checked
end;

procedure TRasmanForm.sSpeedButton1Click(Sender: TObject);
begin
editIP.CopyToClipboard;
end;

procedure TRasmanForm.btnHelpClick(Sender: TObject);
begin
 case pageControl1.ActivePage.PageIndex of
  0:Application.HelpContext(520);
  1:Application.HelpContext(530);
  2:Application.HelpContext(540);
 end;
end;

procedure TRasmanForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
btnHelp.Click;
end;

procedure TRasmanForm.sSpeedButton2Click(Sender: TObject);
var idx: Integer;
begin
idx := mainForm.IndexOfConnection(CombConnection.Items[CombConnection.ItemIndex]);
if idx <> -1 then
 TRitConnection(MainForm.RasConnections[idx]).HangUp;
getDataTimer.OnTimer(self);
rebuildConnectionCombo;
getTimeTimer.OnTimer(self);
end;

procedure TRasmanForm.checkDasClick(Sender: TObject);
begin
getDataTimerTimer(Sender);
end;

procedure TRasmanForm.btnHelpmeClick(Sender: TObject);
var errc, tmp: Integer;
    err: Array[0..99] of Char;
    con: String;
begin
if lvEvents.Selected = nil then exit;
if Copy(lvEvents.Selected.Caption,0,4)
 = Copy(MainForm.Languages.getString(319, MainForm.Options.Language),0,4) then
  begin
  errc:=Strtoint(Copy(lvEvents.Selected.Caption,pos(':', lvEvents.Selected.Caption)+1,length(lvEvents.Selected.Caption)));
  RasGetErrorString(errc, err, 100);
  tmp:=pos('%s', MainForm.Languages.getString(319, MainForm.Options.Language));
  con:=Copy(lvEvents.Selected.Caption, tmp, pos(':', lvEvents.Selected.Caption));
  MainForm.DetRasError(errc, err, con, false);
  end;
end;

procedure TRasmanForm.lvEventsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
btnHelpme.Enabled := (Copy(Item.Caption,0,4) = Copy(MainForm.Languages.getString(319, MainForm.Options.Language),0,4));
end;

end.
