program RasInTask;

uses
  Forms,
  Registry,
  Sysutils,
  Windows,
  Dialogs,
  Main in 'Main.pas' {MainForm},
  Abou in 'Abou.pas' {AboutBox},
  Optionen in 'Optionen.pas' {OptionenForm},
  connect in 'connect.pas' {ConnectForm},
  spash in 'spash.pas' {SplashForm},
  EncryptIt in 'EncryptIt.pas',
  Module in 'Module.pas' {TCPModule: TDataModule},
  RunFirst in 'RunFirst.pas',
  ritconnection in 'ritconnection.pas',
  ieoptions in 'ieoptions.pas',
  Check in 'Check.pas' {CheckFrom},
  Multi in 'Multi.pas' {MultiForm},
  Passwort in 'Passwort.pas' {PasswortForm},
  Rasext in 'Rasext.pas',
  ritoptions in 'ritoptions.pas',
  Rasman in 'Rasman.pas' {RasmanForm},
  NotifyThread in 'NotifyThread.pas',
  StatsThread in 'StatsThread.pas',
  ConnectionChange in 'ConnectionChange.pas' {ConnectionChangeForm},
  RitLanguage in 'RitLanguage.pas',
  AutoDial in 'AutoDial.pas' {AutoDialForm},
  Info in 'Info.pas' {InfoForm},
  Perf in 'Perf.pas' {PerfModule: TDataModule};

{$R *.RES}

var SplForm:TSplashForm;
    Reg:TRegistry;
    FShowOptionsFirst: boolean;
    h: THandle;
    i:Integer;
begin
  h:=FindWindow(nil,'RitMain');
  if isWindow(h) then
   begin
   SetForegroundWindow(h);
   Exit;
   end;
  Application.Initialize;
{
  The following will be called by the uninstaller to deregister RasInTask
  from being the DefaultDialer
}
  if ParamStr(1) = '/dereg' then
   begin
   Application.CreateForm(TMainForm, MainForm);
  for i:=0 to MainForm.RasConnections.Count -1 do
    TRitConnection(MainForm.RasConnections[i]).AutoDial:=false;
   Application.Terminate;
   Exit;
   end;
  splForm:=nil;
  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_CURRENT_USER;
  Reg.OpenKey('\Software\PH-Arts\RasInTask\Settings\', true);
  if (not Reg.ValueExists('NoSplash')) or (not Reg.ReadBool('NoSplash')) then
   SplForm:=TSplashForm.Create(Application);
  FShowOptionsFirst:=false;
  if Assigned(SplForm) then
   begin
   SplForm.Show;
   splForm.putString('Setting up Framework...');
   end;
  Application.ShowMainForm:=False;
  Application.Title := 'RasInTask';
  IsLibrary:=False;
 Try
  Application.HelpFile:='RasInTaske.hlp'; //ExtractFilePath(Application.exeName)+'RasInTask.hlp';
 except
  Application.HelpFile:='';
 end;
  Screen.Cursor:=-11;
  if Assigned(SplForm) then
   splForm.putString('Testing for Registry-Formatchange...');
  If Reg.GetDataType('Language') = rdString then
  begin
   splForm.FormStyle:=fsNormal;
   MessageBox(Application.Handle, 'With the new version of RasInTask, the format in'+#13+
                                 'which the options are saved to the Registry has'+#13+
                                 'changed. All your parogram-settings have now been'+#13+
                                 'deleted (sorry), but please do not worry about'+#13+
                                 'some connections''s extra-settings.'+#13+
                                 'Press ''OK'' to open the configuration-dialog!',
                                 'New Version', mb_ok or mb_iconinformation or mb_setforeground);
   splForm.FormStyle:=fsStayOnTop;
   Reg.CloseKey;
   Reg.OpenKey('\Software\PH-Arts\RasInTask', true);
   Reg.DeleteKey('Settings');
   FShowOptionsFirst:=true;
  end; //if rdstring
  Reg.CloseKey;
  if Assigned(SplForm) then
   splForm.putString('Testing for first run...');
  Reg.OpenKey('\Software\PH-Arts\RasInTask\', true);
  If not Reg.ValueExists('FirstRun') then
    begin
    Reg.WriteString('InstallPath', ExtractFilePath(ParamStr(0)));
    splForm.FormStyle:=fsNormal;
    If MessageBox(Application.Handle, 'This is your first start of RasInTask. Would you'+#13+
                                      'like to configure it now (you will also have the'+#13+
                                      'opportunity to change the language.'+#13+
                                      'If you do not configure RasInTask now, klick in the'+#13+
                                      'PopUp-Menu on Settings.',
                                      'First run', mb_yesNo+mb_Iconinformation+MB_SETFOREGROUND) = idYes then
      begin
      FShowOptionsFirst:=true;
      end;
    splForm.FormStyle:=fsStayOnTop;
    Reg.WriteBool('FirstRun', false);
    end;
  Reg.CloseKey;
  Reg.Free;
  msplf:=splForm;
  if Assigned(SplForm) then
   splForm.putString('Creating hidden Mainform...');
  Application.CreateForm(TMainForm, MainForm);
  if SysUTILS.Win32Platform = VER_PLATFORM_WIN32_NT then
   begin
   if Assigned(SplForm) then
    begin
    splForm.putString('Initializing Statistics-Engine...');
    splForm.ProgBar.Max := 18;
    Application.CreateForm(TPerfModule, PerfModule);
    end
   end;
  if Assigned(SplForm) then
   splForm.putString('Creating TCP/IP-Layer...');
  Application.CreateForm(TTCPModule, TCPModule);
  if Assigned(SplForm) then
   splForm.putString('Creating RasMan...');
  Application.CreateForm(TRasManForm, RasManForm);
  if Assigned(SplForm) then
   splForm.putString('Creating Status Window...');
  Application.CreateForm(TConnectForm, ConnectForm);
  if Assigned(SplForm) then
   splForm.putString('Creating PopUp-Men...');
  MainForm.createMenu;
  screen.Cursor:=0;
  if Assigned(SplForm) then
   begin
   splForm.putString('Initialisation complete.');
   sleep(300);
   end;
  if Assigned(SplForm) then
   begin
    splForm.Close;
    splForm.Free;
   end;
  msplf:=nil;
  MainForm.RxTrayIcon.Active:=true;
  Application.Run;
  if FShowOptionsFirst then
   MainForm.einstclick(Application);

end.
