unit Passwort;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, sCtrls, sEdits;

type
  TPasswortForm = class(TForm)
    Image2: TImage;
    Label5: TLabel;
    labName: TLabel;
    labPasswort: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label1: TLabel;
    labConnection: TLabel;
    PassTimer: TTimer;
    editUser: TsEdit;
    editPass: TsEdit;
    btnOk: TsSpeedButton;
    BitBtn2: TsSpeedButton;
    BitBtn3: TsSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure PassTimerTimer(Sender: TObject);
    procedure evtEntriesChange(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FEnableTimer: Boolean;
    FTimeout    : Integer;
    Countdown   : Integer;
    { Private-Deklarationen }
  public
    property EnableTimer: boolean read FEnableTimer write FEnableTimer;
    property Timeout    : Integer read FTimeout     write FTimeout;
    { Public-Deklarationen }
  end;

var
  PasswortForm: TPasswortForm;

implementation

uses Main;

{$R *.DFM}

procedure TPasswortForm.FormCreate(Sender: TObject);
begin
MainForm.Languages.AutoChange(MainForm.Options.Language);
Caption:=MainForm.Languages.getString(188, MainForm.Options.Language);
end;


procedure TPasswortForm.FormShow(Sender: TObject);
begin
Countdown:=FTimeout;
if editUser.Enabled then editUser.SetFocus else editPass.SetFocus;
If EnableTimer then
 begin
//  btnOk.SetFocus;
  PassTimer.Enabled:=True;
 end;
end;

procedure TPasswortForm.BitBtn3Click(Sender: TObject);
begin
 Application.HelpContext(122);
end;

procedure TPasswortForm.PassTimerTimer(Sender: TObject);
const btCaption : String = '';
begin
if btCaption = '' then
 btCaption:=btnOk.Caption;

btnOk.Caption:=btCaption + ' = '+IntToStr(countdown);
if countdown = 0 then
 begin
 btnOk.Click;
 Exit;
 end;
dec(countdown);
end;

procedure TPasswortForm.evtEntriesChange(Sender: TObject);
begin
 PassTimer.Enabled:=False;
end;

procedure TPasswortForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key = vk_f1 then
 BitBtn3.Click;
end;

end.
