{
This unit handles the Options, which means, saves them to the registry and
loads them.

Now I do nearly everything with the help of two objects: MainForm.Options and
                                                         MainForm.RasConnections[x]
Options is TRitOption
RasConnections[x] is a TList with pointers on a TRitCOnnection-Object.
}

unit Optionen;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, Spin, Registry, Rasext,
  CommCtrl, Menus, SystemImageList, VersInfo, Chkgroup,
  ToolEdit, sTrans, sCtrls, sEdits, sCombos, ImgList, ShellAPI, ClickDef;

type
{
  TTreeNodeType specifies the type of a TreeView's node. TTreeNodeInfo is a record
  that includes a TTreeNodeType and a Integer which contains tha PageIndex of the
  NoteBook that must be showed.
}
  TTreeNodeType = (ntRoot, ntOptions, ntPhoneBook, ntConnection, ntIE);
  TTreeNodeInfo = Record
   ntType    : TTreeNodeType;
   iPageIndex: Integer;
  end;
  pTreeNodeInfo = ^TTreeNodeInfo;

  TProgItemInfo = Record
   sParameters: String[255];
   iLType : Byte;
   iLTime : Byte;
  end;
  pProgItemInfo = ^TProgItemInfo;

  TEntryType = (etProgOpt, etConnection, etIE);
  TChangedOption = Record
    etEntryType : TEntryType;
    obj         : TObject;
    sdescription: ShortString;
    iIndex      : Integer; //-->If it's a connection, store it's Index here
  end;
  pChangedOption = ^TChangedOption;

type
  TOptionenForm = class(TForm)
    tv: TTreeView;
    Bevel1: TBevel;
    Notebook: TNotebook;
    Image1: TImage;
    Label2: TLabel;
    Label3: TLabel;
    pc: TPageControl;
    allg: TTabSheet;
    Image2: TImage;
    Label6: TLabel;
    Bevel2: TBevel;
    beschname: TLabel;
    beschKenn: TLabel;
    Bevel3: TBevel;
    pr: TTabSheet;
    Image4: TImage;
    Label5: TLabel;
    GroupBox6: TGroupBox;
    Label8: TLabel;
    tsStayalive: TTabSheet;
    Image5: TImage;
    Label9: TLabel;
    groupKeep: TGroupBox;
    labBesServer: TLabel;
    Label10: TLabel;
    labErk1: TLabel;
    spinPing: TSpinEdit;
    LabErk2: TLabel;
    Image6: TImage;
    Label11: TLabel;
    GroupBox7: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    GroupBox8: TGroupBox;
    GroupBox9: TGroupBox;
    lbUrls: TListBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    sbIEDown: TSpeedButton;
    sbIEUp: TSpeedButton;
    Image7: TImage;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    tsRedial: TTabSheet;
    Image8: TImage;
    Label18: TLabel;
    GroupBox5: TGroupBox;
    Label19: TLabel;
    spinRedial: TSpinEdit;
    Label20: TLabel;
    spinRedialPause: TSpinEdit;
    Label21: TLabel;
    GroupBox10: TGroupBox;
    Panel1: TPanel;
    lvSrc: TListView;
    lvdst: TListView;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    pmTv: TPopupMenu;
    Umbenennen1: TMenuItem;
    Lschen1: TMenuItem;
    N1: TMenuItem;
    Erstellen1: TMenuItem;
    lvProglist: TListView;
    ilSys: TSystemImageList;
    GroupBox13: TGroupBox;
    Label4: TLabel;
    spinPwZsPause: TSpinEdit;
    Label25: TLabel;
    ListView1: TListView;
    virMain: TVersionInfoResource;
    lvConnections: TListView;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    tsDisconnect: TTabSheet;
    Image10: TImage;
    Label29: TLabel;
    GroupBox15: TGroupBox;
    spinDisconnect: TSpinEdit;
    Label30: TLabel;
    Label31: TLabel;
    GroupBox16: TGroupBox;
    GroupBox17: TGroupBox;
    Label7: TLabel;
    btnOk: TsSpeedButton;
    btnNein: TsSpeedButton;
    btnHelp: TsSpeedButton;
    BitBtn1: TsSpeedButton;
    btnUndo: TsSpeedButton;
    Button3: TsSpeedButton;
    btnLoesch: TsSpeedButton;
    btnNetscapeMail: TsSpeedButton;
    btnNetscapeNews: TsSpeedButton;
    btnNetscapeNav: TsSpeedButton;
    Button6: TsSpeedButton;
    btnLoeschen: TsSpeedButton;
    btnIE: TsSpeedButton;
    btnOEMail: TsSpeedButton;
    btnDBrowser: TsSpeedButton;
    editName: TsEdit;
    editPass1: TsEdit;
    editBname: TsEdit;
    editURL: TsEdit;
    editCompanyName: TsEdit;
    editWinTitle: TsEdit;
    editURLList: TsEdit;
    combStartart: TsComboBox;
    combStartzeit: TsComboBox;
    checkAskName: TsCheckBox;
    checkAskPassword: TsCheckBox;
    checkBug: TsCheckBox;
    checkZsPw: TsCheckBox;
    checkMultiFenster: TsCheckBox;
    checkMultiDial: TsCheckBox;
    checkRedial: TsCheckBox;
    checkKeepAlive: TsCheckBox;
    checkReconnect: TsCheckBox;
    checkIntelligent: TsCheckBox;
    checkAutoDisconnect: TsCheckBox;
    checkCache: TsCheckBox;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    Button2: TsSpeedButton;
    checkAutorun: TsCheckBox;
    checkHinweise: TsCheckBox;
    checkAnim: TsCheckBox;
    GroupBox2: TGroupBox;
    btnUpdate: TsSpeedButton;
    btnCreate: TsSpeedButton;
    btnDUN: TsSpeedButton;
    GroupBox11: TGroupBox;
    Label33: TLabel;
    spinCountDown: TSpinEdit;
    checkConnectWindow: TsCheckBox;
    checkRasMan: TsCheckBox;
    GroupBox14: TGroupBox;
    lbLanguage: TListBox;
    TabSheet2: TTabSheet;
    Image9: TImage;
    Label22: TLabel;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    combdkConnect: TsComboBox;
    GroupBox12: TGroupBox;
    Label23: TLabel;
    Label24: TLabel;
    combPopUp: TsComboBox;
    optSkSettings: TsRadioButton;
    optSkMenu: TsRadioButton;
    optSkConnect: TsRadioButton;
    optDkSettings: TsRadioButton;
    optdkConnect: TsRadioButton;
    optSkRasMan: TsRadioButton;
    optDkRasman: TsRadioButton;
    combSkConnect: TsComboBox;
    editFilen: TsEdit;
    sSpeedButton1: TsSpeedButton;
    OpenDialog1: TOpenDialog;
    btnOENews: TsSpeedButton;
    TabSheet3: TTabSheet;
    Image11: TImage;
    Label32: TLabel;
    GroupBox18: TGroupBox;
    checkAutoDial: TsCheckBox;
    Label34: TLabel;
    checkForce: TsCheckBox;
    Label35: TLabel;
    lvDD: TListView;
    spinCAD: TSpinEdit;
    Label37: TLabel;
    checkLWC: TsCheckBox;
    checkCAD: TsCheckBox;
    Image3: TImage;
    checkDetDlg: TsCheckBox;
    spinLogEnt: TSpinEdit;
    Label36: TLabel;
    checkSplash: TsCheckBox;
    Splitter1: TSplitter;
    lvUbernehmen: TListView;
    optPing: TsRadioButton;
    optHTTP: TsRadioButton;
    procedure CheckAutoRunClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure tvChange(Sender: TObject; Node: TTreeNode);
    procedure FormShow(Sender: TObject);
    procedure optDkSettingsClick(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
    procedure btnCreateClick(Sender: TObject);
    procedure btnLoeschClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
    procedure btnDUNClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure optSkConnectClick(Sender: TObject);
    procedure grpSpracheClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure checkBugClick(Sender: TObject);
    procedure pcChange(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure btnLoeschenClick(Sender: TObject);
    procedure btnNetscapeMailClick(Sender: TObject);
    procedure btnNetscapeNewsClick(Sender: TObject);
    procedure btnNetscapeNavClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure aenderung(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
    procedure checkKeepAliveClick(Sender: TObject);
    procedure btnNeinClick(Sender: TObject);
    procedure buildRASGui(index: Integer);
    procedure btnUndoClick(Sender: TObject);
    procedure evtKeepChange(Sender: TObject);
    procedure editNameExit(Sender: TObject);
    procedure combskConnectChange(Sender: TObject);
    procedure combdkConnectChange(Sender: TObject);
    procedure checkHinweiseClick(Sender: TObject);
    procedure checkAnimClick(Sender: TObject);
    procedure evtAskChange(Sender: TObject);
    procedure lbUrlsClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure checkCacheClick(Sender: TObject);
    procedure editCompanyNameChange(Sender: TObject);
    procedure editWinTitleChange(Sender: TObject);
    procedure sbIEUpClick(Sender: TObject);
    procedure sbIEDownClick(Sender: TObject);
    procedure checkRedialClick(Sender: TObject);
    procedure spinRedialChange(Sender: TObject);
    procedure spinRedialPauseChange(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure checkMultiDialClick(Sender: TObject);
    procedure tvEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure tvEdited(Sender: TObject; Node: TTreeNode; var S: String);
    procedure tvKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Umbenennen1Click(Sender: TObject);
    procedure Lschen1Click(Sender: TObject);
    procedure Erstellen1Click(Sender: TObject);
    procedure tvMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure checkConnectWindowClick(Sender: TObject);
    procedure checkMultiFensterClick(Sender: TObject);
    procedure lvProglistClick(Sender: TObject);
    procedure combPopUpChange(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure checkZsPwClick(Sender: TObject);
    procedure spinPwZsPauseChange(Sender: TObject);
    procedure lvConnectionsDblClick(Sender: TObject);
    procedure cgUbernehmenCheckBoxClick(Sender: TObject; NDX: Integer;
      Checked: Boolean);
    procedure AutoDisconnection(Sender: TObject);
    procedure spinCountDownChange(Sender: TObject);
    procedure checkReconnectClick(Sender: TObject);
    procedure btnIEClick(Sender: TObject);
    procedure btnOEMailClick(Sender: TObject);
    procedure btnDBrowserClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure prDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure prDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure sSpeedButton1Click(Sender: TObject);
    procedure btnOENewsClick(Sender: TObject);
    procedure lvDDChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure checkForceClick(Sender: TObject);
    procedure spinCADChange(Sender: TObject);
    procedure checkLWCClick(Sender: TObject);
    procedure checkAutoDialMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure checkAutoDialClick(Sender: TObject);
    procedure checkCADClick(Sender: TObject);
    procedure checkDetDlgClick(Sender: TObject);
    procedure checkRasManClick(Sender: TObject);
    procedure spinLogEntChange(Sender: TObject);
    procedure checkSplashClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure optDkRasmanClick(Sender: TObject);
    procedure optSkRasManClick(Sender: TObject);
    procedure lvUbernehmenChange(Sender: TObject; Item: TListItem;
      Change: TItemChange); //Reads the RitConn-Object and fills the GUI
  private
    PhoneBookIds : TStringList;
    ProgListItem: TListItem;
    isSaved, buildingGUI :Boolean;
    UnfinishedAction: TClickAction;
    procedure realignControls; //this procedure is called after language was selected. It does what it's mane suggest
    procedure CreateRas;              //Creates an new phonebook entry
    function Check(typ: Integer): Integer;                   //Displays the chekwindow and saves
    procedure SetMultiDial;
    procedure GetMultiDial;
    procedure AddProgs(filename: String; ltype, ltime: Byte; parameters: String);
    procedure BuildList(list: TStringList);
    procedure GetList(list: TStringList);
    procedure ListSetup;
  public
    aktName:String;
    procedure recreateTree(index: Integer);  //Creates the Options-Tree
    procedure buildGUI;                      //Reads the properties of our new otpions-object
    function getNetscape:String;             //Returns the directory of Netscape 4.xx
    function getIE(typ: Integer):String;
    procedure buildIEGui;
    procedure FormMsg(var Msg: TMsg; var Handled: Boolean);
    destructor  Destroy; Override;
  end;

const
 CONNECT        = 1;
 SHOW_OPTIONS   = 2;
 SHOW_MENU      = 3;
 REGKEY         = '\Software\PH-Arts\RasInTask\Hints\';
 IMG_ROOT       = 0;
 IMG_SETTINGS   = 3;
 IMG_CONFOLDER  = 1;
 IMG_CONNECTION = 2;

function GetToken(aString, SepChar: String; TokenNum: Integer):String;


var
  OptionenForm: TOptionenForm;

implementation

uses Main, info, Module, ritconnection, Check, ritoptions,
  ieoptions;

{$R *.DFM}

{
 The following function is not written by me. I found it on the FAQ of the
 German Delphi-Newsgroup de.comp.lang.pascal.delphi.

 The FAQ is maintained by Simon Reinhard. The Code below was writen by
 Peter Haas
}
function GetLongPathName(APath:String):String;
var
  i : Integer;
  h : THandle;
  Data : TWin32FindData;
  IsBackSlash : Boolean;
begin
  APath:=ExpandFileName(APath);
  i:=Pos('\',APath);
  Result:=Copy(APath,1,i);
  Delete(APath,1,i);
  repeat
    i:=Pos('\',APath);
    IsBackSlash:=i>0;
    if Not IsBackSlash then
      i:=Length(APath)+1;
    h:=FindFirstFile(PChar(Result+Copy(APath,1,i-1)),Data);
    if h<>INVALID_HANDLE_VALUE then begin
      try
        Result:=Result+Data.cFileName;
        if IsBackSlash then
          Result:=Result+'\';
      finally
        Windows.FindClose(h);
      end;
    end
    else begin
      Result:=Result+APath;
      Exit;
    end;
    Delete(APath,1,i);
  until Length(APath)=0;
end; {Peter Haas}

{
The following two functions are NOT written by me either. They are very common and
Borland should include them in the next version from delphi. I do not know the
name of the author. I found them in the German Delphi-Magazine

PC Magazin Delphi Spezial 1/96.

Since I found the same routines in many englis programs, I think they are not
written by the authors of the above magazine either.
}



function GetToken(aString, SepChar: String; TokenNum: Integer):String;
var
   Token     : String;
   StrLen    : Integer;
   TNum      : Integer;
   TEnd      : Integer;

begin
     StrLen := Length(aString);
     TNum   := 1;
     TEnd   := StrLen;
     while ((TNum <= TokenNum) and (TEnd <> 0)) do
     begin
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               Token := Copy(aString,1,TEnd-1);
               Delete(aString,1,TEnd);
               Inc(TNum);
          end
          else
          begin
               Token := aString;
          end;
     end;
     if TNum >= TokenNum then
     begin
          GetToken := Token;
     end
     else
     begin
          GetToken := '';
     end;
end;

function NumToken(aString, SepChar: String):integer;
var
   RChar     : Char;
   StrLen    : integer;
   TNum      : integer;
   TEnd      : integer;

begin
     if SepChar = '#' then
     begin
          RChar := '*'
     end
     else
     begin
         RChar := '#'
     end;
     StrLen := Length(aString);
     TNum   := 0;
     TEnd   := StrLen;
     while TEnd <> 0 do
     begin
          Inc(TNum);
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               aString[TEnd] := RChar;
          end;
     end;
     NumToken := TNum;
end;

procedure TOptionenForm.FormMsg(var Msg: TMsg; var Handled: Boolean);
var n: word;
    buffer: Array[0..255] of Char;
begin
 with msg do
  begin
   if Message=WM_DROPFILES then
    begin
     fillChar(buffer, 255, 0);
     for n:=0 to DragQueryFile(msg.wparam, $FFFFFFFF, buffer, 255)-1 do
      begin
       DragQueryFile(msg.wparam, n, Buffer, 80);
       AddProgs(GetLongPathName(string(buffer)), 0, 1,'');
      end;
     DragFinish(msg.wparam);
     Handled:=True;
    end;
  end;
end;


{
 The following procedure (tries to) align(s) the controls on the form
 to match the new length of labels.

 I have some problem with this and maybe I'll change this procedure
 later.

  -I must know the name of my labels. This is a problem since Labels are
   the only controls without an useful name (labConnection is an exception)

  -I cannot resize the checkboxes without using a bad trick, sicne I cannot
   get the width of the box (only the box). The trick?

    *I set the font of OptionenForm to Marlett
    *I use Canvas.TextWidth('e') to get the size of the checkbox
    *now I reset the font back to the old value
    *Again I call Canvas.Teckt width now with the String from the languagefile

   The trick with Marlett? This font which is installed on all win32-Platforms
   that use the new GUI (9x and NT 4.0 and above), contains the symbols that
   Microsoft uses for their controls. 'e' is used for the CheckBox (look yourself
   with charmap.exe)

  For all controls that come in a phrase, I use Canvas.TecktWidth('e') to
  have a nice space between the controls
}

procedure TOptionenForm.realignControls;
var oldfont: TFontName;
    widthe: Integer;
    widthc: Integer;
begin
widthe:=Canvas.TextWidth(' ');
oldfont:=Canvas.Font.Name;
Canvas.Font.Name:='Marlett';
widthc:=Canvas.TextWidth('e')+4;
Canvas.Font.Name:=oldfont;

//First the Second tab of the first Notebook-Page:
CombPopUp.Left:=Label23.Left+Label23.width+widthe;
label24.left := combPopUp.Left+combPopUp.width+widthe;

//now to the second page of the notebook...
//pc[1]
spinPwZsPause.Left:=label4.left+label4.width+widthe;
label25.Left:=spinPwZsPause.Left+spinPwZsPause.Width+widthe;

//pc[1]
checkRedial.Width:=widthc+Canvas.TextWidth(checkRedial.Caption);
lvUbernehmen.Left:=Label27.left+label27.width+widthe;
Label28.Left:=lvUbernehmen.Left+lvUbernehmen.Width+widthe;
checkMultiFenster.left:=Label28.left+10;

//pc[4]
spinDisconnect.Left:=checkAutoDisconnect.Left+widthc;
label30.left:=spinDisconnect.Left+spinDisconnect.Width+widthe;
checkIntelligent.Left:=label30.left+label30.width+widthe+widthe;
label7.Left:=checkIntelligent.Left+checkIntelligent.Width+widthe;

//the AutoDial-Pane
spinCAD.AutoSize:=false;
spinCAD.AutoSize:=true;
spinCad.Left:=checkCAD.Left+checkCAD.Width+widthe+widthe;
label37.Left:=spinCAD.Left+spinCAD.Width+widthe;
checkLWC.Left:=label37.Left+label37.Width+widthe
end;

procedure TOptionenForm.ListSetup;
var x:Integer;
    col: TListColumn;
begin
 lvConnections.Columns.BeginUpdate;
 lvConnections.Columns.Clear;
 with lvConnections.Columns.Add do
  begin
  Caption:='Name'; //English and german is equal-> not entry in the stringlist!
  Width  :=ColumnTextWidth;
  end;
 with lvConnections.Columns.Add do
  begin
  Caption:=MainForm.Languages.getString(225, MainForm.Options.Language);; //English and german is equal-> not entry in the stringlist!
  Width  :=ColumnTextWidth;
  end;
 with lvConnections.Columns.Add do
  begin
  Caption:='Status'; //English and german is equal-> not entry in the stringlist!
  Width  :=ColumnTextWidth;
  end;
 lvConnections.Columns.EndUpdate;
 lvConnections.Items.BeginUpdate;
 lvDD.Columns[0].Caption:=MainForm.Languages.getString(350, MainForm.Options.Language);
 lvDD.Items.BeginUpdate;
 lvDD.OnChange := nil;
 lvConnections.Items.Clear;
 lvDD.Items.Clear;
 for x:=0 to MainForm.RasConnections.Count - 1 do
  begin
   with lvConnections.Items.Add do
    begin
    ImageIndex:=2;
    Caption:=TRitConnection(MainForm.RasConnections[x]).Name;
    SubItems.Clear;
    Subitems.Add(TRitConnection(MainForm.RasConnections[x]).DeviceName);
    Case TRitConnection(MainForm.RasConnections[x]).RitState of
     0,1: Subitems.Add(MainForm.Languages.getString(225, MainForm.Options.Language));
     2: Subitems.Add(MainForm.Languages.getString(226, MainForm.Options.Language));
     3: begin
        Subitems.Add(MainForm.Languages.getString(227, MainForm.Options.Language));
        if TRitConnection(MainForm.RasConnections[x]).longer then
         SubItems[1]:=SubItems[1]+' (>' + TimeToStr(gettickcount - TRitConnection(MainForm.RasConnections[x]).ActiveSince) + ')'
        else
         SubItems[1]:=SubItems[1]+' (' + TimeToStr(gettickcount - TRitConnection(MainForm.RasConnections[x]).ActiveSince) + ')'
        end;
     end; //case
    end; //width
    with lvDD.Items.Add do
     begin
     ImageIndex:=2;
     Caption:=TRitConnection(MainForm.RasConnections[x]).Name;
     checked:=TRitConnection(MainForm.RasConnections[x]).SInAutoDial;
     end;
  end; //for
 lvConnections.Items.EndUpdate;
 lvDD.Items.EndUpdate;
 lvDD.OnChange := lvddchange;
 lvProgList.Columns.BeginUpdate;
 lvProgList.Columns.Clear;
 for x:=0 to 2 do
  begin
  col:=lvProgList.Columns.Add;
  col.Caption:=MainForm.Languages.getString(221 + x, MainForm.Options.Language);
  col.Width  :=ColumnTextWidth;
  end;
 with lvProglist.Columns.Add do
  begin
  Caption:=MainForm.Languages.getString(280, MainForm.Options.Language);;
  Width:=ColumnTextWidth;
  end;
 lvProgList.Columns.EndUpdate;
end;

procedure TOptionenForm.BuildList(list: TStringList);
var x: Integer;
    ltime, ltype: Byte;
begin
 lvProgList.Items.Clear;
 for x:=0 to list.Count - 1 do
   begin
   //I must do the following conversion, Since possibly, the User has an
   //old version isntalled, that did not use the listview with subitems....
   if getToken(list[x], '|', 3) = '' then ltime := 1 else ltime:=StrToInt(getToken(list[x], '|', 3));
   if getToken(list[x], '|', 2) = '' then ltype := 1 else ltype:=StrToInt(getToken(list[x], '|', 2));
   if ((getToken(list[x], '|', 3) = '') OR (getToken(list[x], '|', 2) = '')) then
    TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
   addProgs(getToken(list[x], '|', 1), ltype, ltime, GetToken(list[x], '|', 4));
   end;
end;

{ Everything in the procedure at the top of this comment that has something to do with '' is only
  here for compatibility with the Registry-Entries of RasInTask 1.05 and above.

  ->The last if-clause is Used to force the User to convert the Entries to the
    new format.

  ->ltime and ltype are set to 1 because theese settings were used in RasInTask before
    1.1
}

procedure TOptionenForm.GetList(list: TstringList);
var x: Integer;
begin
 list.Clear;
 for x:=0 to lvProgList.Items.Count -1 do
  with lvProgList.Items[x] do
   begin
   list.Add(Caption + '|');
   list[x]:=list[x] + IntToStr(pProgItemInfo(Data).iLType) + '|';
   list[x]:=list[x] + IntToStr(pProgItemInfo(Data).iLTIme) + '|';
   list[x]:=list[x] + pProgItemInfo(Data).sParameters + '|';
   end;
end;

destructor TOptionenForm.Destroy;
begin
 PhoneBookIds.Free;
 //UnfinishedAction.Free;
 inherited Destroy;
end;

procedure TOptionenForm.buildGUI;
var i: Integer;
    tmp: Boolean;
begin
 buildingGUI:=true;
 spinCountDOwn.Value        := MainForm.Options.Countdown;
 checkConnectWindow.Checked := MainForm.Options.ConnectWindow;
 checkAnim.Checked          := MainForm.Options.Anim;
 checkHinweise.Checked      := MainForm.Options.Hinweise;
 checkAutorun.Checked       := MainForm.Options.Autorun;
 checkLWC.Checked           := MainForm.Options.LWC;
 checkCAD.Checked           := mainForm.Options.UseCad;
 checkDetDlg.Checked        := MaiNForm.Options.DetDlg;
 checkSplash.Checked        := MainForm.Options.Splash;
 lbLanguage.ItemIndex := MainForm.Options.Language;

 checkCADClick(Application);
 MainForm.Languages.AutoChange(MainForm.Options.Language); //Sets the language in the dlg
// lvUbernehmen.Items[0].Caption:=MainForm.Languages.GetString(
 optSkConnect.Caption:=MainForm.Languages.GetString(optSkConnect.Tag, MainForm.Options.Language);
 optSkSettings.Caption:=MainForm.Languages.GetString(optSkSettings.Tag, MainForm.Options.Language);
 optSkMenu.Caption:=MainForm.Languages.GetString(optSkMenu.Tag, MainForm.Options.Language);
 optSkRasMan.Caption:=MainForm.Languages.GetString(optSkRasMan.Tag, MainForm.Options.Language);
 optdkConnect.Caption:=MainForm.Languages.GetString(optdkConnect.Tag, MainForm.Options.Language);
 optdkSettings.Caption:=MainForm.Languages.GetString(optdkSettings.Tag, MainForm.Options.Language);
 optdkRasMan.Caption:=MainForm.Languages.GetString(optDkRasMan.Tag, MainForm.Options.Language);

 realignControls;

 spinLogEnt.Value           := MainForm.Options.LogCount;
 checkRasMan.Checked        := MainForm.Options.Logging;
 checkRasManClick(Application);
 combPopUp.Items.Clear;
 combPopUp.Items.Add(MainForm.Languages.getString(211, MainForm.Options.Language));
 combPopUp.Items.Add(MainForm.Languages.getString(212, MainForm.Options.Language));
 combPopUp.ItemIndex:=MainForm.Options.PopUpType;

 combStartart.Items.Clear;
 combStartart.Items.Add(MainForm.Languages.getString(205, MainForm.Options.Language));
 combStartart.Items.Add(MainForm.Languages.getString(206, MainForm.Options.Language));
 combStartart.Items.Add(MainForm.Languages.getString(207, MainForm.Options.Language));

 combStartzeit.Items.Clear;
 combStartzeit.Items.Add(MainForm.Languages.getString(208, MainForm.Options.Language));
 combStartzeit.Items.Add(MainForm.Languages.getString(209, MainForm.Options.Language));



 Case MainForm.Options.Scklick of
  SHOW_MENU   : optSkMenu.Checked:=True;
  SHOW_OPTIONS: optSkSettings.Checked:=True;
  CONNECT     : optSkConnect.Checked:=True;
 End;
 Case MainForm.Options.RasMan of
  rcSingle: begin
            optskRasMan.Checked:=true;
            optDkRasMan.Checked:=false;
            end;
  rcShift:  begin
            optDkRasMan.Checked:=true;
            optskRasMan.Checked:=false;
            end;
 end;

 tmp:=True;
 for i:=0 to MainForm.RasConnections.Count - 1 do
  begin
  combSkConnect.Items.Add(TRitConnection(MainForm.RasConnections[i]).Name);
  combDkConnect.Items.Add(TRitConnection(MainForm.RasConnections[i]).Name);
  if tmp then
   tmp:=TRitConnection(MainForm.RasConnections[i]).AutoDial;
  end;
 checkAutoDial.Checked:=tmp;
  checkForce.Checked:=MainForm.Options.Force;
 combSkConnect.ItemIndex:=combSkConnect.Items.IndexOf(MainForm.Options.ConnectSk);
 combdkConnect.ItemIndex:=combdkConnect.Items.IndexOf(MainForm.Options.Connectdk);
 spinCAD.Value:=MainForm.Options.CAD;
 if combskConnect.Items.IndexOf(MainForm.Options.ConnectSk) = -1 then combSkConnect.ItemIndex:=0;
 if combdkConnect.Items.IndexOf(MainForm.Options.Connectdk) = -1 then combdkConnect.ItemIndex:=0;
  checkAutoDialClick(Application);
 Case MainForm.Options.DClick of
  SHOW_OPTIONS: optdkSettings.Checked:=True;
  CONNECT     : optdkConnect.Checked:=True;
 End;
 MainForm.createMenu;
 MainForm.Options.IsSaved:=True;
 buildingGUI:=False;
end;

function TOptionenForm.Check(typ: Integer): Integer;
var List : TList;
    i    : Integer;
    verb : String;
    CheckForm: TCheckFrom;
begin
Result:=idOK;
{
 How does this work?

 First we will collect the Data into a TList, then we will Save Every entry
 of the linked list. Finished!
}

List:=TList.Create;
if not MainForm.Options.IsSaved then
 begin
 List.Add( New(pChangedOption) );
 pChangedOption(List[List.Count-1]).etEntryType  :=etProgOpt;
 pChangedOption(List[List.Count-1]).sdescription :=ShortString(MainForm.Languages.getString(168, MainForm.Options.Language));
 pChangedOption(List[List.Count-1]).iIndex       :=-1;
 pChangedOption(List[List.Count-1]).obj          :=MainForm.Options;
 end;
if not MainForm.IEOptions.IsSaved then
 begin
 List.Add( New(pChangedOption) );
 pChangedOption(List[List.Count-1]).etEntryType  := etIE;
 pChangedOption(List[List.Count-1]).sdescription := ShortString(MainForm.Languages.getString(190, MainForm.Options.Language));
 pChangedOption(List[List.Count-1]).iIndex       := -1;
 pChangedOption(List[List.Count-1]).obj         :=MainForm.IEOptions;
 end;
for i:=0 to MainForm.RasConnections.Count - 1 do
 if not TRitConnection(MainForm.RasCOnnections[i]).IsSaved then
  begin
  List.Add( New(pChangedOption) );
  pChangedOption(List[List.Count-1]).etEntryType  := etConnection;
  pChangedOption(List[List.Count-1]).sdescription := ShortString(Format(MainForm.Languages.getString(169, MainForm.Options.Language), [TRitConnection(MainForm.RasCOnnections[i]).Name]));
  pChangedOption(List[List.Count-1]).iIndex       := i;
  pChangedOption(List[List.Count-1]).obj          := TRitConnection(MainForm.RasCOnnections[i]);
  end;

{
 The Data is now collected. I will now go through the whole TList (one of the best built-
 in-objects of Delphi)
}

Case typ of
 0: verb:=MainForm.Languages.getString(172, MainForm.Options.Language);
 1: verb:=MainForm.Languages.getString(173, MainForm.Options.Language);
end;

case typ of
0:
begin
if list.count > 0 then
 begin
 if list.Count = 1 then
  case MessageBox(Application.Handle,
                PChar(Format(MainForm.Languages.getString(170, MainForm.Options.Language) + ' %s', [pChangedOption(List[0]).sdescription, verb])),
                PChar(MainForm.Languages.getString(164, MainForm.Options.Language)),
                mb_iconquestion or mb_yesnocancel) of
   idyes: begin
          Case pChangedOption(List[0]).etEntryType Of
           etProgOpt   : TRitOption(pChangedOption(List[0]).obj).save;
           etConnection: TRitConnection(pChangedOption(List[0]).obj).save;
           etIE        : TIEOptions(pChangedOption(List[0]).obj).save;
           end;
          end;
    idno: begin
          Case pChangedOption(List[0]).etEntryType Of
           etProgOpt   : TRitOption(pChangedOption(List[0]).obj).undo;
           etConnection: TRitConnection(pChangedOption(List[0]).obj).undo;
           etIE        : TIEOptions(pChangedOption(List[0]).obj).undo;
          end;
          end;
    idCancel: result:=idcancel;
  end
 else
  begin
  CheckForm:=TCheckFrom.Create(self);
  checkForm.lab.Caption:=MainForm.Languages.getString(166, MainForm.Options.Language);
  checkForm.Caption:=MainForm.Languages.getString(164, MainForm.Options.Language);
  for i:=0 to List.Count - 1 do
   begin
   with checkForm.lvCheck.Items.Add do
    begin
    Caption:=pChangedOption(list[i]).sDescription;
    Checked:=true;
    ImageIndex:=3;
    end;
//   checkForm.CheckList.CheckItem(checkForm.CheckList.Items.Count -1);
   end;
  checkForm.ShowModal;
  Case checkForm.ModalResult of
   idOK:   for i:=0 to List.Count - 1 do
             if checkForm.lvCheck.Items[i].checked then
              Case pChangedOption(List[i]).etEntryType Of
               etProgOpt   : TRitOption(pChangedOption(List[i]).obj).save;
               etConnection: TRitConnection(pChangedOption(List[i]).obj).save;
               etIE        : TIEOptions(pChangedOption(List[i]).obj).save;
              end
             else
              Case pChangedOption(List[i]).etEntryType Of
               etProgOpt   : begin TRitOption(pChangedOption(List[i]).obj).undo; TRitOption(pChangedOption(List[i]).obj).IsSaved:=True; end;
               etConnection: TRitConnection(pChangedOption(List[i]).obj).undo;
               etIE        : TIEOptions(pChangedOption(List[i]).obj).undo;
              end;
   idCancel: begin Result:=idCancel; end;
   end; //-->Case ShowModal of
  checkForm.Free;
  end; //-->Else of i list.count = 1
 end; //-->List.Count >0
end; //Case typ of 0

1:
begin
if list.count > 0 then
 begin
 if list.Count = 1 then
  Case MessageBox(Application.Handle,
                PChar(Format(MainForm.Languages.getString(170, MainForm.Options.Language) + ' %s', [pChangedOption(List[0]).sdescription, verb])),
                PChar(MainForm.Languages.getString(164, MainForm.Options.Language)),
                mb_iconquestion or mb_yesnocancel) of
   idYes: begin
           Case pChangedOption(List[0]).etEntryType Of
            etProgOpt   : TRitOption(pChangedOption(List[0]).obj).undo;
            etConnection: TRitConnection(pChangedOption(List[0]).obj).undo;
            etIE        : TIEOptions(pChangedOption(List[0]).obj).undo;
           end;
          end;
    idno:begin
         Case pChangedOption(List[0]).etEntryType Of
          etProgOpt   : TRitOption(pChangedOption(List[0]).obj).save;
          etConnection: TRitConnection(pChangedOption(List[0]).obj).save;
          etIE        : TIEOptions(pChangedOption(List[0]).obj).save;
         end;
        end;
    idcancel: begin Result:=idCancel; end;
  end
 else
  begin
  CheckForm:=TCheckFrom.Create(self);
  checkForm.lab.Caption:=MainForm.Languages.getString(167, MainForm.Options.Language);
  checkForm.Caption:=MainForm.Languages.getString(165, MainForm.Options.Language);
  for i:=0 to List.Count - 1 do
   with checkForm.lvCheck.Items.Add do
    begin
    Caption:=pChangedOption(list[i]).sDescription;
    Checked:=true;
    ImageIndex:=3;
    end;
  checkForm.ShowModal;
  Case checkForm.ModalResult  of
   idOk:   for i:=0 to List.Count - 1 do
             if checkForm.lvCheck.Items[i].Checked then
              Case pChangedOption(List[i]).etEntryType Of
               etProgOpt   : TRitOption(pChangedOption(List[i]).obj).undo;
               etConnection: TRitConnection(pChangedOption(List[i]).obj).undo;
               etIE        : TIEOptions(pChangedOption(List[i]).obj).undo;
              end
             else
              Case pChangedOption(List[i]).etEntryType Of
               etProgOpt   : TRitOption(pChangedOption(List[i]).obj).save;
               etConnection: TRitConnection(pChangedOption(List[i]).obj).save;
               etIE        : TIEOptions(pChangedOption(List[i]).obj).save;
              end;
   idCancel: begin Result:=IdCancel; end;
   end; //-->Case ShowModal of
  checkForm.Free;
  end; //-->Else of i list.count = 1
 end; //-->List.Count >0
end; //Case typ of 1
end; //case typ of

For i:=0 to List.Count - 1 do
 freeMem(list[i]);
list.Clear;
list.Free;
end; //Procedure

function TOptionenForm.GetNetscape:String;
var Reg: TRegIniFile;
    curver, nsverz: String;
begin
  Result:='';
  Reg:=TRegIniFile.Create('\SOFTWARE\Netscape\');
  Reg.RootKey:=HKEY_LOCAL_MACHINE;
  curver:=Reg.ReadString('\SOFTWARE\Netscape\Netscape Navigator', 'CurrentVersion','');
  if curver<>'' then
    nsverz := Reg.ReadString('\SOFTWARE\Netscape\Netscape Navigator\'+curver+'\Main', 'Install Directory','');
  Reg.Free;
Result:=nsverz;
end;

function TOptionenForm.getIE(typ: Integer):String;
var Reg: TRegistry;
begin
  Result:='';
  Reg:=TRegistry.Create;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  Case typ of
   1: begin
      Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\App Paths\IEXPLORE.EXE', true);
      Result:=Reg.ReadString('');
      end;
   2: begin
      Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\App Paths\msimn.exe /mail /mailonly', true);
      Result:=Reg.ReadString('');
      end;
   3: begin
      Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\App Paths\msimn.exe /news /newsonly', true);
      Result:=Reg.ReadString('');
      end;
   4: begin
      Reg.OpenKey('\Software\CLASSES\htmlfile\shell\open\command', true);
      Result:=Reg.ReadString('');
      while Pos('"', Result) > 0 do
       Delete(Result, Pos('"', Result), 1);
      end;
end;
Reg.CloseKey;
Reg.Free;
end;



procedure TOptionenForm.recreateTree(index: Integer);
var x, anr:Integer;
begin
 tv.OnChange := nil;
 PhoneBookIDs.Clear;
 tv.Items.Clear;
 tv.Items.BeginUpdate;
 with tv.Items.AddFirst(nil, 'RasInTask') do
  begin
   ImageIndex    := IMG_ROOT;
   SelectedIndex := IMG_ROOT;
   Data          := New( pTreeNodeInfo ); //-->Custom type. See Top of unit.
   pTreeNodeInfo(Data)^.ntType     := ntRoot;
   pTreeNodeInfo(Data)^.iPageIndex := 4;
   Collapse(true);
   Selected:=True;
  end;
 with tv.Items.AddChildFirst(tv.Selected, MainForm.Languages.getString(42, MainForm.Options.Language)) do
  begin
   ImageIndex    := IMG_CONFOLDER;
   SelectedIndex := IMG_CONFOLDER;
   Data          := New( pTreeNodeInfo );
   pTreeNodeInfo(Data)^.ntType     := ntPhoneBook;
   pTreeNodeInfo(Data)^.iPageIndex := 1;
   PhoneBookIds.Add(IntToStr(Integer(ItemID)));
   anr := 1;
  end;
 with tv.Items.AddChildFirst(tv.Selected, MainForm.Languages.getString(41, MainForm.Options.Language)) do
  begin
   ImageIndex    := IMG_SETTINGS;
   SelectedIndex := IMG_SETTINGS;
   Data          := New( pTreeNodeInfo );
   pTreeNodeInfo(Data)^.ntType     := ntOptions;
   pTreeNodeInfo(Data)^.iPageIndex := 0;
   Selected:=True;
  end;
 if MainForm.IEOptions.IE4 then
  begin
  with tv.Items.AddChildFirst(tv.Selected, MainForm.Languages.getString(263, MainForm.Options.Language)) do
   begin
    ImageIndex    := IMG_SETTINGS;
    SelectedIndex := IMG_SETTINGS;
    Data          := New( pTreeNodeInfo );
    pTreeNodeInfo(Data)^.ntType     := ntIE;
    pTreeNodeInfo(Data)^.iPageIndex := 3;
   end;
  end;

 for x:=0 to MainForm.RasConnections.Count-1 do
  begin
  with tv.Items.AddChild(tv.items.GetNode(HTreeItem(StrToInt(PhoneBookIds[anr - 1]))), TRitConnection(MainForm.RasConnections.Items[x]).Name) do
   begin
    ImageIndex    := IMG_CONNECTION;
    SelectedIndex := IMG_CONNECTION;
    Data          := New( pTreeNodeInfo );
    pTreeNodeInfo(Data)^.ntType     := ntConnection;
    pTreeNodeInfo(Data)^.iPageIndex := 2;
   end;
  end;
 tv.Items.EndUpdate;
 if index <> -123 then
  begin
  if index = 0 then
   tv.Items.GetFirstNode.Selected:=True
  else
   tv.Items[index].Selected:=True;
  end
 else
  begin
  tv.Items.GetNode(HtreeItem(StrToInt(PhoneBookIds[0]))).Expand(true);
  tv.Items[tv.Items.Count -1].Selected:=True;
  end;
 tv.OnChange := tvChange;
 listsetup;
end;


procedure TOptionenForm.CreateRas;
var
    dwRet     : DWORD;
    old       : Byte; //Checks if a new entry is really created.
                      //RasCreate... sends 0 also if the user clicked
                      //cancel
begin
    dwRet := RasCreatePhonebookEntryA(Handle, nil);
    if dwRet <> 0 then
      ShowMessage('Cannot create an entry');

old:=MainForm.RasConnections.Count;

MainForm.RasConnections.Clear;
MainForm.GetEnt;
if MainForm.RasConnections.Count <> old then
 begin        //a new entry is created
 recreateTree(0);
 buildGui;
 MainForm.createMenu;
 tv.Items[tv.Items.Count -1].Selected:=True;
 tv.FullExpand;
 Button3.Click;
 TRitConnection(MainForm.RasConnections[MainForm.RasConnections.Count - 1]).IsSaved:=True;
 end;
end;

procedure TOptionenForm.buildRASGui(index: Integer);
var wasSaved: Boolean;
           i: Integer;
begin
 pc.ActivePage:=pc.Pages[0];
{
 Before we start with building the GUI, we have to unlink all the events
 that write to the RitConnection-object, because the change of a property
 of a control causes it to fire it's events

 Example:

 editName.Text:='Test' changes the Text of our control, but it fires also the
 editName.OnChange Event. So our object will be notified of a change which is
 actually only the setup of the control
}

  wasSaved:=TRitConnection(MainForm.RasConnections[index]).IsSaved;
  lvUbernehmen.OnChange :=nil;
  checkMultiFenster.OnClick    :=nil;
  spinDisconnect.OnCHange      :=nil;
  checkAutoDisconnect.OnClick  :=nil;
  checkIntelligent.OnClick := nil;
  editBname.OnChange       := nil;
  editPass1.OnChange       := nil;
  checkBug.OnClick         := nil;
  optPing.OnClick          := nil;
  optHttp.OnClick          := nil;
  checkKeepAlive.OnClick   := nil;
  editURL.OnChange         := nil;
  spinPing.OnChange        := nil;
  checkAskName.OnClick     := nil;
  checkAskPassword.OnClick := nil;
  checkRedial.OnClick      := nil;
  spinRedial.OnChange      := nil;
  spinRedialPause.OnChange := nil;
  checkRedial.OnClick      := nil;
  checkZsPw.OnClick        := nil;
  spinPwZsPause.OnChange   := nil;
  checkReconnect.OnClick   := nil;


  editName.Text            := TRitConnection(MainForm.RasConnections[index]).Name;
  editBName.Text           := TRitConnection(MainForm.RasConnections[index]).UserName;
  editPass1.Text           := TRitConnection(MainForm.RasConnections[index]).Password;
  checkAskName.Checked     := TRitConnection(MainForm.RasConnections[index]).AskLater.AskName;
  checkAskPassword.Checked := TRitConnection(MainForm.RasConnections[index]).AskLater.AskPassword;
  checkBug.Checked         := TRitConnection(MainForm.RasConnections[index]).BugFix;
  checkZsPw.Checked        := TRitConnection(MainForm.RasConnections[index]).AskLater.SavePassword;
  spinPwZsPause.Value      := TRitConnection(MainForm.RasConnections[index]).AskLater.Timeout;

  checkZsPw.Enabled     :=(checkAskName.checked OR checkAskPassword.checked);
  label4.Enabled        :=(checkAskName.checked OR checkAskPassword.checked);
  spinPwZsPause.Enabled :=(checkZsPw.Checked AND (checkAskName.checked OR checkAskPassword.checked));
  label25.Enabled       :=(checkAskName.checked OR checkAskPassword.checked);
  editBname.Enabled:= not checkAskName.checked;
  editPass1.Enabled:= not checkAskPassword.checked;

  Case editBname.Enabled of
   true: editBname.Color:=clWindow;
   false: editBname.Color:=clBtnFace;
  end;

  Case editPass1.Enabled of
   true: editPass1.Color:=clWindow;
   false: editPass1.Color:=clBtnFace;
  end;

  Case spinPwZsPause.Enabled of
   true: spinPwZsPause.Color:=clWindow;
   false: spinPwZsPause.Color:=clBtnFace;
  end;


  buildList(TRitConnection(MainForm.RasConnections[index]).ProgList);

  lvUbernehmen.Items[1].Caption:=MainForm.Languages.getString(358, MainForm.Options.Language);
  lvUbernehmen.Columns[0].Caption:=MainForm.Languages.getString(359, MainForm.Options.Language);


  if TRitConnection(MainForm.RasConnections[index]).Alive.AliveType = ktNone then
   checkKeepAlive.Checked:=False
  else
   checkKeepAlive.Checked:=True;

  checkKeepAlive.Checked := not ((TRitConnection(MainForm.RasConnections[index]).Alive.AliveType) = ktNone);
  optPing.Checked        := (TRitConnection(MainForm.RasConnections[index]).Alive.AliveType = ktPing);
  optHTTP.Checked        := not ((TRitConnection(MainForm.RasConnections[index]).Alive.AliveType) = ktPing);
  editURL.Text           := TRitConnection(MainForm.RasConnections[index]).Alive.URL;
  SpinPing.Value         := TRitConnection(MainForm.RasConnections[index]).Alive.Minutes;
  checkReconnect.Checked := TRitConnection(MaiNForm.RasConnections[index]).Reconnect;
  Case TRitConnection(MainForm.RasConnections[index]).Disconnect.DcType of
   dtNone:    begin
              checkAutoDisconnect.Checked:=False;
              spinDisconnect.Enabled:=False;
              spinDisconnect.Color:=clBtnFace;
              checkIntelligent.Enabled:=False;
              end;
   dtAlways:  begin
              checkAutoDisconnect.Checked:=True;
              spinDisconnect.Enabled:=True;
              spinDisconnect.Color:=clWindow;
              checkIntelligent.Checked:=False;
              checkIntelligent.Enabled:=True;
              end;
dtIntelligent:begin
              checkAutoDisconnect.Checked:=True;
              spinDisconnect.Enabled:=True;
              spinDisconnect.Color:=clWindow;
              checkIntelligent.Checked:=True;
              checkIntelligent.Checked:=True;
              end;
  end;
  spinDisconnect.Value:=TRitConnection(MainForm.RasConnections[index]).Disconnect.DcTime;
  editBname.OnChange       := aenderung;
  editPass1.OnChange       := aenderung;
  checkBug.OnClick         := CheckBugClick;
  optPing.OnClick          := evtKeepChange;
  optHTTP.OnClick          := evtKeepChange;
  editURL.OnChange         := evtKeepChange;
  spinPing.OnChange        := evtKeepChange;
  checkKeepAlive.OnClick   := CheckKeepAliveClick;
  checkAskName.OnClick     := evtAskChange;
  checkAskPassword.OnClick := evtAskChange;
  checkReconnect.OnClick   := checkReconnectClick;

  If checkKeepAlive.Checked then
  begin
  GroupKeep.Enabled:=True;
  optPing.Enabled:=True;
  optHTTP.Enabled:=True;

  labBesServer.Enabled:=True;
  editURL.Enabled:=True;

  labErk1.Enabled:=True;
  spinPing.Enabled:=True;
  labErk2.Enabled:=True;
  end
 else
  begin
  GroupKeep.Enabled:=False;
  optPing.Enabled:=False;
  optHTTP.Enabled:=False;

  labBesServer.Enabled:=False;
  editURL.Enabled:=False;

  labErk1.Enabled:=False;
  spinPing.Enabled:=False;
  labErk2.Enabled:=False;
  end;

 lvSrc.Items.BeginUpdate;
 lvSrc.Items.Clear;
 for i:=0 to MainForm.RasConnections.Count - 1 do
  with lvSrc.Items.Add do
   begin
    ImageIndex:=2;
    Caption:=TRitConnection(MainForm.RasConnections[i]).Name;
   end;
 lvSrc.Items.EndUpdate;
 GetMultiDial; //Get the MultiDial-Entries and build the GUI

 spinRedial.Value      :=((TRitConnection(MainForm.RasConnections[index]).DialAttemps) - 1);
 spinRedial.Text       :=IntToStr(spinRedial.Value);
 spinRedialPause.Value :=TRitConnection(MainForm.RasConnections[index]).DialPause;
 spinRedialPause.Text  :=IntToStr(spinRedialPause.Value);
 checkRedial.Checked   :=spinRedial.Value <> 0;
 if not checkRedial.Checked then
 begin
 spinRedial.Color:=clBtnFace;
 spinRedial.Value:=0;
 TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialAttemps:=1;
 spinRedial.Enabled:=False;
 spinRedialPause.Color:=clBtnFace;
 spinRedialPause.Enabled:=False;
 label19.Enabled:=False;
 label20.Enabled:=False;
 label21.Enabled:=False;
 end
else
 begin
 spinRedial.Color:=clWindow;
 spinRedial.Text:= IntToStr(TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialAttemps - 1);
 spinRedial.Enabled:=True;
 spinRedialPause.Color:=clWindow;
 spinRedialPause.Text:=IntToStr(TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialPause);
 spinRedialPause.Enabled:=True;
 label19.Enabled:=True;
 label20.Enabled:=True;
 label21.Enabled:=True;
 end;

 spinRedial.OnChange      :=spinRedialChange;
 spinRedialPause.OnChange :=spinRedialPauseChange;
 checkRedial.OnClick      :=checkRedialClick;
 spinDisconnect.OnCHange     :=AutoDisconnection;
 checkAutoDisconnect.OnClick :=AutoDisconnection;
 checkIntelligent.OnClick    :=AutoDisconnection;
 spinPwZsPause.OnChange      :=spinPwZsPauseChange;
 checkZsPw.OnClick           :=checkZsPwClick;
 lvUbernehmen.OnChange       :=lvUbernehmenChange;
 checkMultiFenster.OnClick    :=checkMultiFensterClick;



{
 This means: If the connection was saved at the beginning of this procedure
 (wasSaved:=True) then this is only an Update of the GUI, so the content has
 not changed. (This step should not be neccessary if my Event-Unlink works,
 but possibly I forget to unlink the Events of a feature I implement later. If
 so, this routine will catch this bug.
}
 If wasSaved then TRitConnection(MainForm.RasConnections[index]).IsSaved:=True;

end;

procedure TOptionenForm.FormCreate(Sender: TObject);

begin
// UnfinishedAction:=TClickAction.Create;
 Notebook.PageIndex:=0;
 PageControl1.ActivePage:=PageControl1.Pages[0];
 PhoneBookIds:=TStringList.Create;
 Caption:=MainForm.Languages.getString(110, MainForm.Options.Language);
 combSkConnect.Enabled:=OptSkConnect.Checked;
 combDkConnect.Enabled:=OptDkConnect.Checked;
 checkAnim.Tag:=182;
 checkAnim.Visible:=True;
 virMain.Filename:=Application.ExeName;
 lbLanguage.Items.Assign(MainForm.Languages.AvailableLanguages);
 lbLanguage.ItemIndex:=MainFOrm.Options.Language;
 Application.OnMessage := FormMsg;
 DragAcceptFiles(lvProglist.Handle, true); //I allow dragging files into                                      //the proglist.
 recreateTree(1); //Looks better...
 buildGUI;
 ListSetup;
end;

procedure TOptionenForm.tvChange(Sender: TObject; Node: TTreeNode);
 const Prev:String='';
begin
{if MainForm.Options.Language=SP_ENGLISCH then
 xy:=SP_DEUTSCH
else
 xy:=SP_ENGLISCH;
if (Node.Text = MainForm.Languages.getString(41, MainForm.Options.Language)) or (Node.Text = MainForm.Languages.getString(41, xy))  then
 Notebook.PageIndex:=0
else if (Node.Text = MainForm.Languages.getString(42, MainForm.Options.Language)) or (Node.Text = MainForm.Languages.getString(42, xy)) then
 Notebook.PageIndex:=1
else if Node.Text = 'Versteckte IE4-Optionen' then
 begin
  Notebook.PageIndex:=3;
  buildIEGui;
 end
else
 begin
 //If MainForm.Options.Hinweise then
 // if not okp then
 //  ShowHintw(REGKEY, MainForm.Languages.getString(95, MainForm.Options.Language)+':', IntTOStr(MainForm.Options.Language+45), MainForm.Languages.getString(122, MainForm.Options.Language), MainForm.Languages.getString(95, MainForm.Options.Language));
 Notebook.PageIndex:=2;
 aktName:=node.Text;
 buildRasGui(MainForm.IndexOfConnection(node.Text));
 end;
}

{
  What about this optimisation? Above, you see the old code. On the bottom of
  this comment, the new code...

  19 Lines --> 8 Lines (without comments)
}
NoteBook.PageIndex:=pTreeNodeInfo(Node.Data)^.iPageIndex;
If pTreeNodeInfo(Node.Data)^.ntType = ntConnection then
 begin
 aktName:=node.Text;
 buildRasGui(MainForm.IndexOfConnection(node.Text));
 end;
If pTreeNodeInfo(Node.Data)^.ntType = ntIE then
 buildIEGui;
end;


procedure TOptionenForm.FormShow(Sender: TObject);
begin
checkBug.Enabled:=not MainForm.NT;
isSaved:=True;
If MainForm.pmenu.Items.Count > 1 then //If Menu exists.... else we get an exception
  MainForm.pmenu.Items[MainForm.pmenu.Items.count-3].Enabled:=False;
Screen.Cursor:=crDefault;
//checkAutoDialClick(Sender);
end;


procedure TOptionenForm.optDkSettingsClick(Sender: TObject);
begin
combDkConnect.Enabled:=OptDkConnect.Checked;
if (Sender AS TsRadioButton).Name = 'optdkConnect' then
 begin
 MainForm.Options.DClick:=CONNECT;
 MainForm.Options.ConnectDk := combDkConnect.Items[CombDkConnect.ItemIndex];
 end;

if (Sender AS TsRadioButton).Name = 'optDkSettings' then
 MainForm.Options.DClick:=SHOW_OPTIONS;
end;

procedure TOptionenForm.btnUpdateClick(Sender: TObject);
var x:Integer;
begin
for x:=0 to MainForm.RasConnections.Count -1 do
 TRitConnection(MainForm.RasConnections[x]).ReloadRasOnly;
end;

procedure TOptionenForm.btnCreateClick(Sender: TObject);
begin
 if MainForm.Options.Hinweise then
    ShowHintw(REGKEY, MainForm.Languages.getString(94, MainForm.Options.Language)+':', '47', MainForm.Languages.getString(122, MainForm.Options.Language), MainForm.Languages.getString(94, MainForm.Options.Language));
 CreateRas;
end;

procedure TOptionenForm.btnLoeschClick(Sender: TObject);
begin
  if Application.MessageBox(PChar(Format(MainForm.Languages.getString(48, MainForm.Options.Language),[aktname])), PChar(MainForm.Languages.getString(97, MainForm.Options.Language)),
      MB_YESNO + MB_ICONWARNING+MB_SETFOREGROUND) = IDYES
  then begin

  if RasDeleteEntry(nil, PChar(aktname)) <> 0 then
     begin
     MessageBox(Application.Handle,PChar(MainForm.Languages.getString(49, MainForm.Options.Language)), PChar(MainForm.Languages.getString(93, MainForm.Options.Language)), mb_ok+mb_iconWarning+MB_SETFOREGROUND);
     Exit;
     end
  else
    TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DeleteEntries;
  end;                                              //Registry-Cleanup;
MainForm.getEnt;
MainForm.createMenu;
recreateTree(-123);
buildGUI;
end;


procedure TOptionenForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
MainForm.pmenu.Items[MainForm.pmenu.Items.count-3].Enabled:=True;
end;

procedure TOptionenForm.Button3Click(Sender: TObject);
begin
   TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
   if RasEditPhonebookEntry(Handle, nil,
      PChar(aktname)) <> 0 then
   MessageBox(Application.Handle, PChar(MainForm.Languages.getString(50, MainForm.Options.Language)), PChar(MainForm.Languages.getString(93, MainForm.Options.Language)), mb_ok+mb_IconWarning+MB_SETFOREGROUND);
end;


procedure TOptionenForm.btnDUNClick(Sender: TObject);
var windir, application:Pchar;
    StartupInfo: TStartupInfo;
    ProcessInfo: TProcessInformation;
begin
 windir:=GetEnvironmentStrings;
 if MainForm.NT then
  begin
   if GetSystemDirectory(windir, 255) = 0 then
    begin
    MessageBox(OptionenForm.Handle, PChar(MainForm.Languages.getString(105, MainForm.Options.Language)), PChar(MainForm.Languages.getString(96, MainForm.Options.Language)), mb_ok+mb_iconstop+MB_SETFOREGROUND);
    Exit;
    end;
   application:='rasphone.exe';
  end
 else
  begin
   if GetWindowsDirectory(windir, 255) = 0 then
    begin
     MessageBox(OptionenForm.Handle, PChar(MainForm.Languages.getString(105, MainForm.Options.Language)), PChar(MainForm.Languages.getString(96, MainForm.Options.Language)), mb_ok+mb_iconstop+MB_SETFOREGROUND);
     Exit;
    end;
   application:='EXPLORER.EXE ::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{992CFFA0-F557-101A-88EC-00DD010CCC48}';
  end;

 FillChar(StartupInfo, SizeOf(TStartupInfo), 0);
 StartupInfo.cb := Sizeof(TStartupInfo);
 if CreateProcess(nil,
                  application,
                  nil,
                  nil,
                  False,
                  NORMAL_PRIORITY_CLASS, // Prioritt
                  nil,                   // Environment
                  windir,     // Verzeichnis
                   StartupInfo,
                   ProcessInfo) then begin
 WaitForSingleObject(ProcessInfo.hProcess, INFINITE);
 CloseHandle(ProcessInfo.hProcess);
 recreateTree(0);
 MainForm.CreateMenu;
 btnUpdate.Click;
 end else MessageBox(OptionenForm.Handle, PChar(MainForm.Languages.getString(106, MainForm.Options.Language)), PChar(MainForm.Languages.getString(96, MainForm.Options.Language)), mb_ok+mb_iconstop+MB_SETFOREGROUND);
end;

procedure TOptionenForm.BitBtn1Click(Sender: TObject);
begin
Check(0); //0 is save and 1 is undo
end;




procedure TOptionenForm.optSkConnectClick(Sender: TObject);
begin
combskConnect.Enabled:=OptskConnect.Checked;
if (Sender AS TsRadioButton).Name = 'optSkConnect' then
  begin
  MainForm.Options.Scklick:=CONNECT;
  MainForm.Options.ConnectSk := combSkConnect.Items[CombSkConnect.ItemIndex];
  end;
  
if (Sender AS TsRadioButton).Name = 'optSkSettings' then
 MainForm.Options.Scklick:=SHOW_OPTIONS;
if (Sender AS TsRadioButton).Name = 'optSkMenu' then
 MainForm.Options.Scklick:=SHOW_MENU;
end;

procedure TOptionenForm.grpSpracheClick(Sender: TObject);
begin
 Cursor:=crHourglass;
 MainForm.Options.Language:=lbLanguage.ItemIndex;
 listSetup;
 MainForm.Languages.AutoChange(MainForm.Options.Language);
 optSkConnect.Caption:=MainForm.Languages.GetString(optSkConnect.Tag, MainForm.Options.Language);
 optSkSettings.Caption:=MainForm.Languages.GetString(optSkSettings.Tag, MainForm.Options.Language);
 optSkMenu.Caption:=MainForm.Languages.GetString(optSkMenu.Tag, MainForm.Options.Language);
 optSkRasMan.Caption:=MainForm.Languages.GetString(optSkRasMan.Tag, MainForm.Options.Language);
 optdkConnect.Caption:=MainForm.Languages.GetString(optdkConnect.Tag, MainForm.Options.Language);
 optdkSettings.Caption:=MainForm.Languages.GetString(optdkSettings.Tag, MainForm.Options.Language);
 optdkRasMan.Caption:=MainForm.Languages.GetString(optDkRasMan.Tag, MainForm.Options.Language);
 realignControls;
 Caption:=MainForm.Languages.getString(110, MainForm.Options.Language);
 recreateTree(1);
 MainForm.createMenu;
 If MainForm.Languages.LanguageName(lbLanguage.ItemIndex) = 'Deutsch' then
   Application.HelpFile:=ExtractFilePath(Application.ExeName)+'RasInTask.hlp'
  else
   Application.HelpFile:=ExtractFilePath(Application.ExeName)+'RasInTaske.hlp';
 cursor:=crDefault;
end;

procedure TOptionenForm.btnHelpClick(Sender: TObject);
begin
//  TTreeNodeType = (ntRoot, ntOptions, ntPhoneBook, ntConnection, ntIE);

if tv.Selected <> nil then
 case TTreeNodeInfo(tv.Selected.Data^).ntType of
   ntRoot: Application.HelpContext(10);
   ntOptions: case PageControl1.ActivePage.PageIndex of
               0: Application.HelpContext(20);
               1: Application.HelpContext(22);
               2: Application.HelpContext(35);
              end;
   ntPhoneBook: Application.HelpContext(10);
   ntConnection: case pc.ActivePage.PageIndex of
                  0: Application.HelpContext(120);
                  1: Application.HelpContext(126);
                  2: Application.HelpContext(125);
                  3: Application.HelpContext(127);
                  4: Application.HelpContext(129);
                 end;
   ntIE: Application.HelpContext(21);
 end;

// the new code is cleanewr, isn't it?
{
if Notebook.PageIndex = 0 then
 Application.HelpContext(20)
else
 begin
 if pc.ActivePage.Name = 'allg' then
  Application.HelpContext(120)
 else if pc.ActivePage.Name = 'pr' then
  Application.HelpContext(125)
 else
  Application.HelpContext(127);
 end;}

end;
procedure TOptionenForm.checkBugClick(Sender: TObject);
begin
 If CheckBug.Checked then
  begin
  if MainForm.Options.Hinweise then
   ShowHintw(REGKEY, MainForm.Languages.getString(123, MainForm.Options.Language), '114', MainForm.Languages.getString(122, MainForm.Options.Language), MainForm.Languages.getString(124, MainForm.Options.Language));
  end;
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).BugFix:=checkBug.checked;
end;


procedure TOptionenForm.pcChange(Sender: TObject);
begin
 if pc.ActivePage.Name='pr' then
  begin
   if GetNetscape <> '' then
    begin
    btnNetscapeMail.enabled:=True;
    btnNetscapeNews.enabled:=True;
    btnNetscapeNav.enabled:=True;
    end
   else
    begin
    btnNetscapeMail.enabled:=False;
    btnNetscapeNews.enabled:=False;
    btnNetscapeNav.enabled:=False;
    end;
    btnIE.Enabled       :=getIE(1) <> '';
    btnOEMail.Enabled       :=getIE(2) <> '';
    btnOENews.Enabled       :=getIE(3) <> '';
    btnDBrowser.Enabled := getIE(4) <> ''
  end;
end;

procedure TOptionenForm.Button6Click(Sender: TObject);
begin
if ((editFilen.Text <> '') AND (combStartart.ItemIndex <> -1)
    AND (combStartzeit.ItemIndex <> -1)) then
 begin
 addProgs(editFilen.Text, combStartart.ItemIndex, combStartzeit.ItemIndex, '');
 editFilen.Text:='';
 combStartart.ItemIndex:=-1;
 combStartZeit.ItemIndex:=-1;

 getList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
 TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).isSaved:=False;
 buildList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).Proglist);
 end
else
 MessageBeep(MB_OK);
end;

procedure TOptionenForm.btnLoeschenClick(Sender: TObject);
begin
if lvProgList.Selected <> nil then
 begin
 lvProgList.Selected.Delete;
 editFilen.Text:='';
 combStartart.ItemIndex :=-1;
 combStartzeit.ItemIndex:=-1;
 ProgListItem := nil;
 Button6.Caption:=MainForm.Languages.getString(134, MainForm.Options.Language);
 getList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
 TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;;
 end
else
 MessageBeep(mb_ok);
end;

procedure TOptionenForm.btnNetscapeMailClick(Sender: TObject);
begin
 AddProgs(GetNetscape+'\Program\netscape.exe', 0, 1,'-mail');
 GetList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
 TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;

end;

procedure TOptionenForm.btnNetscapeNewsClick(Sender: TObject);
begin
  AddProgs(GetNetscape+'\Program\netscape.exe', 0, 1,'-news');
  GetList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
end;

procedure TOptionenForm.btnNetscapeNavClick(Sender: TObject);
begin
  AddProgs(GetNetscape+'\Program\netscape.exe', 1, 1, '-browser');
  GetList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
end;

procedure TOptionenForm.Button2Click(Sender: TObject);
var Reg:TRegistry;
begin
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_CURRENT_USER;
Reg.OpenKey('\Software\PH-Arts\RasInTask\', True);
Reg.DeleteKey('Hints');
Reg.CloseKey;
Reg.Free;

checkHinweise.Checked:=True;
MessageBox(Application.Handle,PChar(MainForm.Languages.getString(127, MainForm.Options.Language)), PChar(MainForm.Languages.getString(94, MainForm.Options.Language)), mb_ok or mb_iconinformation or mb_setforeground);
end;


procedure TOptionenForm.aenderung(Sender: TObject);
begin
{
 I have to use aktName in the IndexOfConnection-call, because
 the Function would not find our connection if it's name changes.
}
 if (Sender As TsEdit).Name = 'editBname' then
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).UserName:=(Sender As TsEdit).Text;

 if (Sender As TsEdit).Name = 'editPass1' then
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).Password:=(Sender As TsEdit).Text;

end;

procedure TOptionenForm.btnBackClick(Sender: TObject);
var pwd:String;
begin
 EditName.Text:=tv.Selected.Text;
 aktName:=EditName.Text;
 if pwd <> '' then
  begin
  checkBug.Checked:=True;
  editPass1.Text:=pwd;
  end
 else
    checkBug.Checked:=False;
end;



procedure TOptionenForm.checkKeepAliveClick(Sender: TObject);
var at: TKeepAlive;
begin
 If checkKeepAlive.Checked then
  begin
  GroupKeep.Enabled:=True;
  optPing.Enabled:=True;
  optHTTP.Enabled:=True;

  labBesServer.Enabled:=True;
  editURL.Enabled:=True;

  labErk1.Enabled:=True;
  spinPing.Enabled:=True;
  labErk2.Enabled:=True;

  if optHTTP.Checked then
   at.AliveType:=ktHttp
  else
   at.AliveType:=ktPing;

  at.URL:=editURL.Text;
  at.Minutes:=spinPing.Value;
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).Alive:=at;

  end
 else
  begin
  at.aliveType:=ktNone;
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).Alive:=at;
  GroupKeep.Enabled:=False;
  optPing.Enabled:=False;
  optHTTP.Enabled:=False;

  labBesServer.Enabled:=False;
  editURL.Enabled:=False;

  labErk1.Enabled:=False;
  spinPing.Enabled:=False;
  labErk2.Enabled:=False;

  end


end;

procedure TOptionenForm.btnNeinClick(Sender: TObject);
begin
if not (Check(1) = idCancel) then
 Close;
end;

procedure TOptionenForm.CheckAutoRunClick(Sender: TObject);
begin
if checkAutorun.Checked then
  MainForm.Options.Autorun:=true
else
  MainForm.Options.Autorun:=false;

end;





procedure TOptionenForm.btnUndoClick(Sender: TObject);
begin
Check(1); //0 is save and 1 is undo
end;

procedure TOptionenForm.evtKeepChange(Sender: TObject);
var ka: TKeepAlive;
begin
  if optHTTP.Checked then
   ka.AliveType:=ktHttp
  else
   ka.AliveType:=ktPing;

  if not checkKeepAlive.Checked then
   ka.AliveType:=ktNone;

  ka.URL:=editURL.Text;
  ka.Minutes:=spinPing.Value;
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).Alive:=ka;

end;

procedure TOptionenForm.editNameExit(Sender: TObject);
begin
if editName.Text <> aktName then
  begin
  TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).NewName:=editName.Text;
  end;
end;

procedure TOptionenForm.combskConnectChange(Sender: TObject);
begin
 StrCopy(UnfinishedAction.Connection, PChar(combSkConnect.Items[combSkConnect.ItemIndex]));
end;

procedure TOptionenForm.combdkConnectChange(Sender: TObject);
begin
 MainForm.Options.ConnectDk := combDkConnect.Items[CombDkConnect.ItemIndex];
end;

procedure TOptionenForm.checkHinweiseClick(Sender: TObject);
begin
 MainForm.Options.Hinweise := checkHinweise.Checked;
end;


procedure TOptionenForm.checkAnimClick(Sender: TObject);
begin
MainForm.Options.Anim:=checkAnim.Checked;
end;

procedure TOptionenForm.evtAskChange(Sender: TObject);
var al: TAskLater;
begin
 al := TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).AskLater;
 al.AskName    := checkAskName.Checked;
 al.AskPassword:= checkAskPassword.Checked;
 with MainForm do
  begin
   TRitConnection(RasConnections[IndexOfConnection(aktName)]).AskLater:=al;
   TRitConnection(RasConnections[IndexOfConnection(aktName)]).IsSaved:=False;
  end;
 editBname.Enabled := not checkAskName.Checked;
 editPass1.Enabled := not checkAskPassword.Checked;
 Case editBname.Enabled of
  true: editBname.Color:=clWindow;
  false: editBname.Color:=clBtnFace;
 end;

 Case editPass1.Enabled of
  true: editPass1.Color:=clWindow;
  false: editPass1.Color:=clBtnFace;
 end;

 checkZsPw.Enabled     :=(checkAskName.checked OR checkAskPassword.checked);
 label4.Enabled        :=(checkAskName.checked OR checkAskPassword.checked);
 spinPwZsPause.Enabled :=(checkZsPw.Checked AND (checkAskName.checked OR checkAskPassword.checked));
 label25.Enabled       :=(checkAskName.checked OR checkAskPassword.checked);

 Case spinPwZsPause.Enabled of
  true: begin spinPwZsPause.Color:=clWindow; spinPwZsPause.value:=al.Timeout; end;
  false: begin spinPwZsPause.Color:=clBtnFace; spinPwZsPause.value:=0; end;
 end;
 if (checkAskPassword.checked) then
   TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).PassWord:='';
 if (checkAskName.checked) then
   TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).UserName:='';
end;




procedure TOptionenForm.lbUrlsClick(Sender: TObject);
begin
editUrlList.Text:=lbUrls.Items[lbUrls.ItemIndex];
sbIeUp.Enabled  :=(lbUrls.ItemIndex <> -1);
sbIeDown.Enabled:=(lbUrls.ItemIndex <> -1);
end;

procedure TOptionenForm.SpeedButton1Click(Sender: TObject);
begin
MainForm.IEOptions.IsSaved:=False;
if editURLList.Text <> '' then
 if lbUrls.Items.IndexOf(editUrlList.Text) <> -1 then
  begin
  if Pos('%s', editUrlList.Text) = 0 then
   begin
   ShowMessage('sodd off');
   exit;
   end; 
  lbUrls.Items.Add(editUrlList.Text);
  MainForm.IEOptions.Urls.Assign(lbUrls.Items);
  MainForm.IEOptions.Issaved:=False;
  end;
end;

procedure TOptionenForm.SpeedButton2Click(Sender: TObject);
begin
 MainForm.IEOptions.IsSaved:=False;
 if lbUrls.ItemIndex <> -1  then
  lbUrls.Items.Delete(lbUrls.ItemIndex);
end;

procedure TOptionenForm.buildIEGui;
var wasSaved:Boolean;
begin
wasSaved:=MainForm.IeOptions.IsSaved;
editCompanyName.Text:=MainForm.IEOptions.CompanyName;
editWinTitle.Text:=MainForm.IEOptions.WinTitle;
checkCache.Checked:=MainForm.IEOptions.UseCache;
lbURLS.Items.Assign(MainForm.IEOptions.URLS);
MainForm.IeOptions.IsSaved:=wasSaved;
end;

procedure TOptionenForm.checkCacheClick(Sender: TObject);
begin
MainForm.IEOptions.UseCache:=checkCache.Checked;
end;

procedure TOptionenForm.editCompanyNameChange(Sender: TObject);
begin
MainForm.IEOptions.CompanyName:=EditCompanyName.Text;
end;

procedure TOptionenForm.editWinTitleChange(Sender: TObject);
begin
MainForm.IEOptions.WiNTitle:=editWinTitle.Text;
end;


procedure TOptionenForm.sbIEUpClick(Sender: TObject);
var oldIndex:Integer;
begin
if lbUrls.ItemIndex <> 0 then
 begin
 oldIndex:=lbUrls.ItemIndex;
 lbUrls.Items.Move(oldIndex, oldIndex-1);
 lbUrls.ItemIndex:=oldIndex-1;
 lbUrls.SetFocus;
 end;
end;

procedure TOptionenForm.sbIEDownClick(Sender: TObject);
var oldIndex:Integer;
begin
if lbUrls.ItemIndex <> (lbUrls.Items.Count -1) then
 begin
 oldIndex:=lbUrls.ItemIndex;
 lbUrls.Items.Move(oldIndex, OldIndex+1);
 lbUrls.ItemIndex:=OldIndex+1;
 lbUrls.SetFocus;
 end;
end;





procedure TOptionenForm.checkRedialClick(Sender: TObject);
begin
if not checkRedial.Checked then
 begin
 spinRedial.Color:=clBtnFace;
 spinRedial.Value:=0;
 TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialAttemps:=1;
 spinRedial.Enabled:=False;
 spinRedialPause.Color:=clBtnFace;
 spinRedialPause.Enabled:=False;
 label19.Enabled:=False;
 label20.Enabled:=False;
 label21.Enabled:=False;
 end
else
 begin
 spinRedial.Color:=clWindow;
 spinRedial.Text:= IntToStr(TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialAttemps);
 spinRedial.Enabled:=True;
 spinRedialPause.Color:=clWindow;
 spinRedialPause.Text:=IntToStr(TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialPause);
 spinRedialPause.Enabled:=True;
 label19.Enabled:=True;
 label20.Enabled:=True;
 label21.Enabled:=True;
 end;
end;

procedure TOptionenForm.spinRedialChange(Sender: TObject);
begin
TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialAttemps:= spinRedial.Value + 1;
//Why -1? The Property means Attempts; the spin means Retries (althought the spin is 0, RasInTask will dial 1 time)
end;

procedure TOptionenForm.spinRedialPauseChange(Sender: TObject);
begin
TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).DialPause:=spinRedialPause.Value;
end;

procedure TOptionenForm.SpeedButton3Click(Sender: TObject);
var x: Integer;
begin
lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;
for x:=0 to lvSrc.Items.Count -1 do
 with lvDst.Items.Add do
  begin
  caption:=lvSrc.Items[x].Caption;
  ImageIndex:=2;
  end;
lvSrc.Items.Clear;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
setMultiDial;
end;

procedure TOptionenForm.SpeedButton6Click(Sender: TObject);
var x:Integer;
begin
lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;
for x:=0 to lvDst.Items.Count -1 do
 with lvSrc.Items.Add do
  begin
  caption:=lvDst.Items[x].Caption;
  ImageIndex:=2;
  end;

lvDst.Items.Clear;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
end;

procedure TOptionenForm.SpeedButton4Click(Sender: TObject);
begin
if lvSrc.SelCount < 1 then
 begin
 MessageBeep(MB_OK);
 Exit;
 end;

lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;

with lvDst.Items.Add do
 begin
 Caption   :=lvSrc.Selected.Caption;
 ImageIndex:=2;
 end;
lvsrc.Selected.Delete;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
SetMultiDial;
end;

procedure TOptionenForm.SpeedButton5Click(Sender: TObject);
begin
if lvDst.SelCount < 1 then
 begin
 MessageBeep(MB_OK);
 Exit;
 end;

lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;

with lvsrc.Items.Add do
 begin
 Caption   :=lvdst.Selected.Caption;
 ImageIndex:=2;
 end;
lvdst.Selected.Delete;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
SetMultiDial;
end;

procedure TOptionenForm.checkMultiDialClick(Sender: TObject);
begin
if not CheckMultiDial.Checked then
 begin
  lvSrc.Enabled:=False;
  lvDst.Enabled:=False;
  speedButton3.Enabled:=False;
  speedButton4.Enabled:=False;
  speedButton5.Enabled:=False;
  speedButton6.Enabled:=False;
  lvUbernehmen.Enabled:=False;
  checkMultiFenster.Enabled:=False;
 end
 else
 begin
  lvSrc.Enabled:=True;
  lvDst.Enabled:=True;
  speedButton3.Enabled:=True;
  speedButton4.Enabled:=True;
  speedButton5.Enabled:=True;
  speedButton6.Enabled:=True;
  lvUbernehmen.Enabled:=True;
  checkMultiFenster.Enabled:=True;
 end;
 SetMultiDial;
end;

procedure TOptionenForm.SetMultiDial;
var x       : Integer;
    templist: TStringList;
begin
templist:=TStringList.Create;
if lvDst.Items.Count = 0 then
 checkMultiFenster.Checked:=True
else
 begin
 for x:= 0 to lvDst.Items.Count -1 do
  templist.Add(lvDst.Items[x].Caption);
 end;

with TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial do
 begin
 Active     :=checkMultiDial.Checked;
 UseProgs   :=lvUbernehmen.Items[1].Checked;
 UseKeep    :=lvUbernehmen.Items[0].Checked;
 UseDisc    :=lvUbernehmen.Items[2].Checked;
 ShowWindow :=checkMultiFenster.Checked;
 IsSaved    :=False;
 DialList   :=templist;
 end;
templist.Free;
end;

procedure TOptionenForm.GetMultiDial;
var x:Integer;
begin
lvUbernehmen.OnChange      :=nil;
checkMultiDial.OnClick    :=nil;
checkMultiFenster.OnClick :=nil;
with TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial do
 begin
 checkMultiDial.Checked    := Active;
 if not CheckMultiDial.Checked then
 begin
  lvSrc.Enabled:=False;
  lvDst.Enabled:=False;
  speedButton3.Enabled:=False;
  speedButton4.Enabled:=False;
  speedButton5.Enabled:=False;
  speedButton6.Enabled:=False;
  lvUbernehmen.Enabled:=False;
  checkMultiFenster.Enabled:=False;
 end
 else
 begin
  lvSrc.Enabled:=True;
  lvDst.Enabled:=True;
  speedButton3.Enabled:=True;
  speedButton4.Enabled:=True;
  speedButton5.Enabled:=True;
  speedButton6.Enabled:=True;
  lvUbernehmen.Enabled:=True;
  checkMultiFenster.Enabled:=True;
 end;
 lvUbernehmen.Items[1].Checked:=UseProgs;
 lvUbernehmen.Items[0].Checked:=UseKeep;
 lvUbernehmen.Items[2].Checked:=UseDisc;


 checkMultiFenster.Checked := ShowWindow;
 IsSaved    := True;
 for x:=0 to DialList.Count -1 do
  with lvdst.Items.Add do
   begin
   ImageIndex:=2;
   Caption:=DialList[x];
   end;
 end;
lvUbernehmen.OnChange     :=lvUbernehmenChange;
checkMultiDial.OnClick    :=checkMultiDialClick;
checkMultiFenster.OnClick :=checkMultiFensterClick;
end;

procedure TOptionenForm.tvEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
//we will not allow the user to change preseted Items. Only names of
//connections...
AllowEdit:=(pTreeNodeInfo(Node.Data)^.ntType = ntConnection)
end;

procedure TOptionenForm.tvEdited(Sender: TObject; Node: TTreeNode;
  var S: String);
begin
 editname.Text:=tv.Selected.Text;
 EditName.SetFocus;
 tv.SetFocus;
end;

procedure TOptionenForm.tvKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
Case Key of
 VK_F2: if tv.Selected <> nil then tv.Selected.EditText;
 VK_DELETE: if tv.Selected <> nil then
             if not tv.IsEditing then
              begin
              aktName:=tv.Selected.Text;
              btnLoesch.Click;
              end;
End;
end;

procedure TOptionenForm.Umbenennen1Click(Sender: TObject);
begin
if tv.Selected <> nil then
 if not tv.IsEditing then
  tv.Selected.EditText;
end;

procedure TOptionenForm.Lschen1Click(Sender: TObject);
begin
if tv.Selected <> nil then
 if not tv.IsEditing then
  begin
  aktName:=tv.Selected.Text;
  btnLoesch.click;
  end;
end;

procedure TOptionenForm.Erstellen1Click(Sender: TObject);
begin
 btnCreate.Click;
end;

procedure TOptionenForm.tvMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
if Button = mbRight then
 if tv.GetNodeAt(x, y) <> nil then
 begin
 tv.GetNodeAt(x, y).Selected:=True;
 if ptreeNodeInfo(tv.Selected.Data)^.ntType <> ntConnection then
   begin
   pmTv.Items[0].Visible:=False;
   pmTv.Items[1].Visible:=False;
   pmTv.Items[2].Visible:=False;
   end
 else
   begin
   pmTv.Items[0].Visible:=True;
   pmTv.Items[1].Visible:=True;
   pmTv.Items[2].Visible:=True;

   end
 end
 else
   begin
   pmTv.Items[0].Visible:=False;
   pmTv.Items[1].Visible:=False;
   pmTv.Items[2].Visible:=False;
   end
end;


procedure TOptionenForm.checkConnectWindowClick(Sender: TObject);
begin
MainForm.Options.ConnectWindow := checkConnectWindow.Checked;
end;

procedure TOptionenForm.checkMultiFensterClick(Sender: TObject);
begin
TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial.ShowWindow:=checkMultiFenster.checked;
end;

procedure TOptionenForm.AddProgs(filename: String; ltype, ltime: Byte; parameters: String);
var x,z: Integer;
    tmp: String;
function isUrl(input: String): boolean;
 begin
 if ((pos(input, 'http://') <>0) OR (pos(input, 'ftp://')<>0) OR
     (pos(input, 'mailto:') <> 0) OR (pos(input, 'www.') <> 0)) then
  Result:=True
 else
  Result:=False;
 end;
begin
 lvProgList.Items.BeginUpdate;
 for x:=0 to lvProgList.Items.Count - 1 do
  if lvProgList.Items[x] = ProgListItem then
   with lvProgList.Items[x] do
    begin
    if isUrl(filename) then
     ImageIndex := ilSys.GetImageIndex('c:\test.htm', false, []) //->We can use a File that does not exist
    else
     ImageIndex := ilSys.GetImageIndex(GetExpression(FileName, 1), false, []);
    Data := New( pProgItemInfo ); //-->Custom type. See Top of unit.
    pProgItemInfo(Data).iLType := ltype;
    pProgItemInfo(Data).iLTime := ltime;
    Caption:=GetExpression(FileName, 1);
    tmp:='';
    if Parameters <> '' then tmp := Parameters;
    z:=CountExpressions(FileName);
    if z < 0 then z:=z*(-1);
    if z >=2 then
     tmp:=Copy(FileName, length(GetExpression(FileName, 1))+2, length(FileName));
    pProgItemInfo(Data).sParameters:=tmp;
    SubItems.Add(tmp);
    SubItems.Add(combStartart.Items[ltype]);
    SubItems.Add(combStartzeit.Items[ltime]);
    Button6.Caption:=MainForm.Languages.getString(134, MainForm.Options.Language);
    ProgListItem:=nil;
    lvProgList.Items.EndUpdate;
    Exit;
    end;

 with lvProgList.Items.Add do
 begin
    Data := New( pProgItemInfo ); //-->Custom type. See Top of unit.
    pProgItemInfo(Data).iLType := ltype;
    pProgItemInfo(Data).iLTime := ltime;
    if isUrl(filename) then
     ImageIndex := ilSys.GetImageIndex('c:\test.htm', false, []) //->We can use a File that does not exist
    else
     ImageIndex := ilSys.GetImageIndex(GetExpression(FileName, 1), false, []);
    Caption:=GetExpression(FileName, 1);
    tmp:='';
    if Parameters <> '' then tmp := Parameters;
    z:=CountExpressions(FileName);
    if z < 0 then z:=z*(-1);
    if z >=2 then
     tmp:=Copy(FileName, length(GetExpression(FileName, 1))+2, length(FileName));
    pProgItemInfo(Data).sParameters:=tmp;
    SubItems.Add(tmp);
    SubItems.Add(combStartart.Items[ltype]);
    SubItems.Add(combStartzeit.Items[ltime]);
 end;
 lvProgList.Items.EndUpdate;
 //getList(TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktname)]).Proglist);
 TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
 //I resize the first field, containig the full path to a smaller size, that the other
 //two fields fit the listbox
 lvProgList.Columns.BeginUpdate;
 lvProgList.Columns[0].width:=lvProglist.Width - (lvProglist.Canvas.TextWidth(MainForm.Languages.getString(222, MainForm.Options.Language)) + lvProglist.Canvas.TextWidth(MainForm.Languages.getString(223, MainForm.Options.Language))+ lvProglist.Canvas.TextWidth('Parameters'));
 lvProgLIst.Columns.EndUpdate;

end;


procedure TOptionenForm.lvProglistClick(Sender: TObject);
begin
 if lvProgList.Selected <> nil then
  with lvProgList.Selected do
   begin
   editFilen.Text:=Caption;
   combStartart.ItemIndex :=pProgItemInfo(Data)^.iLType;
   combStartzeit.ItemIndex:=pProgItemInfo(Data)^.iLTime;
   ProgListItem := lvProgList.Selected;
   editFilen.Text:=editFilen.Text+pProgItemInfo(Data)^.sParameters;
   Button6.Caption:=MainForm.Languages.getString(38, MainForm.Options.Language);
   end
 else
  begin
   editFilen.Text:='';
   combStartart.ItemIndex :=-1;
   combStartzeit.ItemIndex:=-1;
   ProgListItem := nil;
   Button6.Caption:=MainForm.Languages.getString(134, MainForm.Options.Language);
  end;
end;





procedure TOptionenForm.combPopUpChange(Sender: TObject);
begin
MainForm.Options.PopUpType:=combPopUp.ItemIndex;
end;

procedure TOptionenForm.btnOkClick(Sender: TObject);
begin
if not (Check(0) = idCancel) then
 Self.Close;
end;


procedure TOptionenForm.checkZsPwClick(Sender: TObject);
var asklater: TAskLater;
begin
 asklater:=TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).AskLater;
 asklater.SavePassword:=checkZsPw.Checked;
 spinPwZsPause.Enabled:=checkZsPw.Checked;
 Case spinPwZsPause.Enabled of
  true: begin spinPwZsPause.Color:=clWindow; spinPwZsPause.value:=asklater.Timeout; end;
  false: begin spinPwZsPause.Color:=clBtnFace; spinPwZsPause.value:=0; end;
 end;
 TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).AskLater:=asklater;
end;

procedure TOptionenForm.spinPwZsPauseChange(Sender: TObject);
var asklater: TAskLater;
begin
 asklater:=TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).AskLater;
 asklater.Timeout:=spinPwZsPause.Value;
 TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).AskLater:=asklater;
end;

procedure TOptionenForm.lvConnectionsDblClick(Sender: TObject);
var x:Integer;
begin
for x:=0 to Tv.Items.Count -1 do
 begin
  if pTreeNodeInfo(tv.Items[x].Data)^.ntType = ntPhoneBook then
   tv.Items[x].Expand(true);
  if pTreeNodeInfo(tv.Items[x].Data)^.ntType = ntConnection then
   if tv.Items[x].Text = lvConnections.Selected.Caption then
    tv.Items[x].Selected:=True;
 end;
end;


procedure TOptionenForm.cgUbernehmenCheckBoxClick(Sender: TObject;
  NDX: Integer; Checked: Boolean);
begin
 Case NDX of
 0: TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial.UseKeep:=checked;
 1: TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial.UseProgs:=checked;
 2: TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial.UseDisc:=checked;
 end;
end;





procedure TOptionenForm.AutoDisconnection(Sender: TObject);
var dc: TAutoDisconnect;
begin
If checkAutoDisconnect.Checked then
 begin
 spinDisconnect.Enabled:=True;
 spinDisconnect.Color:=ClWindow;
 checkIntelligent.Enabled:=True;
 if checkIntelligent.Checked then
  dc.dcType:=dtIntelligent
 else
  dc.dcType:=dtAlways;
 end
else
 begin
 spinDisconnect.Enabled:=False;
 spinDisconnect.Color:=ClBtnFace;
 checkIntelligent.Enabled:=False;
 dc.dcType:=dtNone;
 end;
dc.dcTime:=spinDisconnect.Value;
TRitConnection(MainForm.RasConnections[MainFOrm.IndexOfConnection(aktName)]).Disconnect:=dc;
end;

procedure TOptionenForm.spinCountDownChange(Sender: TObject);
begin
MainForm.Options.Countdown := spinCountDown.Value;
end;

procedure TOptionenForm.checkReconnectClick(Sender: TObject);
begin
  TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).Reconnect:=checkReconnect.Checked;
end;



procedure TOptionenForm.btnIEClick(Sender: TObject);
begin
AddProgs(Getie(1), 0, 1,'');
GetList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
end;

procedure TOptionenForm.btnOEMailClick(Sender: TObject);
begin
AddProgs(Getie(2), 0, 1,'');
GetList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
end;

procedure TOptionenForm.btnDBrowserClick(Sender: TObject);
begin
AddProgs(Getie(4), 0, 1,'');
GetList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
end;

procedure TOptionenForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
Application.OnMessage:=nil;
end;

procedure TOptionenForm.prDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
 Accept:=False;
 if Source is TlistView then
   if (Source As TListView).Name = 'lvProglist' then
    Accept:=true;
end;

procedure TOptionenForm.prDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
if lvProgList.Selected <> nil then
 btnLoeschen.Click;
end;


procedure TOptionenForm.sSpeedButton1Click(Sender: TObject);
begin
if OpenDialog1.Execute then
 editFilen.Text:=OpenDialog1.FileName;
end;

procedure TOptionenForm.btnOENewsClick(Sender: TObject);
begin
AddProgs(Getie(3), 0, 1,'');
GetList(TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).ProgList);
TRitConnection(MainForm.RasConnections.Items[MainForm.IndexOfConnection(aktName)]).IsSaved:=False;
end;

procedure TOptionenForm.lvDDChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin

if (not buildingGUI) AND (item.caption <> '') then
 begin
 TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(item.caption)]).sInAutoDial:=item.checked;
 end;
end;

procedure TOptionenForm.checkForceClick(Sender: TObject);
begin
if not buildingGUI then
 MainForm.Options.Force:=checkForce.Checked;
end;

procedure TOptionenForm.spinCADChange(Sender: TObject);
begin
CheckLWC.Visible:=spinCAD.Value = 0;

if not CheckLWC.Visible then
begin
if checkAutoDial.Checked then
 begin
  groupBox18.Enabled:=true;
  checkForce.Enabled:=true;
  lvDD.Enabled:=true;
  lvDD.Color:=clWindow;
  spinCAD.Enabled:=true;
  spinCAD.Color:=clWindow;
 end
else
 begin
  groupBox18.Enabled:=false;
  checkForce.Enabled:=false;
  lvDD.Enabled:=false;
  lvDD.Color:=clBtnFace;
  spinCAD.Enabled:=false;
  spinCAD.Color:=clBtnFace;
 end;
end
else
 begin
  if checkLWC.Checked then
  begin
  lvDD.Enabled:=true;
  lvDD.Color:=clWindow;
  end
 else
  begin
  lvDD.Enabled:=false;
  lvDD.Color:=clBtnFace;
  end
 end;

if not buildingGUI then
 MainFOrm.Options.CAD:=spinCAD.Value;

end;

procedure TOptionenForm.checkLWCClick(Sender: TObject);
begin
if not buildingGUI then
 if checkLWC.Checked then
  begin
  lvDD.Enabled:=true;
  lvDD.Color:=clWindow;
  end
 else
  begin
  lvDD.Enabled:=false;
  lvDD.Color:=clBtnFace;
  end

end;

procedure TOptionenForm.checkAutoDialMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var i:Integer;
begin
if checkAutoDial.Checked then
 begin
  groupBox18.Enabled:=true;
  checkForce.Enabled:=true;
  lvDD.Enabled:=true;
  lvDD.Color:=clWindow;
  spinCAD.Enabled:=true;
  spinCAD.Color:=clWindow;
 end
else
 begin
  groupBox18.Enabled:=false;
  checkForce.Enabled:=false;
  lvDD.Enabled:=false;
  lvDD.Color:=clBtnFace;
  spinCAD.Enabled:=false;
  spinCAD.Color:=clBtnFace;
 end;
//Since changing TRitConnection.AutoDial calls RasSetEntryProperties
//and since this function is so slow, we won't change anything
//while updating the gui.
Application.ProcessMessages;
if not buildingGUI then
  begin
  for i:=0 to MainForm.RasConnections.Count -1 do
    TRitConnection(MainForm.RasConnections[i]).AutoDial:=checkAutoDial.Checked;
  MainForm.Options.IsSaved:=false;
  end;
end;

procedure TOptionenForm.checkAutoDialClick(Sender: TObject);
begin
if checkAutoDial.Checked then
 begin
  groupBox18.Enabled:=true;
  checkForce.Enabled:=true;
  lvDD.Enabled:=true;
  lvDD.Color:=clWindow;
  spinCAD.Enabled:=true;
  spinCAD.Color:=clWindow;
  checkCAD.Enabled:=True;
 end
else
 begin
  groupBox18.Enabled:=false;
  checkForce.Enabled:=false;
  lvDD.Enabled:=false;
  lvDD.Color:=clBtnFace;
  spinCAD.Enabled:=false;
  spinCAD.Color:=clBtnFace;
  checkCAD.Enabled:=False;
 end;
end;

procedure TOptionenForm.checkCADClick(Sender: TObject);
begin
if not checkCAD.Checked then
 begin
 spinCAD.Visible:=false;
 label37.Visible:=false;
 checkLWC.Visible:=false;
 lvDd.Enabled:=true;
 end
else
 begin
 spinCAD.Visible:=true;
 label37.Visible:=true;
 checkLWC.Visible:=true;
 lvDD.Enabled:=checkLWC.Checked;
 end;

if not buildingGUI then
 MainForm.Options.UseCad:=checkCAD.Checked;
end;

procedure TOptionenForm.checkDetDlgClick(Sender: TObject);
begin
if not buildingGUI then
 MainForm.Options.DetDlg:=checkDetDlg.Checked;
end;

procedure TOptionenForm.checkRasManClick(Sender: TObject);
begin
spinLogEnt.Enabled:=checkRasMan.checked;
if spinLogEnt.Enabled then
 spinLogEnt.Color:=clWindow
else
 spinLogEnt.Color:=clBtnFace;
if not buildingGUI then
 MainForm.Options.Logging:=checkRasMan.Checked;
end;

procedure TOptionenForm.spinLogEntChange(Sender: TObject);
begin
if not BuildingGUI then
 MainForm.Options.LogCount:=spinLogEnt.Value;
end;

procedure TOptionenForm.checkSplashClick(Sender: TObject);
begin
if not BuildingGUI then
 MainForm.Options.Splash:=checkSplash.Checked;
end;

procedure TOptionenForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if key = vk_f1 then
  btnHelp.CLick;
end;

procedure TOptionenForm.optDkRasmanClick(Sender: TObject);
begin
if not buildingGUI then
 MainForm.Options.RasMan := rcShift;
optSkRasMan.Checked:=not optDkRasman.Checked;
end;

procedure TOptionenForm.optSkRasManClick(Sender: TObject);
begin
if not buildingGUI then
 MainForm.Options.RasMan := rcSingle;
optDkRasMan.Checked:=not optSkRasman.Checked; //since they have different Parents,
                                              //settin GroupIndex does not work
end;

procedure TOptionenForm.lvUbernehmenChange(Sender: TObject;
  Item: TListItem; Change: TItemChange);
begin
 if aktName = '' then Exit;
 Case Item.Index of
 0: TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial.UseKeep:=item.checked;
 1: TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial.UseProgs:=item.checked;
 2: TRitConnection(MainForm.RasConnections[MainForm.IndexOfConnection(aktName)]).MultiDial.UseDisc:=item.checked;
 end;
end;

end.
