{***************************************************************
 *
 * Unit Name: NotifyThread
 * Purpose  : Contains a thread that will create a TEvent-Object,
              which will be specialized to an Event that is fired,
              when either a connection is dialed or disconnected.

              If the event is fired, the Synchronized procedure
              will update the RitConnection-Objects of MainForm.

              Since the RasConnectionNotification() does not work with
              Windows 95 below OSR2 or DUN 1.2, I loose the compatibility
              I reimplemented in this release. Shit. I could also
              try to get state-changes with the help of a timer, but
              I already use many of them and I like the object-oriented
              Thread based Events that Microsoft introduced...
 * Author   : Pilif <pilit@dataway.ch>. For help how to use the
              System Events, please look also at the -better documetned-
              Events-Tutorial at http://www.mittelschule.ch/pilif. I
              wrote it to understand the functions I have to all here..
 * History  : none. This is the first Release...
 *
 ****************************************************************}

{
  Before we begin: As you can See, I use only one thread for all the
  connections (I put ERROR_INVALID_HANDLE into the RasConnectionNotification
  funtion). I could also launch on ethread for every TRitconnection-object.

  I could easily manage the threads either in the object or in the
  RasConnections list. Why have I choosen this 'dirty' method? I do not wish
  to use very much of CPU-Time and Memory on the system of my 'customers'.

  RasInTask is a little tool, so this would not be the best mehtod.
}
unit NotifyThread;

interface

uses
  Classes, SysUTILS, Windows, dialogs, extctrls, Messages;

type
  TRasNotifyThread = class(TThread)
  private
//    FRasNotificationEvent: THandle;
    FNotiArray: Array[0..1] of THandle;
    FAPIBugFixTimer: TTimer;
    procedure UpdateObjects; //this bill be called with synchronize
    procedure TimerEvent(Sender: TObject);
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean);
    destructor Destroy; override;
    procedure Terminate;
  end;

implementation

uses Main, RasExt, RitConnection;

{ I removed the warning from Borland about synchronizing, because
  I am using a german version of delphi. So ou probably could not do
  much with the big comment.... }

{ TRasNotifyThread }

{ Again, a big comment about a timer:

  Normally (without VCL), the whole functionaality does also work without
  the timer: The Windows event at disconnection is fired BOFORE the
  Handle of the connection is cleared.

  If I call Synchronize(UpdateObjects) without the Timer, I
  have a well known problem: Since the Call to the RitConnection-
  Event will be synchronized by the VCL, the getHandle-Function
  will return a valid handle. The Active-Property remains true.

  This means: The Function will be listed under the Descinnect-
  Submenu.

  If I do not correct this, RasInTas will crash Rnaapp.dll when
  RasInTask tries the next time to access (disconnect) the
  Connection: GPF!

  This is a problem I had very often during the developement: The
  Object and the API became asynchronous and I got a GPF or an
  Access Violation.

  See my Homepage for some funny details about the developement
}

procedure TRasNotifyThread.TimerEvent(Sender: Tobject);
begin
 FApiBugFixTimer.Enabled:=False;
 Synchronize(UpdateObjects);
end;

constructor TRasNotifyThread.Create(CreateSuspended: Boolean);
begin
  inherited Create(CreateSuspended);
  FreeOnTerminate := True;
  FAPIBugFixTimer:=TTImer.create(nil);
  FAPIBugFixTimer.Enabled:=False;
  FAPIBugFixTimer.Interval:=250;
  FAPIBugFixTimer.OnTimer :=TimerEvent;

  FNotiArray[0] := CreateEvent(nil, False, False, nil);
  if RasConnectionNotification(integer(INVALID_HANDLE_VALUE), FNotiArray[0], RASCN_Connection or RASCN_Disconnection) <> 0 then
   begin
   sleep(100);
   Self.Terminate
   end;
end;

destructor TRasNotifyThread.Destroy;
begin
  FApiBugFixTimer.Free;
  CloseHandle(FNotiArray[0]);
  FNotiArray[0]:=0;
  inherited Destroy;
end;

procedure TRasNotifyThread.Terminate;
begin
//  SetEvent(FNotiArray[0]);
  inherited Terminate;
end;

{
 In pure API, the following would be much easier: Call to
 WaitForSingelObject
 would be enought, but under Delphi, we have the probelem, that the VCL cannot
 terminate a threat that is waiting, because it sends a Message to the thread,
 which cannot be evaluated since we are currentely in the WaitForSingleObject
 directive.
 MsgWaitForMultipleObjects does the job. The function returns also, if a message
 was sent to the thread. But now we have a syntax that is much more complex
}
procedure TRasNotifyThread.Execute;
var Index:Integer;
    Msg  :TMsg;
begin
  while not Terminated do
  begin
    Index := MsgWaitForMultipleObjects(1,
                                       FNotiArray,
                                       False,
                                       INFINITE,
                                       QS_ALLINPUT);
    if Index >= 1 then
     begin //Ups. This is a message
      while PeekMessage(Msg,0,0,0,PM_REMOVE) do

       if Msg.Message = WM_QUIT then
        Terminate
       else
        begin
         TranslateMessage(Msg);
         DispatchMessage(Msg);
        end;
     end
    else //RasNotificationEvent is fired!
     begin
     sleep(500);
     FApiBugFixTimer.Enabled := True;
     end;
  end;
end;

procedure TRasNotifyThread.UpdateObjects;
var
  x   : Integer;
begin
if Assigned(MainForm.RasConnections) then
 begin
 for x:=0 to MainForm.RasConnections.Count - 1 do
   TRitConnection(MainForm.RasConnections[x]).EventTriggered;
 MainForm.createMenu;
 end;
end;


end.
