unit Multi;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, Registry, ComCtrls, sCtrls, ImgList;

type
  TMultiForm = class(TForm)
    SrcLabel: TLabel;
    DstLabel: TLabel;
    lvSrc: TListView;
    lvDst: TListView;
    ImageList: TImageList;
    SpeedButton3: TsSpeedButton;
    SpeedButton4: TsSpeedButton;
    SpeedButton5: TsSpeedButton;
    SpeedButton6: TsSpeedButton;
    btnOK: TsSpeedButton;
    BitBtn2: TsSpeedButton;
    BitBtn3: TsSpeedButton;
    procedure SetButtons;
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MultiForm: TMultiForm;

implementation

uses Main, Info;

{$R *.DFM}


procedure TMultiForm.SetButtons;
var
  SrcEmpty, DstEmpty: Boolean;
begin
  SrcEmpty := lvSrc.Items.Count = 0;
  DstEmpty := lvDst.Items.Count = 0;
  SpeedButton4.Enabled := not SrcEmpty;
  SpeedButton3.Enabled := not SrcEmpty;
  SpeedButton5.Enabled := not DstEmpty;
  SpeedButton6.Enabled := not DstEmpty;
end;

procedure TMultiForm.FormShow(Sender: TObject);
var reg:TRegistry;
begin
MainForm.Languages.AutoChange(MainForm.Options.Language);
ShowHintw(REGKEY, MainForm.Languages.getString(123, MainForm.Options.Language), '181', MainForm.Languages.getString(122, MainForm.Options.Language), MainForm.Languages.getString(124, MainForm.Options.Language));
reg:=TRegistry.Create;
reg.RootKey:=HKEY_CURRENT_USER;
Reg.OpenKey('\Software\PH-Arts\RasInTask\Dialogs\MultiForm', true);
if Reg.ValueExists('Width') then
  Width:=Reg.ReadInteger('Width');
if Reg.ValueExists('Height') then
  Height:=Reg.ReadInteger('Height');
Reg.CloseKey;
Reg.free;
SetButtons;
end;

procedure TMultiForm.FormClose(Sender: TObject; var Action: TCloseAction);
var reg:TRegistry;
begin
 reg:=TRegistry.Create;
 reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask\Dialogs\MultiForm', true);
 Reg.WriteInteger('Width', Width);
 Reg.WriteInteger('Height', Height);
 reg.CloseKey;
 reg.Free;
end;

procedure TMultiForm.BitBtn2Click(Sender: TObject);
begin
 Application.HelpContext(231);
end;


procedure TMultiForm.SpeedButton3Click(Sender: TObject);
var x: Integer;
begin
lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;
for x:=0 to lvSrc.Items.Count -1 do
 with lvDst.Items.Add do
  begin
  caption:=lvSrc.Items[x].Caption;
  ImageIndex:=0;
  end;
lvSrc.Items.Clear;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
setButtons;
btnOK.Enabled := lvDst.Items.Count > 0;
end;

procedure TMultiForm.SpeedButton4Click(Sender: TObject);
begin
if lvSrc.SelCount < 1 then
 begin
 MessageBeep(MB_OK);
 Exit;
 end;

lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;

with lvDst.Items.Add do
 begin
 Caption   :=lvSrc.Selected.Caption;
 ImageIndex:=0;
 end;
lvsrc.Selected.Delete;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
setButtons;
btnOK.Enabled := lvDst.Items.Count > 0;
end;

procedure TMultiForm.SpeedButton5Click(Sender: TObject);
begin
if lvDst.SelCount < 1 then
 begin
 MessageBeep(MB_OK);
 Exit;
 end;

lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;

with lvsrc.Items.Add do
 begin
 Caption   :=lvdst.Selected.Caption;
 ImageIndex:=0;
 end;
lvdst.Selected.Delete;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
setButtons;
btnOK.Enabled := lvDst.Items.Count > 0;
end;

procedure TMultiForm.SpeedButton6Click(Sender: TObject);
var x:Integer;
begin
lvDst.Items.BeginUpdate;
lvSrc.Items.BeginUpdate;
for x:=0 to lvDst.Items.Count -1 do
 with lvSrc.Items.Add do
  begin
  caption:=lvDst.Items[x].Caption;
  ImageIndex:=0;
  end;

lvDst.Items.Clear;
lvsrc.Items.EndUpdate;
lvDst.Items.EndUpdate;
setButtons;
btnOK.Enabled := lvDst.Items.Count > 0;
end;

procedure TMultiForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key = vk_f1 then
 BitBtn2.Click;
end;

end.
