unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, rasext,registry, ExtCtrls, ritoptions, ieoptions, ritconnection,
  connect, NotifyThread, StatsThread, RitLanguage, RXShell, ImgList, ClickDef,
  spash, AutoDial;

type
  lpDword    = ^DWORD;

  LpRasADParams = ^TRasADParams;
  TRasADParams = record
    dwSize: Longint;
    hwndOwner: THandle;
    dwFlags: Longint;
    xDlg,
    yDlg: Longint;
  end;

  pritADInfo = ^TritADInfo;
  TritADInfo = packed record
   phonebook : string[255];
   connection: string[255];
   res       : lpdword;
   params    : TRasADParams;
  end;

type
  //See end of ritconnection.pas
  TMultiInfo = Record
    DialList : TStringList;
    DialIndex: Integer;
    ConnectionIndex: Integer;
  end;
  pMultiInfo = ^TMultiInfo;

  TMainForm = class(TForm)
    RxTrayIcon: TRxTrayIcon;
    pmenu: TPopupMenu;
    MultiTimer: TTimer;
    ilTree: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure BeendenClick(Sender: TObject);
    procedure RasClick(Sender: TObject);
    procedure InfoClick(Sender: TObject);
    procedure EinstClick(Sender: TObject);
    procedure helpClick(Sender: Tobject);
    procedure RasManClick(Sender: TObject);
    procedure RxTrayIconMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MultiTimerTimer(Sender: TObject);
  private
    FNT: Boolean;
    FLoaded: Boolean;
    FLastAutoDial:dword;
    FMultiIndex: Integer;
    procedure ConnectionEvent(Sender: TObject; RitState, apiState, error: Integer);
    function  WriteString(Str: String; pos: Integer): Integer;
    procedure ConnectAllAutoDial;
    procedure WMCopyData(var m:TWmcopydata); message WM_COPYDATA;
              //used for AutoDial. The DLL notifies Rit with this message
    procedure AppExcept(Sender: TObject; E: Exception); //for catching Exceptions and display better error
    procedure RasOptions(connection: string);
procedure AutoDial(params: pRitAdInfo);
  public
    RasConnections:TList;
    MultiDials: TList;
    Options: TRitOption;
    IEOptions: TIEOptions;
    Languages: TRitLanguage;
    MsgNr: Integer;
    onlineTime:String;
    starttime: LongInt;
    connection:String;
    first:Boolean;
    NotifyThread: TRasNotifyThread;
    StatsThread : TStatsThread;

    procedure LaunchRasMon; //launches WinNT-Rasmon
    function getMultiIndex(name: String; List: TStringList): Integer;
    function StatusString(obj: TRitConnection; state: TRasConnState; error: Longint): String;
    function IndexOfConnection(connection: String):Integer; //Goes thru the list..
    property NT: boolean  read FNT; //Does the user have a NT or 9x'
    property MultiIndex: Integer read FMultiIndex write FMultiIndex;
    procedure createMenu; //Creates the PopUp-Menu
    procedure getEnt;
    function Help(Command: Word; Data: Longint;   var CallHelp: Boolean): Boolean;
    function CountActiveConnections: Integer;
    destructor  Destroy; Override;
    procedure detRasError(nr: integer; str, connection: string; showlog:boolean=true);

{
Because the form is never shown, I have to set up a destructor to free the
objects I have added to the form (finally).
}
  end;
var
  MainForm: TMainForm;
  msplf: TSplashForm; //a global variable. Please kill me, but this is the
                      //only way to get the SplashForm to update the
                      //label while creating this form. And this is necessary,
                      //since initializing the Perfmon-API in the
                      //statistics-thread consumes a ton of time.

Const
  REGKEY = '\Software\PH-Arts\RasInTask\Hints\';

implementation

uses Abou, Optionen, Module, Check, Rasman, Info;

{$R *.DFM}


procedure TmainForm.RasOptions(connection: string);
var oform: TOptionenForm;
    x:Integer;
begin
oform:=ToptionenForm.Create(Application);
for x:=0 to oform.tv.Items.Count -1 do
 if oform.tv.Items[x].Text = connection then
    oform.tv.Selected:=oform.tv.Items[x];
try
 oform.ShowModal;
finally
 oform.Free;
end;
end;

procedure TMainForm.AutoDial(params: pRitAdInfo);
var adf: TAutoDialForm;
    x: Integer;
    connection: string;
begin
connection:=params^.connection;
if TRitConnection(RasConnections[IndexOfConnection(connection)]).Active then exit;
//no waiting-time. Connect without confirmation!
if Options.CAD = 0 then
 begin
 if Options.LWC then
  ConnectAllAutoDial
 else
  TRitConnection(RasConnections[IndexOfConnection(connection)]).Connect('');
 exit;
 end
else
 begin
 adf:=TAutoDialForm.Create(self);
 adf.lvCons.Items.BeginUpdate;
  adf.lvCons.Items.Clear;
  for x:=0 to RasConnections.Count - 1 do
   begin
    with adf.lvCons.Items.Add do
     begin
     ImageIndex:=2;
     Caption:=TRitConnection(MainForm.RasConnections[x]).Name;
     Checked:=TRitConnection(MaiNForm.RasCOnnections[x]).sinAutoDial;
     if Caption = connection then
      begin
      checked:=true;
      selected:=true;
      end;
     //I must to the IF-Clause, because with checked:=(cpation = connection),
     //I would overwrite the first condition.
     end;
   end;
  adf.lvCons.Items.EndUpdate;
  if Options.UseCad then
   begin
   adf.labsec.Caption:=inttostr(options.cad);
   adf.timer.Enabled:=true;
   end
  else
   begin
   adf.paneltimeout.Visible:=false;
   adf.panelButtons.Top:=adf.panelTimeout.Top;
   adf.Height:=adf.height - adf.panelButtons.height;
   end;
  if adf.ShowModal = mrOK then
   begin
   For x:=0 to adf.lvCons.Items.Count -1 do
    begin
    if adf.lvcons.Items[x].Checked then
     TRitConnection(RasConnections[indexofconnection(adf.lvcons.items[x].caption)]).Connect('');
    end;
   end
  end;
end;

procedure TMainForm.detRasError(nr: integer; str, connection: string; showlog:boolean=true);

var info: TInfoForm;
    rerr: TRasError;
begin
info:=TInfoForm.CreateInfo(self, itDialError);
rerr.id:=nr;
rerr.text:=str;
rerr.Connection:=connection;
info.RasError:=rerr;
if not showLog then
 info.checkLog.Visible:=false;
try
 info.ShowModal;
finally
 info.Free;
end;
end;

procedure TMainForm.AppExcept(Sender: TObject; E: Exception);
var infoForm:TInfoForm;
begin
infoForm:=TInfoForm.CreateInfo(self, itError);
infoForm.ex:=e;
try
 infoForm.ShowModal;
finally
 infoForm.Free;
end;
end;

procedure TMainForm.ConnectAllAutoDial;
var x: integer;
begin
 for x:=0 to RasConnections.Count - 1 do
  if TRitConnection(RasConnections[x]).sInAutoDial then
    TRitConnection(RasConnections[x]).connect('');
end;


procedure TMainForm.WMCopyData(var m:TWmcopydata);
var connection: string;
    x:Integer;
    command: dword;
begin
connection:=TritADInfo(m.CopyDataStruct^.lpData^).connection;
command:=m.CopyDataStruct^.dwData;
//since NT calls the functin twice, I will ignore it, if
//we are already connected or if the last try was inner the
//last 20 seconds
if not FLoaded then Exit;
if flastautodial <> 0 then
 if (gettickcount - fLastAutoDial) < 20000 then exit;
FLastAutoDial:=gettickcount;
case command of
 1: AutoDial(pRitADInfo(m.CopyDataStruct^.lpData));
 2: rasoptions(connection);
 3: begin
    x:= indexofconnection(connection);
    if x <> -1 then
     TRitConnection(RasCOnnections[x]).Connect('');
    end;
end;
end;



procedure TMainFOrm.LaunchRasMon;
var sysdir: Array[0..MAX_PATH] of Char;
begin
    GetSystemDirectory(sysdir, 255);
    WinExec(PChar(sysdir+'\rasmon.exe'), SW_SHOW);
end;

function TMainForm.getMultiIndex(name: String; List: TStringList): Integer;
var x:Integer;
begin
 Result:=MultiDials.Add( new(pMultiInfo) );
 pMultiInfo(MultiDials[Result])^.DialList:= TStringList.Create;
 pMultiInfo(MultiDials[Result])^.DialList.Assign(List);
 pMultiInfo(MultiDials[Result])^.DialIndex:=0;
 pMultiInfo(MultiDials[Result])^.ConnectionIndex:=IndexOfConnection(name);
{
 If the User wants the settings of the connection that failed to be used
 in the connection in witch MultiDial succedes, we have to assign the Index
 of the Source-Connection to the new connection
}
 if ((TRitConnection(RasConnections[IndexOfConnection(name)]).MultiDial.UseProgs) OR
    (TRitConnection(RasConnections[IndexOfConnection(name)]).MultiDial.UseProgs)) then
  begin
   for x:=0 to List.Count - 1 do
    TRitConnection(RasConnections[IndexOfConnection(List[x])]).MultiDial.SourceIndex:=pMultiInfo(MultiDials[Result])^.ConnectionIndex;
  end;
 FMultiIndex:=Result;
 MultiTimer.Enabled:=True;
end;

procedure TMainForm.RasManClick(Sender: TObject);
begin
 RasmanForm.Show;
end;

function TMainForm.WriteString(str: String; pos: Integer): Integer;
//var fil: TextFile;
begin
// Result:=-1;
 Application.ProcessMessages;
// AssignFile(fil, 'c:\rittest.dat');
// Append(fil);
// writeln(fil, str);
// CloseFile(fil);
 if pos = -1 then
  Result:=ConnectForm.ListBox.Items.Add(str)
 else
  begin
  ConnectForm.ListBox.Items[pos]:=str;
  Result:=pos;
  end;
 SendMessage(ConnectForm.ListBox.Handle, WM_Vscroll, SB_BOTTOM, 0);
end;

destructor TMainForm.Destroy;
var i: Integer;
begin
 For i:=RasConnections.Count -1 downto 0 do
  TRitConnection(RasConnections[i]).Free;
 for i:=MultiDials.Count - 1 downto 0 do
    begin
    pMultiInfo(MultiDials[MultiDials.Count - 1])^.DialList.Free;
    FreeMem(pMultiInfo(MultiDials[MultiDials.Count -1]));
    end;
 MultiDials.Free;
 MultiDials:=nil;
 RasConnections.Clear;
 RasConnections.Free;
 RasConnections:=nil;
if Assigned(NotifyThread) then
  begin
  NotifyThread.Terminate;
  NotifyThread:=nil;
  end;
 StatsThread.Terminate;
 StatsThread:=nil;
 IEOptions.Free;
 IEOptions:=nil;
 Options.Free;
 Options:=nil;
 Languages.Free;
 Languages:=nil;
 sleep(200);
inherited destroy;
end;

function TMainForm.StatusString(obj: TRitCOnnection; state: TRasConnState; error: Longint): String;
  var
    c: Array[0..100] of Char;
    s: String;
  begin
  if error <> 0 then
    begin
    RasGetErrorString(error, c, 100);
    Result := MainForm.Languages.getString(53, MainForm.Options.Language)+c+' ['+IntToStr(error)+']';
    end
  else
    begin
    s := '';
    case State of
      RASCS_OpenPort:
        s := MainForm.Languages.getString(54, MainForm.Options.Language);
      RASCS_PortOpened:
        s := MainForm.Languages.getString(55, MainForm.Options.Language);
      RASCS_ConnectDevice:
        s := Format(MainForm.Languages.getString(56, MainForm.Options.Language),[obj.DeviceName]);
      RASCS_DeviceConnected:
        s := Format(MainForm.Languages.getString(57, MainForm.Options.Language),[obj.DeviceType]);
      RASCS_AllDevicesConnected:
        s := MainForm.Languages.getString(58, MainForm.Options.Language);
      RASCS_Authenticate:
        s := MainForm.Languages.getString(59, MainForm.Options.Language);
      RASCS_AuthNotify:
        s := MainForm.Languages.getString(60, MainForm.Options.Language);
      RASCS_AuthRetry:
        s := MainForm.Languages.getString(61, MainForm.Options.Language);
      RASCS_AuthCallback:
        s := MainForm.Languages.getString(62, MainForm.Options.Language);
      RASCS_AuthChangePassword:
        s := MainForm.Languages.getString(63, MainForm.Options.Language);
      RASCS_AuthProject:
        s := MainForm.Languages.getString(64, MainForm.Options.Language);
      RASCS_AuthLinkSpeed:
        s := MainForm.Languages.getString(65, MainForm.Options.Language);
      RASCS_AuthAck:
        s := MainForm.Languages.getString(66, MainForm.Options.Language);
      RASCS_ReAuthenticate:
        s := MainForm.Languages.getString(67, MainForm.Options.Language);
      RASCS_Authenticated:
        s := MainForm.Languages.getString(68, MainForm.Options.Language);
      RASCS_PrepareForCallback:
        s := MainForm.Languages.getString(69, MainForm.Options.Language);
      RASCS_WaitForModemReset:
        s := MainForm.Languages.getString(70, MainForm.Options.Language);
      RASCS_WaitForCallback:
        s := MainForm.Languages.getString(71, MainForm.Options.Language);
      RASCS_Projected:
        s := MainForm.Languages.getString(72, MainForm.Options.Language);
      RASCS_StartAuthentication:
        s := MainForm.Languages.getString(73, MainForm.Options.Language);
      RASCS_CallbackComplete:
        s := MainForm.Languages.getString(74, MainForm.Options.Language);
      RASCS_LogonNetwork:
        s := MainForm.Languages.getString(75, MainForm.Options.Language);

      RASCS_Interactive:
        s := MainForm.Languages.getString(76, MainForm.Options.Language);
      RASCS_RetryAuthentication:
        s := MainForm.Languages.getString(77, MainForm.Options.Language);
      RASCS_CallbackSetByCaller:
        s := MainForm.Languages.getString(78, MainForm.Options.Language);
      RASCS_PasswordExpired:
        s := MainForm.Languages.getString(79, MainForm.Options.Language);

      RASCS_Connected:
        s := MainForm.Languages.getString(80, MainForm.Options.Language);
      RASCS_Disconnected:
        s := MainForm.Languages.getString(81, MainForm.Options.Language);
      end;
    Result := s;
    end;
  end;


procedure TMainForm.ConnectionEvent(Sender: TObject; RitState, apiState, error: Integer);
var tim: TDateTime;
    err: Array[0..99] of Char;
    x: Integer;
const lnr: Integer = -1;
begin

 if Options.ConnectWindow then
  begin
//   TCPModule.Cf.Show;
   if RitState=2 then
    ConnectForm.Label2.Caption:=(Sender AS TRitConnection).Name;
   Case RitState of
     999: if lnr = -1 then
           lnr := writeString(Format(MainForm.Languages.getString(90, Options.Language), [apiState]), lnr) //Special-Event Countdown to redial
          else
           writeString(Format(MainForm.Languages.getString(90, Options.Language), [apiState]), lnr);
     888: begin
          if Options.Logging then
           RasManForm.CreateLogEntry(leError, Format(Languages.getString(305, Options.Language),[(Sender AS TRitConnection).Name]));
          writeString(Format(MainForm.Languages.getString(85, Options.Language), [apiState, error]), -1); lnr:=-1;
          end;//Special: Redial x/y
     777: begin
          RasGetErrorString(error, err, 100); //Get the Original Windows-Error-string
          if Options.Logging then
           RasManForm.CreateLogEntry(leError, Format(languages.getString(304, Options.language),[(Sender AS TRitConnection).Name, inttostr(error)]));

          if Options.DetDlg then
           detRasError(error, err, (Sender AS TRitConnection).Name)
          else
          MessageBox(Application.Handle,PChar(Format(MainForm.Languages.getString(83, Options.Language), [intToStr(error), err])),
                     PChar(MainForm.Languages.getString(101, Options.Language)), mb_ok+mb_iconstop+MB_SETFOREGROUND);
//          ConnectForm.ListBox.Clear;
          connectForm.DoNotAsk:=true;
          ConnectForm.Close;
          connectForm.DoNotAsk:=false;
          end;
     666: begin
          RasGetErrorString(error, err, 100); //Get the Original Windows-Error-String
          MessageBox(Application.Handle,PChar(Format(MainForm.Languages.getString(88, Options.Language), [intToStr(error), err])),
                     PChar(MainForm.Languages.getString(101, Options.Language)), mb_ok+mb_iconstop+MB_SETFOREGROUND);
          connectForm.DoNotAsk:=true;
          ConnectForm.Close;
          connectForm.DoNotAsk:=false;
          end;
     333: begin //The Connections wants this procedure to proceed in MultiDial
          for x:=0 to MultiDials.Count - 1 do
           begin
            if pMultiInfo(MultiDials[x])^.ConnectionIndex = IndexOfConnection(TRitConnection(Sender).Name) then
             begin
              writeString(Format(MainForm.Languages.getString(229, Options.Language), [pMultiInfo(MultiDials[x])^.DialList[pMultiInfo(MultiDials[x])^.DialIndex]]), -1);
              FMultiIndex:=x;
              MultiTimer.Enabled:=True;
             end;
            end;
          end;
     222: begin
          writeString(MainForm.Languages.getString(228, Options.Language), -1);
          end;
    else  begin
          if (apiState = RASCS_Connected) then
           begin
            if Options.Logging then
             RasManForm.CreateLogEntry(leInfo, Format(languages.getString(306, Options.language),[(Sender AS TRitConnection).Name]));
            writeString(MainForm.Languages.getString(80, Options.Language), -1);
            writeString(MainForm.Languages.getString(89, Options.Language), -1);
            lnr:=-1;
            createMenu;
            tim:=Time;
//          Cleanup!
{ The following code will remove an Item
  from the MultiDials-List. I go down in the
  for-loop, because I am deleting Items from the list
}
            for x:=MultiDials.Count - 1 downto 0 do
             begin
              if pMultiInfo(MultiDials[x])^.ConnectionIndex = IndexOfConnection(TRitConnection(Sender).Name) then
               begin
               TRitConnection(sender).MultiDial.ListIndex:=-1; //this is also done in Ritconnection.pas, but I will get big GPF's
               pMultiInfo(MultiDials[x])^.DialList.Free;       //if not set to -1, so I do it twice!
               freeMem(MultiDials[x]);
               MultiDials.Delete(x);
               end;
             end;
{ Now we have to tell the other connections in the
  MultiList, that their Indexes in the list have changed.

  If we do not, we will get an Access Violation or a
  ListIndex out of Bounds (not checked) as soon as
  the object tries to access MultiDials[FMultiDial.ListIndex]
}
            for x:=MultiDials.Count - 1 downto 0 do
             TRitConnection(RasConnections[pMultiInfo(MultiDials[x])^.ConnectionIndex]).MultiDial.ListIndex:=x;
//           End cleanup!
            repeat //wait 1 second.
             Application.ProcessMessages;
            Until Time - Tim >1/24/3600;
            connectForm.DoNotAsk:=true;
            ConnectForm.Close;
            connectForm.DoNotAsk:=false;
           end
          else
           if ((error <> ERROR_USER_DISCONNECTION) AND (ritstate = 2)) then
           begin
            lnr:=-1;
            writeString(StatusString(TRitConnection(Sender), apistate, error), -1);
            if error <> 0 then
             if Options.Logging then
              RasManForm.CreateLogEntry(leError, Format(languages.getString(319, Options.language),[(Sender AS TRitConnection).Name, inttostr(error)]));

           end
          end; //Case else
   end; //Case
  end //If Options.ConnectWindow;
 else //No COnnection Window
  begin
  Case RitState of //Althought the user does not want to have the connection-window, we sould
     777: begin    //let him know when something went REALLY wrong!
          RasGetErrorString(error, err, 100); //Get the Original Windows-Error-String
          if Options.Logging then
           RasManForm.CreateLogEntry(leError, Format(languages.getString(304, Options.language),[(Sender AS TRitConnection).Name, inttostr(error)]));

          MessageBox(Application.Handle,PChar(Format(MainForm.Languages.getString(83, Options.Language), [intToStr(error), err])),
                     PChar(TRitConnection(Sender).Name), mb_ok+mb_iconstop+MB_SETFOREGROUND);
          ConnectForm.Close;
          End;
     666: begin
          RasGetErrorString(error, err, 100); //Get the Original Windows-Error-String
          MessageBox(Application.Handle,PChar(Format(MainForm.Languages.getString(88, Options.Language), [intToStr(error), err])),
                     PChar(TRitConnection(Sender).Name), mb_ok+mb_iconstop+MB_SETFOREGROUND);
          ConnectForm.Close;
          end;
   else
      if (apiState = RASCS_Connected) then
        if Options.Logging then
           RasManForm.CreateLogEntry(leInfo, Format(languages.getString(306, Options.language),[(Sender AS TRitConnection).Name]))

      else if ((error <> ERROR_USER_DISCONNECTION) AND (ritstate = 2)) then
           begin
            if Options.Logging then
             RasManForm.CreateLogEntry(leError, Format(languages.getString(319, Options.language),[(Sender AS TRitConnection).Name, inttostr(error)]));
           end
  end;
  end; //Else of ConnectionWindow
end;

function TMainForm.Help(Command: Word; Data: Longint;   var CallHelp: Boolean): Boolean;
begin
Result:=True;
CallHelp:=true;
sleep(100);
if Assigned(MainForm.Languages) then
 if Assigned(MainForm.Options) then
 begin
 Application.HelpFile:=ExtractFilePath(Application.ExeName)+MainForm.Languages.getString(356, MainForm.Options.Language);
 if not FileExists(Application.HelpFile) then
   begin
   CallHelp:=False;
   Result:=True;
   end
end
else
 CallHelp:=False;
end;

function TMainForm.IndexOfCOnnection(connection: String):Integer;
var i:Integer;
begin
Result:=-1;
For i:=0 to RasConnections.Count-1 do
 if TRitConnection(RasConnections.Items[i]).Name = connection then
  Result:=i;
end;

procedure TMainForm.helpClick(Sender: Tobject);
begin
 Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.createMenu;
 var x, y:Integer;
begin
if pmenu.Items.Count > 1 then
 begin
 for x:=0 to pmenu.Items.Count-1 do
  begin
  pmenu.Items.Delete(0);
  end;
 end;
Case Options.PopUpType of
0: begin
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(213, Options.Language), 0, false, true, nil, 0, 'Trennen'));
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(214, Options.Language), 0, false, true, nil, 0, 'Waelen'));
   pmenu.Items.Add(NewLine);//+++++++++++++++++++++++++++++++++++ ->Get Names from Stringtable
   pmenu.Items.Add(NewItem('?',0,false,true,nil,0,'HSelect'));
   pmenu.Items.Add(NewItem('&RasMan...',0,false,true,RasmanClick,0,'Rasman'));
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(1, Options.Language),0,false,true,EinstClick,0,'Einstellungen'));
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(3, Options.Language),0,false,true,BeendenClick,0,'Beenden'));
   pmenu.Items.Items[3].Add(NewItem(MainForm.Languages.getString(2, Options.Language),0,false,true,InfoClick,0,'Info'));
   pmenu.Items.Items[3].Add(NewItem(MainForm.Languages.getString(40, Options.Language),0,false,true,HelpClick,0,'Help'));
   for x:=0 to RasConnections.count-1 do
    begin
    if TRitCOnnection(RasConnections[x]).Active then
     pmenu.Items.Items[1].Add((NewItem(TRitConnection(MainForm.RasConnections.Items[x]).Name,0,false,true,RasClick,0,'RasPt'+IntToStr(x))))
    else
     pmenu.Items.Items[0].Add((NewItem(TRitConnection(MainForm.RasConnections.Items[x]).Name,0,false,true,RasClick,0,'RasPt'+IntToStr(x))));
    end;
   //disable the entry "connect" or "disconnect", if empty
   if pmenu.Items.Items[0].Count = 0 then
    pmenu.Items.Items[0].Enabled:=False
   else
    pmenu.Items.Items[0].Enabled:=True;
   if pmenu.Items.Items[1].Count = 0 then
    pmenu.Items.Items[1].Enabled:=False
   else
    pmenu.Items.Items[1].Enabled:=True;
   //now search the submenus and add the images (D4 only)
   for x:=0 to pmenu.Items.Count -1 do
    for y:=0 to pmenu.Items[x].Count -1 do
      begin
      if pmenu.Items[x].Items[y].Name = 'Info' then
       pmenu.Items[x].Items[y].ImageIndex:=6
      else if pmenu.Items[x].Items[y].Name = 'Help' then
       pmenu.Items[x].Items[y].ImageIndex:=7
      else
       pmenu.Items[x].Items[y].ImageIndex:=2
      end;
   end;
1: begin
   for x:=0 to RasConnections.count-1 do
    begin
    if TRitCOnnection(RasConnections[x]).Active then
     pmenu.Items.Add((NewItem(TRitConnection(MainForm.RasConnections.Items[x]).Name,0,true,true,RasClick,0,'RasPt'+IntToStr(x))))
    else
     pmenu.Items.Add((NewItem(TRitConnection(MainForm.RasConnections.Items[x]).Name,0,false,true,RasClick,0,'RasPt'+IntToStr(x))));
    end;
   pmenu.Items.Add(NewLine);//+++++++++++++++++++++++++++++++++++ ->Get Names from Stringtable
   pmenu.Items.Add(NewItem('&RasMan...',0,false,true,RasmanClick,0,'Rasman'));
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(1, Options.Language),0,false,true,EinstClick,0,'Einstellungen'));
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(2, Options.Language),0,false,true,InfoClick,0,'Info'));
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(40, Options.Language),0,false,true,HelpClick,0,'Help'));
   pmenu.Items.Add(NewItem(MainForm.Languages.getString(3, Options.Language),0,false,true,BeendenClick,0,'Beenden'));
   end;
end; //-->Case;
for x:=0 to pmenu.Items.Count - 1 do
 begin
 if pMenu.Items[x].Name = 'Einstellungen' then //hard coded since the name is it also (see above)
   pmenu.Items[x].ImageIndex:=3
 else if pmenu.items[x].Name = 'Info' then
   pmenu.items[x].ImageIndex:=6
 else if pmenu.items[x].Name = 'Help' then
   pmenu.items[x].ImageIndex:=7
 else if pmenu.items[x].Name = 'HSelect' then
   pmenu.items[x].ImageIndex:=7
 else if (pMenu.Items[x].Name = 'Trennen') OR (pMenu.Items[x].Name = 'Waelen') then //hard coded since the name is it also (see above)
   begin
    if pmenu.Items[x].Enabled then
     pmenu.Items[x].ImageIndex:=1
    else
     pmenu.Items[x].ImageIndex:=-1;
   end
 else
   if pos('RasPt', pmenu.Items[x].Name) <> 0 then
     pmenu.Items[x].ImageIndex:=2;
 end; //for...
RxTrayIcon.Hint:='RasInTask ('+inttostr(countActiveConnections)+')'; //Set the state of the StatsThread...
if Options.DetDlg then
 Application.OnException:=AppExcept
else
 Application.OnException:=nil;
end;

procedure TMainForm.GetEnt;
//Type PRitConnection = ^TRitCOnnection
var
  RASEntries: array[1..25] of TRasEntryName;
  BufferSize: Integer;
  EntryCount: Integer;
  rc:         longint;
  Entry:      integer;
//  ritco    : PRitCOnnection;
begin
for entry:=0 to RasConnections.Count - 1 do
 TRitConnection(RasCOnnections[entry]).Free;
RasConnections.Clear;
RASEntries[1].dwSize := SizeOf(TRasEntryName);
BufferSize := SizeOf(RASEntries);
if Assigned(msplf) then
  msplf.PutString('Counting installed connections...');
rc := RASEnumEntries(nil, nil, @RASEntries, BufferSize, EntryCount);
 If rc = 0 then begin
   for Entry := 1 to EntryCount do
   begin
     if Assigned(msplf) then
        begin
        msplf.progBar.Max:=msplf.progBar.Max+1;
        msplf.PutString(Format('Reading ''%s'' ...',[RASEntries[Entry].szEntryName]));
        end;
     RasConnections.Add(TRitConnection.Create(RASEntries[Entry].szEntryName, false));
     TRitConnection(RasConnections[RasConnections.Count -1]).OnStateChange := ConnectionEvent;
   end;
 end;
floaded:=true;
end;

{
  If you ask you what the second assignement in the for-statement at the top means,
  here the explanation:

  The TRitConnection-Object is event-driven: It fires the OnStateChange Event,
  everytime something happens to the Object. The strange line assigns
  the TMainForm.ConnectionEvent procedure to EVERY TRitConnection-Event that
  is created.

  Now I have access to all the Events with the ConnectionEvent-procedure!

  If you wish to see tricks that are REALLY funny and strange, look at the
  ritconnection-Unit....
}


procedure TMainForm.EinstClick(Sender: TObject);
var  OptionenForm: TOptionenForm;
begin
 Screen.Cursor := crHourglass;
 OptionenForm:=TOptionenForm.Create(Application);
 try
  OptionenForm.ShowModal;
 finally
  OptionenForm.Free;
 end;
 createMenu;
end;

procedure TMainForm.InfoClick(Sender: TObject);
 var abox:TAboutBox;
begin
 abox:=TAboutBox.Create(self);
 try
  abox.ShowModal;
 finally
  abox.free;
 end;
end;

procedure TMainForm.RasClick(Sender: TObject);
begin
  connection:=(Sender as TMenuItem).Caption;
  if TRitConnection(RasConnections[IndexOfConnection(connection)]).Active then
   TRitConnection(RasConnections[IndexOfConnection(connection)]).HangUp
  else
   TRitConnection(RasConnections[IndexOfConnection(connection)]).Connect('');

createMenu;
if RasManForm.Visible then
 RasManForm.rebuildConnectionCombo;
end;


procedure TMainForm.FormCreate(Sender: TObject);
begin
 fLoaded:=false;
 if Assigned(msplf) then
  msplf.PutString('Prepearing hidden IE-Options...');
 IEOptions   :=TIEOptions.Create;
 if Assigned(msplf) then
  msplf.PutString('Reading Settings...');
 Options     :=TRitOption.Create;
 if Assigned(msplf) then
  msplf.PutString('Initializeing notification-thread...');
 NotifyThread:=TRasNotifyThread.Create(false);
 if Assigned(msplf) then
  msplf.PutString('Initializing statistics-thread...');
 StatsThread :=TStatsThread.Create(false);
 if Assigned(msplf) then
  msplf.PutString('Loading strings...');
 Languages   :=TRitLanguage.Create(ExtractFilePath(Application.ExeName));
 if Assigned(msplf) then
  msplf.PutString('Setting up Strings...');
 MainForm.Languages.AutoChange(Options.Language);
 FNT := (Win32Platform = VER_PLATFORM_WIN32_NT); //Declared in SysUTIlS. Documented.
 if fnt then
  if Win32MajorVersion < 4 then //Also declared in SysUtils !!Not documented!! (Borland distributes Delphi with the Sources...)
    begin
    MessageBox(Handle,PChar(MainForm.Languages.getString(163, Options.Language)),'Error!',mb_Ok or mb_IconStop);
    Application.Terminate;
    end;
 first:=True;
 Application.OnHelp:=Help;
 Width:=0;
 Height:=0;
 Hide;
 if Assigned(msplf) then
  msplf.PutString('Creating Connections-List...');
 RasConnections:=TList.Create;
 MultiDials    :=Tlist.Create; //See getMultiIndex for more!
 if Options.Language = 1000 then //Compatibility with older versions
  Options.Language := Languages.AvailableLanguages.IndexOf('English');
 if Assigned(msplf) then
  msplf.PutString('Reading connection-data...');
 getEnt;
end;

procedure TMainForm.BeendenClick(Sender: TObject);
var i: Integer;
begin
 if CountActiveConnections > 0 then
  if MessageBox(self.Handle,
                PChar(MainForm.Languages.getString(215, Options.Language)),
                PChar(MainForm.Languages.getString(109, Options.Language)),
                mb_yesno or mb_iconquestion) = idYes then
   For i:= 0 to RasConnections.Count - 1 do
    TRitConnection(RasConnections[i]).HangUp;
 NotifyThread.Terminate;
 Application.Terminate;
end;

function TMainForm.CountActiveConnections: Integer;
var i: Integer;
begin
 Result:=0;
 for i:=0 to RasConnections.Count - 1 do
  if TRitConnection(RasConnections[i]).Active then inc(Result);
 if Result > 0 then   //Stop / restart the thread.
  StatsThread.Resume  //it has the Priority tpLower (set in TStatsThread.Create)
 else
 StatsThread.Suspend;
end;

procedure TMainForm.RxTrayIconMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
procedure DisconnectWithConf(Connection: string);
var obj: TRitConnection;
begin
 obj:= TRitConnection(RasConnections[IndexOfConnection(connection)]);
 if obj.Active then
  begin
  if MessageBox(Application.Handle,
                PChar(Format(MainForm.Languages.getString(120, Options.Language), [Connection])),
                Pchar(MainForm.Languages.getString(109, Options.Language)),
                mb_iconquestion or mb_yesno) = idyes then
    obj.HangUp;
  end
 else
  obj.Connect('');
end;

begin
 if Button <> mbLeft then Exit; //New added for the update to rxtls 2.40
 if (not (ssShift in Shift)) then
  begin
  if CountActiveConnections = 0 then
   Case Options.Scklick of
    1: TRitConnection(RasConnections[IndexOfConnection(Options.Connectsk)]).Connect('');
    2: einstClick(sender);
    3: pmenu.Popup(x, y);
   end
  else //CountActiveConnections
   if Options.RasMan = rcSingle then
    RasManClick(Sender)
   else begin
    Case Options.Scklick of
     1: DisconnectWithConf(Options.Connectsk);
     2: einstClick(sender);
     3: pmenu.Popup(x, y);
    end
   end; //if
  end //begin at if not sshift in shift
 else
  begin
  if CountActiveConnections = 0 then
   Case Options.DClick of
    1: TRitConnection(RasConnections[IndexOfConnection(Options.Connectdk)]).Connect('');
    2: einstClick(sender);
    3: pmenu.Popup(x, y);
   end
  else
   if Options.RasMan = rcShift then
    RasManClick(Sender)
   else begin
     Case Options.DClick of
     1: DisconnectWithConf(Options.Connectdk);
     2: einstClick(sender);
     3: pmenu.Popup(x, y);
     end
   end; //else
  end;
end;


procedure TMainForm.MultiTimerTimer(Sender: TObject);
begin
MultiTimer.Enabled:=False;
// After the next two lines, there is one that is a bit long. The next two lines may help you
// to understand it...

// cname:=IndexOfConnection(pMultiInfo(MultiDials[FMultiIndex])^.DialList[pMultiInfo(MultiDials[FMultiIndex])^.DialIndex]);
// cname2:=TRitConnection(RasConnections[pMultiInfo(MultiDials[FMultiIndex])^.ConnectionIndex]).Name ;
TRitConnection(RasConnections[IndexOfConnection(pMultiInfo(MultiDials[FMultiIndex])^.DialList[pMultiInfo(MultiDials[FMultiIndex])^.DialIndex])]).Connect('');
inc(pMultiInfo(MultiDials[FMultiIndex])^.DialIndex);
if pMultiInfo(MultiDials[FMultiIndex])^.DialIndex > pMultiInfo(MultiDials[FMultiIndex])^.DialList.Count -1 then
 pMultiInfo(MultiDials[FMultiIndex])^.DialIndex:=0;
MultiIndex:=-1;
end;

end.
