unit Info;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, sGlyphsList, StdCtrls, ComCtrls, sCtrls, sTrans, sMemo, Buttons,
  Registry;

type
  tInfoType = (itError, itHint, itInformation, itImportantInfo, itDialError);
  traserror = record
            id: integer;
            Text: string[255];
            Connection: string[255];
  end;
  TInfoForm = class(TForm)
    gl: TsGlyphList;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    Panel1: TPanel;
    sSpeedButton1: TsSpeedButton;
    Bevel1: TBevel;
    checkLog: TsCheckBox;
    sStatusBar1: TsStatusBar;
    Timer: TTimer;
    Panel2: TPanel;
    Notebook1: TNotebook;
    Label2: TLabel;
    labEtype: TLabel;
    Label3: TLabel;
    labsubtype: TLabel;
    Label5: TLabel;
    Memo1: TsMemo;
    Image3: TImage;
    labdid: TLabel;
    labhint: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    labHeader: TLabel;
    labinfotext: TLabel;
    procedure TimerTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure sSpeedButton1Click(Sender: TObject);
  private
    FInfoType: TInfoType;
    FEx      : exception;
    FErc     : Integer;
    FText: string;
    FDidy: string;
    FRasError: TRasError;
    procedure CreateGradientBitmap(StartPos: Integer; var GBitmap: TBitmap);
    procedure SetupForm;
    procedure SetInfoType(new: TInfoType);
    procedure SetEx(new: Exception);
    procedure SetErc(new: Integer);
    procedure SetText(new: string);
    procedure SetDidy(new: string);
    procedure SetRasError(new: TRasError);
    procedure setRasTip(nr: Integer); //error-code in -> tip out
    { Private-Deklarationen }
  public
    regkey:string;

    constructor CreateInfo(AOwner: TComponent; InfoType: tInfoType);
    constructor Create(AOwner: TCOmponent);override;
    property InfoType: TInfoType  read FInfoType write SetInfoType;
    property ex      : Exception read Fex        write Setex;
    property Erc     : Integer    read FErc      write Seterc;
    property text    : String     read FText     write SetText;
    property didy    : String     read Fdidy     write Setdidy;
    property RasError: TRasError  read FRasError write SetRasError;
    { Public-Deklarationen }
  end;

var
  InfoForm: TInfoForm;

const
 GLID_Info = 1;
 GLID_Rit  = 2;
 GLID_Excl = 3;
 GLID_Stop = 4;

procedure ShowHintW(key, header, text, checktext,  title:String);

implementation

uses Main, RitLanguage, Rasext, Rasman;

{$R *.DFM}

function GetToken(aString, SepChar: String; TokenNum: Integer):String;
var
   Token     : String;
   StrLen    : Integer;
   TNum      : Integer;
   TEnd      : Integer;

begin
     StrLen := Length(aString);
     TNum   := 1;
     TEnd   := StrLen;
     while ((TNum <= TokenNum) and (TEnd <> 0)) do
     begin
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               Token := Copy(aString,1,TEnd-1);
               Delete(aString,1,TEnd);
               Inc(TNum);
          end
          else
          begin
               Token := aString;
          end;
     end;
     if TNum >= TokenNum then
     begin
          GetToken := Token;
     end
     else
     begin
          GetToken := '';
     end;
end;

function NumToken(aString, SepChar: String):integer;
var
   RChar     : Char;
   StrLen    : integer;
   TNum      : integer;
   TEnd      : integer;

begin
     if SepChar = '#' then
     begin
          RChar := '*'
     end
     else
     begin
         RChar := '#'
     end;
     StrLen := Length(aString);
     TNum   := 0;
     TEnd   := StrLen;
     while TEnd <> 0 do
     begin
          Inc(TNum);
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               aString[TEnd] := RChar;
          end;
     end;
     NumToken := TNum;
end;

procedure ShowHintW(key, header, text, checktext,  title:String);
var Reg  :TRegistry;
    keys :TStringList;
    x, nr:Integer;
    show :Boolean;
    hintf:TInfoForm;
begin
nr:=-1;
hintf:=TInfoForm.Create(Application);
hintf.didy:=header;
hintf.Text:=Text;
hintf.InfoType:=itHint;
hintf.regkey:=key;
hintf.hint:=text;
show:=True;
keys:=TStringList.Create;
Reg:=TRegistry.Create;
Reg.RootKey:=HKEY_CURRENT_USER;
Reg.OpenKey(key, true);
Reg.GetValueNames(keys);
if keys.Count > 0 then
begin
for x:=0 to (keys.Count-1) do
 begin
 if text = keys[x] then
   show:=Reg.ReadBool(text);
 end;
end
else
show:=True;

Reg.CloseKey;

If show then
 begin
 hintf.Caption:=title;

 try
  nr:=StrToInt(text);
  text:=MainForm.Languages.getString(nr, MainForm.Options.Language);
 except
  //Do nothing
 end;

// hintf.Memo1.Lines.Clear;
// nr:=NumToken(text, #10);

// for x:=1 to nr do
//   hintf.Memo1.Lines.Add(GetToken(text, #10, x));
 hintf.Text:=Text;
 hintf.checkLog.Caption:=checktext;
///ntf.Label1.Caption:=Header;
 hintf.checkLog.Checked:=not show;
 if hintf.ShowModal = mrOK then
  begin
  Reg.OpenKey(regkey, true);
  if nr <> -1 then
    Reg.WriteBool(inttostr(nr), false)
  else
    Reg.WriteBool(text, false);
 end;
end;
Reg.Free;
keys.Free;
hintf.Free;
end;


procedure TinfoForm.SetInfoType(new: TInfoType);
begin
 FInfoType:=new;
 SetupForm;
end;

procedure TinfoForm.SetEx(new: Exception);
begin
 Fex:=new;
 SetupForm;
end;

procedure TinfoForm.SetErc(new: Integer);
begin
 FErc:=new;
 SetupForm;
end;

procedure TinfoForm.SetText(new: string);
begin
 ftext:=new;
 SetupForm;
end;

procedure TinfoForm.SetDidy(new: string);
begin
 fdidy:=new;
 SetupForm;
end;

procedure TinfoForm.SetRasError(new: TRasError);
begin
 fraserror.id:=new.id;
 fraserror.Text:=new.Text;
 SetupForm;
end;

procedure TInfoForm.CreateGradientBitmap(StartPos: Integer; var GBitmap: TBitmap);
var
  I, Steps, iColorDepth: Integer;
  Bitmap: TBitmap;
  R, G, B, OldR, OldG, OldB: Real;
  StartC, EndC, OldC: TColor;
  dcd: HDC;
begin
  DCd := GetDC(GetDesktopWindow);
  iColorDepth := GetDeviceCaps(DCd, BITSPIXEL) * GetDeviceCaps(DCd, PLANES);
  Bitmap := TBitmap.Create;
  Bitmap.Width := GBitmap.Width;
  Bitmap.Height := GBitmap.Height;
  Bitmap.Canvas.Brush.Color := clBtnShadow;
  Bitmap.Canvas.FillRect(Rect(0, 0, Bitmap.Width, Bitmap.Height));
  if iColorDepth > 8 then begin
    Steps := Bitmap.Width - StartPos;
    StartC := ColorToRGB(clBtnShadow);
    EndC := ColorToRGB(clBtnFace);
    R := (GetRValue(EndC) - GetRValue(StartC)) / Steps;
    G := (GetGValue(EndC) - GetGValue(StartC)) / Steps;
    B := (GetBValue(EndC) - GetBValue(StartC)) / Steps;
    OldC := StartC;
    OldR := GetRValue(StartC);
    OldG := GetGValue(StartC);
    OldB := GetBValue(StartC);
    for I := 0 to Steps-1 do begin
      Bitmap.Canvas.Pen.Color := OldC;
      Bitmap.Canvas.Rectangle(I+StartPos, 0, I+StartPos+1, Bitmap.Height);
      OldR := OldR + R;
      OldG := OldG + G;
      OldB := OldB + B;
      if (OldR < 0) or (OldR > 255) then OldR := GetRValue(EndC);
      if (OldG < 0) or (OldG > 255) then OldG := GetGValue(EndC);
      if (OldB < 0) or (OldB > 255) then OldB := GetBValue(EndC);
      OldC := RGB(Round(OldR), Round(OldG), Round(OldB));
    end;
  end;
  GBitmap.Assign(Bitmap);
  Bitmap.Free;
end;

procedure TInfoFOrm.SetupForm;
begin
 Case fInfoType of
  itHint:  begin
           Label1.Caption:=MainForm.Languages.getString(282, MainForm.Options.Language);
           Image1.Picture.Graphic:=gl.Glyph[GLID_Info];
           Notebook1.PageIndex:=1;
           labdid.Caption:=FDidy;
           labhint.Caption:=Ftext;
           notebook1.Color:=$00E1FFFF;
           CheckLog.Visible:=true;
           end;
  itError: begin
           Label1.Caption:=MainForm.Languages.getString(281, MainForm.Options.Language);
           Caption:=Label1.Caption;
           image1.Picture.Graphic:=gl.Glyph[GLID_Stop];
           NoteBook1.PageIndex:=0;
           labetype.Caption:='Exception';
           labsubtype.Caption:=Fex.ClassName;
           memo1.Text:=fex.Message;
           notebook1.Color:=$00D2D2FF;
           CheckLog.Caption:=MainForm.Languages.getString(302, MaiNForm.Options.Language);
           CheckLog.Checked:=false;
           CheckLog.Visible:=false;
{           label3.Left:=labEtype.Left+labetype.Width+10;
           labsubtype.Left:=labEtype.Left+labetype.Width+label3.Canvas.TextWidth(' ');
           }end;
itInformation:begin
              Label1.Caption:=MainForm.Languages.getString(283, MainForm.Options.Language);
              image1.Picture.Graphic:=gl.Glyph[GLID_Info];
              NoteBook1.PageIndex:=2;
              labheader.Caption:=fdidy;
              labinfotext.Caption:=ftext;
              notebook1.Color:=$00FFDAD1;
              CheckLog.Checked:=false;
              CheckLog.Visible:=false;
              end;
itImportantInfo: begin
                 Label1.Caption:=MainForm.Languages.getString(284, MainForm.Options.Language);
                 image1.Picture.Graphic:=gl.Glyph[GLID_Excl];
                 NoteBook1.PageIndex:=2;
                 labheader.Caption:=fdidy;
                 labinfotext.Caption:=ftext;
                 notebook1.Color:=$00FFDAD1;
                 CheckLog.Checked:=false;
                 CheckLog.Visible:=false;
                 end;
itDialError:  begin
              Label1.Caption:=MainForm.Languages.getString(285, MainForm.Options.Language);
              image1.Picture.Graphic:=gl.Glyph[GLID_Rit];
              NoteBook1.PageIndex:=3;
              label8.Caption:=IntToStr(FRasError.id);
              label13.Caption:=FRasError.Text;
              notebook1.Color:=$00E0E0E0;
              CheckLog.Caption:=MainForm.Languages.getString(302, MaiNForm.Options.Language);
              CheckLog.Checked:=MainForm.Options.Logging;
              CheckLog.Visible:=MainForm.Options.Logging;
              setRasTip(FRasError.id);
              end;
 end;
 Caption:=Label1.Caption;
end;

constructor TInfoForm.Create(AOwner: TComponent);
begin
 inherited create(Aowner);
 FInfoType:=itHint;
end;

constructor TInfoForm.CreateInfo(AOwner: TComponent; InfoType: tInfoType);
begin
 inherited create(Aowner);
 FInfoType:=infoType;
end;

procedure TInfoForm.TimerTimer(Sender: TObject);
begin
sStatusBar1.Panels[1].Text:=timeTOStr(time);
end;

procedure TInfoForm.FormShow(Sender: TObject);
var bit:TBitMap;
    x: Integer;
begin
  bit:=TBitMap.Create;
  bit.Width :=Image2.Width;
  bit.Height:=image2.Height;
  CreateGradientBitmap(150, bit);
  Image2.Picture.Bitmap:=bit;
  bit.Free;
  for x:=1 to Self.ComponentCount -1 do
   if TComponent(Self.Components[x]).Tag <> 0 then
    begin
    if (Self.COmponents[x] IS TLabel) then
     (self.Components[x] AS TLabel).Caption:=MainForm.Languages.getString(TComponent(Self.Components[x]).Tag, MainForm.Options.Language);
    if (Self.COmponents[x] IS TsSpeedButton) then
     (self.Components[x] AS TsSpeedButton).Caption:=MainForm.Languages.getString(TComponent(Self.Components[x]).Tag, MainForm.Options.Language);
    end;
  HideCaret(Memo1.Handle);
  setupForm;
  if FInfoType = itError then
   MessageBeep(MB_ICONEXCLAMATION);
end;

procedure TInfoForm.setRasTip(nr: Integer);
begin
 case Nr of
  ERROR_PORT_NOT_FOUND,ERROR_PORT_ALREADY_OPEN, ERROR_PORT_NOT_AVAILABLE,
  ERROR_INVALID_PORT_HANDLE: label10.Caption:=mainform.Languages.getString(292, MainForm.Options.Language);

  ERROR_DEVICE_DOES_NOT_EXIST,ERROR_DEVICETYPE_DOES_NOT_EXIST,
  ERROR_DEVICENAME_TOO_LONG,ERROR_DEVICENAME_NOT_FOUND,
  ERROR_UNKNOWN_DEVICE_TYPE,ERROR_READING_DEVICENAME,
  ERROR_READING_DEVICETYPE: label10.Caption:=mainform.Languages.getString(293, MainForm.Options.Language);

  ERROR_CANNOT_SET_PORT_INFO,
  ERROR_EVENT_INVALID, ERROR_OUT_OF_BUFFERS,
  ERROR_CANNOT_OPEN_PHONEBOOK, ERROR_CANNOT_LOAD_PHONEBOOK,
  ERROR_CORRUPT_PHONEBOOK, ERROR_CANNOT_LOAD_STRING,
  ERROR_KEY_NOT_FOUND, ERROR_UNKNOWN,
  ERROR_AUTH_INTERNAL, ERROR_FILE_COULD_NOT_BE_OPENED,
  ERROR_IN_COMMAND, ERROR_READING_DEFAULTOFF,
  ERROR_WRITING_DEFAULTOFF, ERROR_NOT_BINARY_MACRO,
  ERROR_STATE_MACHINES_NOT_STARTED, ERROR_ACCESSING_TCPCFGDLL,
  ERROR_TAPI_CONFIGURATION: label10.Caption:=mainform.Languages.getString(294, MainForm.Options.Language);

  ERROR_PORT_DISCONNECTED,ERROR_DISCONNECTION,
  ERROR_REMOTE_DISCONNECTION,
  ERROR_NO_CONNECTION: label10.Caption:=mainform.Languages.getString(295, MainForm.Options.Language);

  ERROR_HARDWARE_FAILURE,ERROR_WRONG_DEVICE_ATTACHED,
  ERROR_NO_RESPONSES,ERROR_DEVICE_NOT_READY,ERROR_PORT_OR_DEVICE,
  ERROR_NO_ANSWER,
  ERROR_NO_CARRIER: label10.Caption:=mainform.Languages.getString(296, MainForm.Options.Language);

  ERROR_ROUTE_NOT_AVAILABLE,ERROR_ROUTE_NOT_ALLOCATED,
  ERROR_REQUEST_TIMEOUT, ERROR_SERVER_OUT_OF_RESOURCES,
  ERROR_SERVER_GENERAL_NET_FAILURE,ERROR_SERVER_NOT_RESPONDING: label10.Caption:=mainform.Languages.getString(297, MainForm.Options.Language);

  ERROR_RESTRICTED_LOGON_HOURS,ERROR_ACCT_DISABLED,
  ERROR_PASSWD_EXPIRED,ERROR_NO_DIALIN_PERMISSION,
  ERROR_BAD_CALLBACK_NUMBER,ERROR_INVALID_AUTH_STATE,
  ERROR_ACCT_EXPIRED,ERROR_CHANGING_PASSWORD,
  ERROR_REMOTE_REQUIRES_ENCRYPTION,
  ERROR_INVALID_CALLBACK_NUMBER: label10.Caption:=mainform.Languages.getString(298, MainForm.Options.Language);

  ERROR_NO_DIALTONE: label10.Caption:=mainform.Languages.getString(299, MainForm.Options.Language);

  ERROR_AUTHENTICATION_FAILURE: label10.Caption:=mainform.Languages.getString(300, MainForm.Options.Language);

  ERROR_BAD_PHONE_NUMBER,ERROR_NO_LOCAL_ENCRYPTION,
  ERROR_NO_REMOTE_ENCRYPTION,
  ERROR_READING_SECTIONNAME,
  ERROR_BAD_USAGE_IN_INI_FILE,
  ERROR_MACRO_NOT_DEFINED,ERROR_MACRO_NOT_FOUND,
  ERROR_CANNOT_FIND_PHONEBOOK_ENTRY: label10.Caption:=mainform.Languages.getString(301, MainForm.Options.Language);


 else
  label10.Caption:='';
 end;
end;
procedure TInfoForm.sSpeedButton1Click(Sender: TObject);
begin
if self.FInfoType = itHint then
 begin
  if checkLog.Checked then
   ModalResult:=mrOK
  else
   ModalResult:=mrCancel;
 end
else
 self.ModalResult:=mrOK;
if (self.fInfoType = itDialError) or (self.fInfoType = itError) then
 if checkLog.checked then
  RasManForm.createLogEntry(leError, format(MainForm.Languages.getString(319, MainForm.Options.Language), [FRasError.Connection, inttostr(FRasError.id)]));
end;

end.
