unit ConnectionChange;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, StdCtrls, sCtrls;

type
  TConnectionChangeForm = class(TForm)
    Image2: TImage;
    labHelpStr: TLabel;
    Timer: TTimer;
    Label1: TLabel;
    labtimeout: TLabel;
    Bevel1: TBevel;
    labSeconds: TLabel;
    btnHelp: TsSpeedButton;
    btnCancel: TsSpeedButton;
    btnOk: TsSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FNewState: Boolean;
    FCounter, FCountDown: Integer;

    procedure setCountDown(new: Integer);
    { Private declarations }
  public
    property NewState: Boolean read FNewState     write FNewState;
    property CountDown : Integer read FCountDown  write SetCountDown;
    { Public declarations }
  end;

var
  ConnectionChangeForm: TConnectionChangeForm;

implementation

uses Main, ritconnection;

{$R *.DFM}
procedure TConnectionChangeForm.SetCountDown(new: Integer);
begin
FCountDown:=New;
FCounter:=FCountDown;
labtimeout.Caption:=IntToStr(New+1);
end;


procedure TConnectionChangeForm.FormShow(Sender: TObject);
begin
 labSeconds.Caption := MaiNForm.Languages.getString(234, MainForm.Options.Language);
 btnCancel.Caption  := MainForm.Languages.getString(184, MainForm.Options.Language);
 btnOk.Caption      := MainForm.Languages.getString(37, MainForm.Options.Language);
 Case FNewState of
  true:  begin
         Caption := Caption + ': '+MainForm.Languages.getString(231, MainFOrm.Options.Language);
         labHelpStr.Caption := MainForm.Languages.getString(230, MainForm.Options.Language);
         end;
  false: begin
         Caption := Caption + ': '+MainForm.Languages.getString(233, MainFOrm.Options.Language);
         labHelpStr.Caption := MainForm.Languages.getString(232, MainForm.Options.Language);
         end;
  end;
  Timer.Enabled := True;
end;

procedure TConnectionChangeForm.FormCreate(Sender: TObject);
begin
FCounter:=FCountDown;
end;

procedure TConnectionChangeForm.TimerTimer(Sender: TObject);
begin
labtimeout.Caption:=IntTOStr(FCounter);

if FCounter >0 then
 dec(FCounter)
else
 btnOk.Click;
end;

procedure TConnectionChangeForm.btnHelpClick(Sender: TObject);
begin
 timer.Enabled:=false;
 labtimeout.Caption:='--';
 Application.HelpContext(780);
end;

procedure TConnectionChangeForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key = vk_f1 then
  btnHelp.Click;
end;

end.
