unit Check;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Chkgroup, Registry, sCtrls, ComCtrls;

type
  TCheckFrom = class(TForm)
    Panel1: TPanel;
    btnOk: TsSpeedButton;
    btnCancel: TsSpeedButton;
    lvCheck: TListView;
    Panel2: TPanel;
    Bevel1: TBevel;
    Panel3: TPanel;
    lab: TLabel;
    Image1: TImage;
    Bevel2: TBevel;
    procedure CheckListResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Panel1Resize(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  CheckFrom: TCheckFrom;

implementation

uses Main, Info;

{$R *.DFM}

procedure TCheckFrom.CheckListResize(Sender: TObject);
begin
 btnOk.Left:=6;
 btnCancel.Left:=Panel1.Width-(btnCancel.width+6);
//          Space on form /   Width of btn/     \the space from the right border
end;

procedure TCheckFrom.FormShow(Sender: TObject);
var reg:TRegistry;
begin
MainForm.Languages.AutoChange(MainForm.Options.Language);
ShowHintw(REGKEY, MainForm.Languages.getString(123, MainForm.Options.Language), '181', MainForm.Languages.getString(122, MainForm.Options.Language), MainForm.Languages.getString(124, MainForm.Options.Language));

reg:=TRegistry.Create;
reg.RootKey:=HKEY_CURRENT_USER;
Reg.OpenKey('\Software\PH-Arts\RasInTask\Dialogs\CheckList', true);
if Reg.ValueExists('Width') then
  Width:=Reg.ReadInteger('Width');
if Reg.ValueExists('Height') then
  Height:=Reg.ReadInteger('Height');
Reg.CloseKey;
Reg.free;
end;

procedure TCheckFrom.FormClose(Sender: TObject; var Action: TCloseAction);
var reg:TRegistry;
begin
 reg:=TRegistry.Create;
 reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask\Dialogs\CheckList', true);
 Reg.WriteInteger('Width', Width);
 Reg.WriteInteger('Height', Height);
 reg.CloseKey;
 reg.Free;
end;

procedure TCheckFrom.Panel1Resize(Sender: TObject);
begin
btnCancel.Left:=self.Width - (btnCancel.width)-12;
end;

procedure TCheckFrom.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key = vk_f1 then Application.HelpContext(115);
end;

end.
