unit AutoDial;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Registry, RitLanguage, Buttons, sCtrls, ComCtrls, ImgList,
  StdCtrls;

type
  TAutoDialForm = class(TForm)
    Image1: TImage;
    Label2: TLabel;
    lvCons: TListView;
    Bevel1: TBevel;
    panelButtons: TPanel;
    sSpeedButton1: TsSpeedButton;
    sSpeedButton2: TsSpeedButton;
    sSpeedButton3: TsSpeedButton;
    timer: TTimer;
    Image2: TImage;
    Label1: TLabel;
    Label4: TLabel;
    panelTimeout: TPanel;
    Label5: TLabel;
    labsec: TLabel;
    Label3: TLabel;
    Bevel2: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure timerTimer(Sender: TObject);
    procedure sSpeedButton3Click(Sender: TObject);
    procedure lvConsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure FormShow(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    procedure CreateGradientBitmap(StartPos: Integer; var GBitmap: TBitmap);
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  AutoDialForm: TAutoDialForm;

implementation

uses Optionen, Main;

{$R *.DFM}

procedure TAutoDialForm.CreateGradientBitmap(StartPos: Integer; var GBitmap: TBitmap);
var
  I, Steps, iColorDepth: Integer;
  Bitmap: TBitmap;
  R, G, B, OldR, OldG, OldB: Real;
  StartC, EndC, OldC: TColor;
  dcd: HDC;
begin
  DCd := GetDC(GetDesktopWindow);
  iColorDepth := GetDeviceCaps(DCd, BITSPIXEL) * GetDeviceCaps(DCd, PLANES);
  Bitmap := TBitmap.Create;
  Bitmap.Width := GBitmap.Width;
  Bitmap.Height := GBitmap.Height;
  Bitmap.Canvas.Brush.Color := clBtnShadow;
  Bitmap.Canvas.FillRect(Rect(0, 0, Bitmap.Width, Bitmap.Height));
  if iColorDepth > 8 then begin
    Steps := Bitmap.Width - StartPos;
    StartC := ColorToRGB(clBtnShadow);
    EndC := ColorToRGB(clBtnFace);
    R := (GetRValue(EndC) - GetRValue(StartC)) / Steps;
    G := (GetGValue(EndC) - GetGValue(StartC)) / Steps;
    B := (GetBValue(EndC) - GetBValue(StartC)) / Steps;
    OldC := StartC;
    OldR := GetRValue(StartC);
    OldG := GetGValue(StartC);
    OldB := GetBValue(StartC);
    for I := 0 to Steps-1 do begin
      Bitmap.Canvas.Pen.Color := OldC;
      Bitmap.Canvas.Rectangle(I+StartPos, 0, I+StartPos+1, Bitmap.Height);
      OldR := OldR + R;
      OldG := OldG + G;
      OldB := OldB + B;
      if (OldR < 0) or (OldR > 255) then OldR := GetRValue(EndC);
      if (OldG < 0) or (OldG > 255) then OldG := GetGValue(EndC);
      if (OldB < 0) or (OldB > 255) then OldB := GetBValue(EndC);
      OldC := RGB(Round(OldR), Round(OldG), Round(OldB));
    end;
  end;
  GBitmap.Assign(Bitmap);
  Bitmap.Free;
end;

procedure TAutoDialForm.FormCreate(Sender: TObject);
var bit: TBitMap;
begin
bit:=TBitmap.Create;
bit.Width:=Image2.Width;
bit.Height:=Image2.Height;
createGradientBitmap(150,bit);
Image2.Picture.Bitmap:=bit;
bit.free;
end;

procedure TAutoDialForm.timerTimer(Sender: TObject);
begin
labSec.Caption:=IntToStr(strtoint(labsec.Caption)-1);
label5.Left:=labsec.Left+labsec.Width+labsec.Canvas.TextWidth(' ');
if labSec.Caption = '0' then
 begin
 timer.Enabled:=false;
 ssPeedButton1.Click;
 end;
end;

procedure TAutoDialForm.sSpeedButton3Click(Sender: TObject);
var Options:TOptionenForm;
    h:THandle;
begin
h:=FindWindow(nil, PChar(MainForm.Languages.getString(110, MainForm.Options.Language)));
if not isWindow(h) then
 begin
  Options:=TOptionenForm.Create(Application);
  try
   Options.ShowModal;
  finally
   Options.Free;
  end;
 end
else
 SetForegroundWindow(h);
end;

procedure TAutoDialForm.lvConsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
timer.Enabled:=false;
labsec.Caption:='--';
end;

procedure TAutoDialForm.FormShow(Sender: TObject);
begin
label5.Left:=labsec.Left+labsec.Width+labsec.Canvas.TextWidth(' ');
label2.Caption:=MainForm.Languages.getString(351, MainForm.Options.Language);
label4.Caption:=MainForm.Languages.getString(label4.tag, MainForm.Options.Language);
label3.Caption:=MainForm.Languages.getString(label3.tag, MainForm.Options.Language);
label5.Caption:=MainForm.Languages.getString(label5.tag, MainForm.Options.Language);
sSpeedButton3.Caption:=MainForm.Languages.getString(sSpeedButton3.tag, MainForm.Options.Language);
sSpeedButton2.Caption:=MainForm.Languages.getString(sSpeedButton2.tag, MainForm.Options.Language);
sSpeedButton1.Caption:=MainForm.Languages.getString(sSpeedButton1.tag, MainForm.Options.Language);
SetForegroundWindow(handle);
end;

procedure TAutoDialForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key = vk_f1 then
 begin
 timer.Enabled:=false;
 labsec.Caption:='--';
 Application.HelpContext(500);
 end
end;

end.
