unit VersForm;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
{$IFDEF WIN32}
  ComCtrls,
{$ENDIF}
  Dialogs, VersInfo, DsgnIntf, TypInfo, StdCtrls, Buttons, Grids;

type
{--- Version editor -----------------------------------------------------------}
{ double click opens the filename edit dialog }
{ right click gives two options - show the resources in a grid now }
{ and edit the filename }
  TVersionEditor = class(TDefaultEditor)
    procedure Edit; override;
    procedure EditProp (PropertyEditor : TPropertyEditor);
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

{--- filename property editor .. fileopen dialog box --------------------------}
  TVersionFilenameProperty = class (TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TVersionInfoForm = class(TForm)
    btnClose: TButton;
    VersionInfoResource: TVersionInfoResource;
    procedure FormCreate(Sender: TObject);
  private
    FVersionDisplay: {$IFDEF WIN32} TListView {$ELSE} TStringGrid {$ENDIF};
  public
  end;

implementation

{$R *.DFM}


procedure TVersionInfoForm.FormCreate(Sender: TObject);
begin
{$IFDEF WIN32}
  FVersionDisplay := TListView.Create(Self);
  with FVersionDisplay do
  begin
    Parent := Self;
    Left := 8;
    Top := 8;
    Width := 358;
    Height := 164;
    ColumnClick := False;
    with Columns.Add do
    begin
      Caption := 'Resource';
      Width := 85;
    end;
    with Columns.Add do
    begin
      Caption := 'Value';
      Width := 265;
    end;
    ReadOnly := True;
    TabOrder := 0;
    ViewStyle := vsReport;
  end;
  VersionInfoResource.VersionListView := FVersionDisplay;
{$ELSE}
  FVersionDisplay := TStringGrid.Create(Self);
  with FVersionDisplay do
  begin
    Parent := Self;
    Left := 8;
    Top := 8;
    Width := 358;
    Height := 164;
    ColCount := 2;
    FixedCols := 0;
    FixedRows := 0;
    Options := [goDrawFocusSelected, goColSizing, goRowSelect];
    TabOrder := 0;
    ColWidths[0] := 85;
    ColWidths[1] := 265;
  end;
  VersionInfoResource.VersionGrid := FVersionDisplay;
{$ENDIF}
end;


procedure TVersionFilenameProperty.Edit;
begin
  with TOpenDialog.Create(Application) do
  begin
    Filename := GetValue;
    Filter := 'Executables (*.exe)|*.exe|' +
              'Libraries (*.dll)|*.dll|' +
              'Packages (*.dpl)|*.dpl|' +
              'Drivers (*.drv,*.386,*.vxd)|*.drv;*.386;*.vxd|' +
              'Any file (*.*)|*.*';
    Options := Options + [ofPathMustExist, ofFileMustExist, ofHideReadOnly];
    try
      if Execute then
        SetValue(Filename)
    finally
      Free
    end
  end
end;

function TVersionFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog {$IFDEF WIN32}, paRevertable {$ENDIF}]
end;

procedure TVersionEditor.Edit;
var
  Components : TComponentList;
begin
  Components := TComponentList.Create;
  try
    Components.Add (Component);
    GetComponentProperties (Components, tkAny, Designer, EditProp)
  finally
    Components.Free
  end
end;

procedure TVersionEditor.EditProp (PropertyEditor : TPropertyEditor);
begin
  if PropertyEditor is TVersionFilenameProperty then
  begin
    TVersionFilenameProperty (PropertyEditor).Edit;
    Designer.Modified
  end
end;

procedure TVersionEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0 : with TVersionInfoForm.Create (Application) do
        try
          VersionInfoResource.Filename := TVersionInfoResource (Component).Filename;
          ShowModal
        finally
          free
        end;
    1 : Edit
  end
end;

function TVersionEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0 : Result := 'Show me';
    1 : Result := 'Set filename';
  end
end;

function TVersionEditor.GetVerbCount: Integer;
begin
  Result := 2
end;


end.

