program rascmd;

uses
  SysUTILS,
  Windows,
  ShellAPI,
  Classes, Messages,
  Registry,
  Rasext in '..\Rasext.pas';

{$R vi.RES}

type
  TRitFlag = (rfDontUseRit, rfNoConf, rfUser, rfPasswd, rfHelp);
  TRitFlags = set of TRitFlag;

  LpRasADParams = ^TRasADParams;
  TRasADParams = record
    dwSize: Longint;
    hwndOwner: THandle;
    dwFlags: Longint;
    xDlg,
    yDlg: Longint;
  end;
  pritADInfo = ^TritADInfo;
  TritADInfo = packed record
   phonebook : string[255];
   connection: string[255];
   res       : lpdword;
   params    : TRasADParams;
  end;



var user, pass, connection, connection2, command: string;
    RitFlags: TRitFlags;

procedure printoutSyntax;
begin
write(#9+'Syntax: rsascmd <command>');
writeln('');
writeln('');
writeln('Where command is one of the following:');
writeln('');
writeln('dial  : Dials the given connection');
writeln('list  : Lists the connections to a file');
writeln('delete: Deletes a connection');
writeln('setup : Ras-Config-Screen');
writeln('new   : Add a connection');
writeln('rename: rename a connection');
writeln('rit   : Does nothing but Launch RasInTask');
writeln('hangup: Terminates a connection');
writeln('');
writeln('Type "rascmd command /?" for more infos.');
end;


procedure Help;
begin
if command = 'dial' then
 begin
 writeln('Command: dial [parameter] ["]<connection>["]');
 writeln('Purpose: Dial');
 writeln('');
 writeln('Dials the given connection. You can override the.');
 writeln('saved username/password using the parameter /u= or');
 writeln('/p=.');
 writeln('');
 writeln('This command will use RasInTask to dial, unless it,');
 writeln('cannot be found or you enter the parameter /d.');
 end
else if command = 'hangup' then
 begin
 writeln('Command: hangup <connection>');
 writeln('Purpose: Launch RasInTask');
 writeln('');
 writeln('Terminates the given connection.');
 end
else if command = 'rit' then
 begin
 writeln('Command: rit');
 writeln('Purpose: Launch RasInTask');
 writeln('');
 writeln('RasInTask is a DialUp-Dialer for Windows9x and NT.');
 writeln('The Program you are using now was designed to work');
 writeln('together with RasInTask.');
 writeln('');
 writeln('The command rit will do noting but launch RasInTask,');
 writeln('if it is not already launched.');
 end
else if command = 'list' then
 begin
 writeln('Command: list <filename>');
 writeln('Purpose: Lists all the connections');
 writeln('');
 writeln('All installed connections will be written to');
 writeln('<filename>');
 end
else if command = 'delete' then
 begin
 writeln('Command: delete [/n] <connection>');
 writeln('Purpose: Delete the given connection');
 writeln('');
 writeln('Deltes the given Connection. Use /n to delete without');
 writeln('confirmation.');
 end
else if command = 'setup' then
 begin
 writeln('Command: setup [/d] <connection>');
 writeln('Purpose: Displays a screen for setting up a connection');
 writeln('');
 writeln('If you don''t use the switch /d, this command will');
 writeln('display the options-screen of RasInTask with the');
 writeln('connection preselected.');
 end
else if command = 'new' then
 begin
 writeln('Command: new');
 writeln('Purpose: Display the New-Wizzard');
 writeln('');
 writeln('No notes ;-)');
 end
else if command = 'rename' then
 begin
 writeln('Command: rename [/n] <old> <new>');
 writeln('Purpose: Rename <old> to <new>');
 writeln('');
 writeln('This will display no confirmation-message, if');
 writeln('/n is set');
 end
else
 printoutsyntax;
end;


function talkToRit(connection: string; command: dword): Boolean;
var Reg:Tregistry;
    dir: string;
    h: THandle;
    rec: TRitADInfo;
    cd: TCopyDataStruct;
    x: Byte;
begin
 writeln('Looking for RasInTask...');
 Result:=false;
 fillChar(rec, sizeof(rec), 0);
 dir:='';
 Reg:=TRegistry.Create;
 Reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask', true);
 if Reg.ValueExists('InstallPath') then
  dir:=Reg.ReadString('InstallPath');
 Reg.CloseKey;
 Reg.Free;
 if dir='' then
  exit;
 writeln('RasInTask found: '+dir+'RasInTask.exe');
 h:=FindWindow(nil,'RitMain');
 if not isWindow(h) then
  begin
    writeln('Launching RasInTask...');
    if ShellExecute(0,
                 'open',
                 PChar(dir+'RasInTask.exe'),
                 nil,
                 Pchar(dir),
                 sw_show) <=32 then exit
     else
       begin
        writeln('Waiting for RasInTask...');
        for x:=1 to 6 do
         begin
         sleep(500);
         h:=FindWindow(nil, 'RitMain');
         if isWindow(h) then break;
         end;
        if not isWindow(h) then exit;
       end
  end; //find window
//However the actual state of the System is, RasInTask is now running.
//Otherwise the function would already have exited.
rec.phonebook:='';
rec.connection:=connection;
cd.dwData:=command;
cd.cbData:=sizeof(rec);
cd.lpData:=@rec;
{
 The following for-loop is for working around the initializing-time
 of RasInTask. The mainprogram ignores messages, if the message was
 handeled once.
}
writeln('Talking to RasInTask...');
for x:=1 to 3 do
 begin
 sleep(1500);
 SendMessage(h,WM_COPYDATA, 0, lparam(@cd));
 end;
Result:=true;
end;


procedure launchrit;
var reg: TRegistry;
    dir: string;
begin
 writeln('Launching RasInTask... Please stand by.');
 Reg:=TRegistry.Create;
 Reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask', true);
 if Reg.ValueExists('InstallPath') then
  dir:=Reg.ReadString('InstallPath');
 Reg.CloseKey;
 Reg.Free;
 if dir = '' then exit;
 ShellExecute(hinstance,
              'open',
              PChar(dir+'RasInTask.exe'),
              nil,
              PChar(dir),
              SW_SHOW);
end;

procedure list;
var
  RASEntries: array[1..25] of TRasEntryName;
  BufferSize: Integer;
  EntryCount: Integer;
  rc:         longint;
  Entry:      integer;
  f: Textfile;
begin
AssignFile(f, connection);
Rewrite(f);
RASEntries[1].dwSize := SizeOf(TRasEntryName);
BufferSize := SizeOf(RASEntries);
rc := RASEnumEntries(nil, nil, @RASEntries, BufferSize, EntryCount);
 If rc = 0 then begin
   for Entry := 1 to EntryCount do
     writeln(f, RASEntries[Entry].szEntryName);
 end;
CloseFile(f);

end;

procedure setup;
begin
 writeln('Setting up connection '+connection);
 if rfDontUseRit in RitFlags then
  RasEditPhonebookEntry(hinstance,nil,PChar(connection))
 else
  if not talktorit(connection, 2) then
   begin
   writeln('Cannot talk to RasInTask. Applying /d-Switch...');
   RitFlags := RitFlags + [rfDontUseRit];
   setup;
   exit;
   end;
end;

procedure rename;
begin
if (connection = '') or (connection2 = '') then
 begin
 help;
 exit;
 end;
RasRenameEntry(nil,PChar(connection), PChar(connection2));
end;


procedure new;
begin
 RasCreatePhoneBookEntry(hinstance, nil);
end;

procedure printoutHeader;
begin
writeln('RasCMD 1.0 - Access the Windows Ras-Subsystem from');
writeln('the commandline!');
writeln('');
writeln('(C)opyright 1999 by Pilif <http://www.sen.ch/pilif/>');
writeln('');
end;


function parseParams: Boolean;
var n: Integer;
    t: string;
begin
Result:=false;
n:=1;
while n<= ParamCount() do
 begin
 if n=1 then
  begin
  if pos('/', ParamStr(n)) = 1 then
   begin
   Result:=false;
   exit;
   end;
  command := ParamStr(1);
  end
 else
  begin
  if (pos('/', ParamStr(n)) = 0) and (pos('/', ParamStr(n+1)) = 1) then
   begin
   Result:=false;
   exit;
   end;
  t:=lowerCase(ParamStr(n));
  if pos('/', ParamStr(n))>0 then
   begin
    case t[pos('/', t)+1] of
     '?': RitFlags := RitFlags + [rfHelp];
     'n': RitFlags := RitFlags + [rfNoConf];
     'd': RitFlags := RitFlags + [rfDontUseRit];
     'u': begin
          RitFlags := RitFlags + [rfUser];
          if (t[pos('/', t) + 2] = '=') or (t[pos('/', t) + 2] = '=') then
           user := copy(t,pos('/', t) + 3, Length(t))
          else
           user := copy(t,pos('/', t) + 2, Length(t));
          end;
     'p': begin
          RitFlags := RitFlags + [rfPasswd];
          if (t[pos('/', t) + 2] = '=') or (t[pos('/', t) + 2] = '=') then
           pass := copy(t,pos('/', t) + 3, Length(t))
          else
           pass := copy(t,pos('/', t) + 2, Length(t));
          end;
     else begin Result:=false; exit; end;
    end; //case
    end //if pos('/',....
   else
    begin
    connection:=ParamStr(n);
    connection2:=ParamStr(n+1);
    Exit;
    end;
  end;
 inc(n);
 Result:=true;
 end; //while
end;

procedure Delete;
begin
 RasDeleteEntry(nil, PChar(connection));
end;

procedure getRasOptions;
var fp         : LongBool;
    r          : Longint;
    dialparams : TRasDialParams;
begin
  FillChar(dialparams, SizeOf(TRasDialParams), 0);
  with dialparams do
    begin
    dwSize := Sizeof(TRasDialParams);
    StrPCopy(szEntryName, Connection);
    end;
  r := RasGetEntryDialParams(nil, dialparams, fp);
  if r = 0 then
    with dialparams do
      begin
      if user = '' then
       User := szUserName;
      if pass = '' then
        Pass := szPassword;
      end;
end;

{
 r := RasDial(nil,   // This field is ignored in Windows95
     nil,  // Phonebook: use default (not used on Win95)
     dialparams,
     1, // use callback function of type RASDIALFUNC1
     @RasCallback,   // callback function
     FHandle);
}
function makestar: string;
var x:Integer;
begin
Result:='';
 for x:=0 to Length(pass) do
  Result:=Result+'*';
end;
procedure dial;
var dialparams: TRasDialParams;
    rasconn: THrasConn;
begin
 if rfDontUseRit in RitFlags then
  if rfNoConf in RitFlags then
   begin
   getRasOptions;
   writeln('Connecting with '+connection+'...');
   writeln(Format('Using username: %s And Password: %s', [user, makestar]));
   FilLChar(dialparams, sizeof(TRasDialParams), 0);
   dialParams.dwSize:=sizeof(TRasDialParams);
   StrPCopy(dialparams.szEntryName, connection);
   StrPCopy(dialparams.szUserName, user);
   StrPCopy(dialparams.szPassword, pass);
   RasDial(nil,nil,dialparams,0,nil,rasconn);
   end
  else
   begin
   writeln('Launching Dial-GUI for '+connection+'...');
   ShellExecute(hinstance,
               'open',
               'rundll32.exe',
               PChar('Rnaui.dll,RnaDial '+ connection),
               nil,
               sw_show);
   end
 else  //useRit
  begin
   if rfNoConf in RitFlags then
     begin
      if not talktorit(connection,3) then
       begin
       writeln('Cannot talk to RasInTask. Applying /d-Switch...');
       RitFlags := RitFlags + [rfDontUseRit];
       dial;
       exit;
       end;
     end //if rfNoConf in RitFalgs
   else
     begin
     if not talktorit(connection,1) then
       begin
       writeln('Cannot talk to RasInTask. Applying /d-Switch...');
       RitFlags := RitFlags + [rfDontUseRit];
       dial;
       exit;
       end;
     end;
   end; //useRit;
end;

function GetHandle: THandle;
var
  bufsize: Longint;
  numEntries: Longint;
  x: Integer;
  entries: Array[1..100] of TRasConn;
begin
Result:=0;
entries[1].dwSize := SizeOf(TRasConn);
bufsize := SizeOf(TRasConn) * 100;
if RasEnumConnections(@entries[1], bufsize, numEntries) = 0 then
  begin
  if numEntries > 0 then
    begin
    for x := 1 to numEntries do
      if connection = entries[x].szEntryName then
        Result:=entries[x].HRasConn;
    end;
  end
end;

procedure hangup;
begin
if connection = '' then
 begin
 help;
 exit;
 end;
writeln('Terminating: '+connection);
RasHangUp(getHandle);
end;

procedure doAction;
begin
 if command = 'rit' then
  begin launchRit; end
 else if (command = 'rename') then
  begin rename; end
 else if (command = 'new') then
  begin new; end
 else if command = 'setup' then
  begin setup; end
 else if command = 'delete' then
  begin delete; end
 else if command = 'list' then
  begin list; end
 else if command = 'dial' then
  begin dial; end
 else if command = 'hangup' then
  begin hangup; end
 else
  printoutsyntax;
end;


begin
printoutHeader;
if not parseParams then
 begin
 PrintoutSyntax;
 exit;
 end;
if rfHelp in RitFlags then
 begin
 help;
 exit;
 end;
doAction;
end.

