library RitAutoDial;


uses
  SysUtils,
  Classes,
  Rasext,
  ShellAPI,
  Messages,
  Windows,
  registry;
{$R *.res}
type
  LpRasADParams = ^TRasADParams;
  TRasADParams = record
    dwSize: Longint;
    hwndOwner: THandle;
    dwFlags: Longint;
    xDlg,
    yDlg: Longint;
  end;

  pritADInfo = ^TritADInfo;
  TritADInfo = packed record
   phonebook : string[255];
   connection: string[255];
   res       : lpdword;
   params    : TRasADParams;
  end;

{
 The following procedure was introduced, since the API want's
 both Ansi and WindeChar-Functions and i don't like doing
 stuff twice
}
function HandleTheCall(pb, con: string; params:lpRasADPArams; retcode: lpdword):Boolean;
var Reg:Tregistry;
    force: boolean;
    dir: string;
    h: THandle;
    rec: TRitADInfo;
    cd: TCopyDataStruct;
begin
 dir:='';
 force:=false;
 Reg:=TRegistry.Create;
 Reg.RootKey:=HKEY_CURRENT_USER;
 Reg.OpenKey('\Software\PH-Arts\RasInTask', true);
 if Reg.ValueExists('InstallPath') then
  dir:=Reg.ReadString('InstallPath');
 Reg.CloseKey;
 if dir='' then
  begin
  Result:=false;
  exit;
  end;
 Result:=true;
 h:=FindWindow(nil,'RitMain');
 if not isWindow(h) then
  begin
  Reg.OpenKey('\Software\PH-Arts\RasInTask\Settings', true);
  if Reg.ValueExists('Force') then
   force:=Reg.ReadBool('Force');
  Reg.CloseKey;
  if force then
   begin
    if ShellExecute(0,
                 'open',
                 PChar(dir+'RasInTask.exe'),
                 nil,
                 Pchar(dir),
                 sw_show) <=32 then
     begin
      Result:=false;
      exit;
     end
    else
     begin
      sleep(1500);
      h:=FindWindow(nil, 'RitMain');
      if not isWindow(h) then
       begin
       Result:=false;
       exit;
       end;
     end;
   end
  else
   begin
   Result:=false;
   Exit;
   end;
  end; //find window
//However the actual state of the System is, RasInTask is now running.
//Otherwise the function would already have exited.
Reg.Free;
rec.phonebook:=pb;
rec.connection:=con;
if params <> nil then
 rec.params:=params^;
if retcode <> nil then
 rec.res:=retcode;
cd.cbData:=sizeof(rec);
cd.lpData:=@rec;
SendMessage(h,WM_COPYDATA, 0, lparam(@cd));
end;

function RitAutoDialA(lpszPhonebook, lpszEntry: PAnsiChar;
    lpAutoDialParams: lpRasADParams;
    lpdwRetCode: lpDWORD): Boolean; stdcall;
begin
 if SysUTILS.Win32Platform = VER_PLATFORM_WIN32_NT then
  Result:=HandleTheCall(string(lpszPhonebook), lpszEntry, lpAutoDialParams, lpdwretcode)
 else
  Result:=HandleTheCall('', lpszEntry, lpAutoDialParams, lpdwretcode);
 lpdwRetCode^:=0;
end;


function RitAutoDialW(lpszPhonebook, lpszEntry: PWideChar;
    lpAutoDialParams: lpRasADParams;
    lpdwRetCode: lpDWORD): Boolean; stdcall;

begin
 if SysUTILS.Win32Platform = VER_PLATFORM_WIN32_NT then
  Result:=HandleTheCall(widechartostring(lpszPhonebook), widechartostring(lpszEntry), lpAutoDialParams, lpdwretcode)
 else
  Result:=HandleTheCall('', widechartostring(lpszEntry), lpAutoDialParams, lpdwretcode);
end;

exports
 RitAutoDialW name 'RitAutoDialW',
 RitAutoDialA name 'RitAutoDialA',
 RitAutoDialA name 'RitAutoDial';

end.
