{$I DFS.INC}

unit SystemImageListReg;

interface

uses
  DsgnIntf;

type
  TSystemImageListEditor = class(TDefaultEditor)
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

uses
  SystemImageList, DFSAbout, Classes, Forms, Graphics, Dialogs;


procedure Register;
begin
  RegisterComponents('DFS', [TSystemImageList]);
  RegisterPropertyEditor(TypeInfo(TDFSVersion), TSystemImageList, 'Version',
     TDFSVersionProperty);
  RegisterComponentEditor(TSystemImageList, TSystemImageListEditor);
end;

{ TDFSStatusBarEditor }

procedure TSystemImageListEditor.Edit;
var
  SaveDlg: TSaveDialog;
  Stream: TStream;
begin
  SaveDlg := TSaveDialog.Create(Application);
  try
    SaveDlg.DefaultExt := 'bmp';
    SaveDlg.Filter := 'Bitmaps (*.bmp)|*.bmp|All Files (*.*)|*.*';
    SaveDlg.Options := [ofOverwritePrompt, ofHideReadOnly
       {$IFDEF DFS_COMPILER_4_UP} , ofEnableSizing {$ENDIF} , ofPathMustExist];
    SaveDlg.Title := 'Save ' + Component.Name + ' as...';

    if SaveDlg.Execute then
    begin
      Stream := TFileStream.Create(SaveDlg.Filename, fmCreate);
      try
        TSystemImageList(Component).SaveToStream(Stream);
      finally
        Stream.Free;
      end;
    end;
  finally
    SaveDlg.Free;
  end;
end;

procedure TSystemImageListEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 0 then  // We only have one verb...
    Edit;
end;

function TSystemImageListEditor.GetVerb(Index: Integer): string;
begin
  Result := 'Save &to bitmap...';
end;

function TSystemImageListEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

end.
