
//    Author:          Python (python@softhome.net)
//    Version:         0.0.1.0
//    LastModified:    2-17-2000
//    LatestVersion:   http://thunder.prohosting.com/~pytho/
//    Copyright (c) 1999, 2000 Python. All rights reserved

unit peExports;

interface

type
  { TpeExport }

  TpeExport = class(TObject)
  private
    FName: string;
    FID: Integer;
    FAddress: PChar;
  public
    property Name: string read FName;
    property ID: Integer read FID;
    property Address: PChar read FAddress;
  end;

  { TpeExportList }

  TpeExportList = class(TObject)
  private
    FList: Pointer;
    FCount: Integer;
    FPEFile: TObject;
    function GetExport(Index: Integer): TpeExport;
  public
    constructor Create(PEFile: TObject);
    destructor Destroy; override;
    function FindCaseInSens(const Name: string): Integer;
    function FindByAddress(Address: PChar): Integer;

    property Items[Index: Integer]: TpeExport read GetExport; default;
    property Count: Integer read FCount;
  end;

implementation

uses
  Classes, Windows, PEFile, SysUtils;

type
  TpeExports = array[0..MaxListSize] of TpeExport;

{ TpeExport }

{ TpeExportList }

constructor TpeExportList.Create(PEFile: TObject);
type
  PImageExportDirectory = ^TImageExportDirectory;
  TImageExportDirectory = packed record
    Characteristics: DWORD;
    TimeDateStamp: DWORD;
    MajorVersion: WORD;
    MinorVersion: WORD;
    NameRVA: DWORD;
    OrdinalBase: DWORD;
    EatEntries: DWORD;
    NamePointers: DWORD;
    AddressTable: DWORD;
    NamePointerTable: DWORD;
    OrdinalTable: DWORD;
  end;

var
  ExportDirectory: PImageExportDirectory;
  AddressTable: PChar;
  NameTable: PChar;
  OrdinalTable: PChar;
  I: Integer;
begin
  inherited Create;
  FPEFile := PEFile;

  if TPEFile(PEFile).NTHeader^.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress = 0 then
    Exit;

  // Load the exports for the export directory entry
  ExportDirectory := PImageExportDirectory(TPEFile(PEFile).FileBase +
      TPEFile(PEFile).NTHeader^.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress);

  AddressTable := TPEFile(PEFile).FileBase + ExportDirectory.AddressTable;
  NameTable := TPEFile(PEFile).FileBase + ExportDirectory.NamePointerTable;
  OrdinalTable := TPEFile(PEFile).FileBase + ExportDirectory.OrdinalTable;

  GetMem(FList, ExportDirectory.EatEntries * SizeOf(TpeExport));
  FCount := ExportDirectory.EatEntries;
  FillChar(FList^, FCount * SizeOf(TpeExport), 0);

  for I := 0 to ExportDirectory.EatEntries -1 do
  begin
    // Create a new export directory.
    TpeExports(FList^)[I] := TpeExport.Create;
    with TpeExports(FList^)[I] do
    begin
      // Save the export address.
      FName := TPEFile(PEFile).FileBase + PDWord(NameTable + I * 4)^;
      FID := ExportDirectory.OrdinalBase + Word(Pointer(OrdinalTable + I * 2)^);
      FAddress := TPEFile(PEFile).FileBase + PDword(AddressTable + (FID - Integer(ExportDirectory.OrdinalBase)) * 4)^;
    end;
  end;

end;

destructor TpeExportList.Destroy;
begin
  FreeMem(FList, SizeOf(TpeExport) * FCount);
  inherited Destroy;
end;

function TpeExportList.FindCaseInSens(const Name: string): Integer;
begin
  for Result := 0 to Count -1 do
    if AnsiCompareText(Items[Result].Name, Name) = 0 then
      Exit;
  Result := -1;
end;

function TpeExportList.FindByAddress(Address: PChar): Integer;
begin
  for Result := 0 to Count -1 do
    if Items[Result].Address = Address then
      Exit;
  Result := -1;
end;

function TpeExportList.GetExport(Index: Integer): TpeExport;
begin
  Result := TpeExports(FList^)[Index];
end;

end.
