unit dcTypeIntf;

interface

uses
  TypInfo, Classes, Procs;

type
  // TypeCast the IdcType to the appropriate interface to get more information.

  { IdcType }

  // EnhTypeKind has to extra items for untyped integer and untyped strings
  // (const which doesn't say which type the realy are).
  TEnhTypeKind = (etkUnknown, etkInteger, etkChar, etkEnumeration, etkFloat,
    etkString, etkSet, etkClass, etkMethod, etkWChar, etkLString, etkWString,
    etkVariant, etkArray, etkRecord, etkInterface, etkInt64, etkDynArray,
    etkUTInteger, etkUTString, etkPointer);
  TEnhTypeKinds = set of TEnhTypeKind;
  TTypeSize = (ts0, ts1, ts2, ts4, ts6, ts8, ts12, ts16, tsComplex);
  TTypeSizes = set of TTypeSize;

  IdcType = interface(IUnknown)
  ['{C30AE741-594A-11D3-B62D-F0074AC10000}']
    function GetPossTypeKinds: TEnhTypeKinds;
    procedure SetPossTypeKinds(Value: TEnhTypeKinds);
    function GetTypeKind: TEnhTypeKind;
    function GetPossSizes: TTypeSizes;
    procedure SetPossSizes(Value: TTypeSizes);
    property PossTypeKinds: TEnhTypeKinds read GetPossTypeKinds write SetPossTypeKinds;
    property TypeKind: TEnhTypeKind read GetTypeKind;
    property PossSizes: TTypeSizes read GetPossSizes write SetPossSizes;
  end;

  { IdcOrdType }
  IdcOrdType = interface(IUnknown)
  ['{7E32DC21-581B-11D3-B62D-30014AC10000}']
    function GetOrdType: TOrdType;
    procedure SetOrdType(Value: TOrdType);
    property OrdType: TOrdType read GetOrdType write SetOrdType;
  end;

  { IdcNonSetOrdType }
  IdcNonSetOrdType = interface(IUnknown)
  ['{AD06A9E0-581C-11D3-B62D-30014AC10000}']
    function GetMinValue: Integer;
    procedure SetMinValue(Value: Integer);
    function GetMaxValue: Integer;
    procedure SetMaxValue(Value: Integer);
    property MinValue: Integer read GetMinValue write SetMinValue;
    property MaxValue: Integer read GetMaxValue write SetMaxValue;
  end;

  { IdcEnumationType }
  IdcEnumerationType = interface(IUnknown)
  ['{AD06A9E1-581C-11D3-B62D-30014AC10000}']
    function GetBaseType: IdcType;
    procedure SetBaseType(Value: IdcType);
    function GetNameList: TStrings;
    procedure SetNameList(Value: TStrings);
    property BaseType: IdcType read GetBaseType write SetBaseType;
    property NameList: TStrings read GetNameList write SetNameList;
  end;

  { IdcSetOrdType }
  IdcSetOrdType = interface(IUnknown)
  ['{AD06A9E7-581C-11D3-B62D-30014AC10000}']
    function GetCompType: IdcType;
    procedure SetCompType(Value: IdcType);
    property CompType: IdcType read GetCompType write SetCompType;
  end;

  { IdcFloatType }
  IdcFloatType = interface(IUnknown)
  ['{AD06A9E8-581C-11D3-B62D-30014AC10000}']
    function GetFloatType: TFloatType;
    procedure SetFloatType(Value: TFloatType);
    property FloatType: TFloatType read GetFloatType write SetFloatType;
  end;

  { IdcStringType }
  IdcStringType = interface(IUnknown)
  ['{AD06A9E8-581C-11D3-B62D-30014AC10000}']
    function GetMaxLength: Integer;
    procedure SetMaxLength(Value: Integer);
    property MaxLength: Integer read GetMaxLength write SetMaxLength;
  end;

  { IdcClassType }
  IdcClassType = interface(IUnknown)
  ['{AD06A9E9-581C-11D3-B62D-30014AC10000}']
    function GetAClass: TClassInfo;
    procedure SetAClass(Value: TClassInfo);
    property AClass: TClassInfo read GetAClass write SetAClass;
  end;

  { IdcInterfaceType }
  IdcInterfaceType = interface(IUnknown)
  ['{AD06A9EA-581C-11D3-B62D-30014AC10000}']
    function GetInterface: TInterface;
    procedure SetInterface(Value: TInterface);
    property AInterface: TInterface read GetInterface write SetInterface;
  end;

  { IdcInt64Type }
  IdcInt64Type = interface(IUnknown)
  ['{AD06A9EB-581C-11D3-B62D-30014AC10000}']
    function GetMinValue: Int64;
    procedure SetMinValue(Value: Int64);
    function GetMaxValue: Int64;
    procedure SetMaxValue(Value: Int64);
    property MinValue: Int64 read GetMinValue write SetMinValue;
    property MaxValue: Int64 read GetMaxValue write SetMaxValue;
  end;

  { IdcRecordType }

  TdcRecordField = record
    Offset: Integer;
    FieldType: IdcType;
  end;

  IdcRecordType = interface(IUnknown)
  ['{AD06A9ED-581C-11D3-B62D-30014AC10000}']
    function GetCount: Integer;
    procedure SetCount(Value: Integer);
    function GetField(Index: Integer): TdcRecordField;
    procedure SetField(Index: Integer; Value: TdcRecordField);
    property Count: Integer read GetCount write SetCount;
    property Fields[Index: Integer]: TdcRecordField read GetField write SetField;
  end;

  { IdcDynArrayType }
  IdcDynArrayType = interface(IUnknown)
  ['{AD06A9EE-581C-11D3-B62D-30014AC10000}']
    function GetElementType: IdcType;
    procedure SetElementType(Value: IdcType);
    property ElementType: IdcType read GetElementType write SetElementType;
  end;

  { IdcArrayType }

  IdcArrayType = interface(IUnknown)
  ['{C30AE740-594A-11D3-B62D-F0074AC10000}']
    function GetCount: Integer;
    procedure SetCount(Value: Integer);
    function GetElementType: IdcType;
    procedure SetElementType(Value: IdcType);
    property Count: Integer read GetCount write SetCount;
    property ElementType: IdcType read GetElementType write SetElementType;
  end;

function CreateType: IdcType;

implementation

uses
  dcType;

function CreateType: IdcType;
begin
  Result := TdcType.Create;
end;

end.
