unit dcThrVar;

interface

uses
  dcDecomps;

type
  { TThreadVar }

  TThreadVar = class(TDecompItem)
  private
    FVarSize: Integer;
  public
    function GetDeclaration: string;
    procedure LoadThreadVar;
    property VarSize: Integer read FVarSize write FVarSize;
  end;

implementation

uses
  PEFile, PEFileClass, TypeInfoUtils, SysUtils, Windows;
  
{ TThreadVar }

function TThreadVar.GetDeclaration: string;
begin
  Result := Format('ThreadVar1: %s;', [GetSizeName(VarSize)]);
end;

procedure TThreadVar.LoadThreadVar;
var
  I: Integer;
const
  SizeOfSysThrVar = 8;
begin
  // Find the TLSObject.
  Address := PEFileClass.EntryPoint;
  Size := 0;
  for I := 0 to High(PEFileClass.Objects) do
    if PEFileClass.Objects[I].ObjectName = '.tls' then
    begin
      VarSize := PEFileClass.Objects[I].VirtualSize - SizeOfSysThrVar;
      // Destroy yourself if there is no threadvar.
      if VarSize = 0 then
        Free;
      exit;
    end;
  Free;
end;

end.
