unit dcNTInfoTypes;

interface

uses
  Classes, dcDecomps;

type
  { TNoTIfnoType }

  TNoTInfoType = class(TDecompItem)
  private
    FName: string;
    FDefenition: string;
  public
    property Name: string read FName write FName;
    property Defenition: string read FDefenition write FDefenition;
  end;

  { TNoTInfoTypes }

  TNoTInfoTypes = class(TDecompCollection)
  private
    function GetItem(Index: Integer): TNoTInfoType;
    procedure SetItem(Index: Integer; Value: TNoTInfoType);
  public
    function IndexOfName(Name: string): Integer;
    property Items[Index: Integer]: TNoTInfoType read GetItem write SetItem; default;
  end;

implementation

{ TNoTInfoTypes }

function TNoTInfoTypes.GetItem(Index: Integer): TNoTInfoType;
begin
  Result := TNoTInfoType(inherited GetItem(Index));
end;

procedure TNoTInfoTypes.SetItem(Index: Integer; Value: TNoTInfoType);
begin
  inherited SetItem(Index, Value);
end;

function TNoTInfoTypes.IndexOfName(Name: string): Integer;
begin
  for Result := 0 to Count -1 do
    if Items[Result].Name = Name then
      Exit;
  Result := -1;
end;

end.

