unit dcInterfaces;

interface

uses
  PEFileClass;

type
  IdcUnit = interface;

  { IdcItem }

  TDCItemType = (itProc, itUnit, itClass, itTypeInfo);
  
  IdcDCItem = interface(IUnknown)
    ['{502BD0A0-561F-11D3-B62D-D0224AC10000}']
    function GetPEFileClass: TPEFileClass;
    function GetDCItemType: TDCItemType;
    // properties    
    property PEFile: TPEFileClass read GetPEFileClass;
    property DCItemType: TDCItemType read GetDCItemType;
  end;

  { IdcSection Item }

  IdcSectionItem = interface(IdcDCItem)
    ['{502BD0A1-561F-11D3-B62D-D0224AC10000}']
    function GetAUnit: IdcUnit;
    function GetAddress: PChar;
    function GetSize: Integer;
    // properties
    property AUnit: IdcUnit read GetAUnit;
    property Address: PChar read GetAddress;
    property Size: Integer read GetSize;
  end;

  { IdcUnit }

  IdcUnit = interface(IdcDCItem)
    ['{502BD0A2-561F-11D3-B62D-D0224AC10000}']
  end;

implementation

end.
 