unit dcDebug;

interface

uses
  Dialogs;

procedure SendDebugEx(const Msg: String; MType:TMsgDlgType);
procedure SendDebug(const Msg: String);

implementation

uses
  {$IFDEF DebugView}MainForm,{$ENDIF}
   SysUtils, Forms, StatusForm, Controls;

{ SendDebug }

procedure SendDebugEx(const Msg: String; MType:TMsgDlgType);
begin
  if MType = mtError then
  begin
    SendDebug('***************' + Msg);
    if MessageDlg('Error debug string: ' + Msg, mtError, [mbIgnore, mbAbort], 0) = mrAbort then
      raise Exception.Create('Error debug string: ' + Msg);
  end
  else
    SendDebug(Msg);
end;

procedure SendDebug(const Msg: String);
begin
  DecompThread.AddDebug(Msg);
end;

end.
