unit dcCondition;

interface

uses
  DisAsmX, dcInstrSource;
  
type
  { ICondition }

  ICondition = interface(IUnknown)
  end;

  { IMonoCond }

  TMonoCondType = (mctNot);

  IMonoCond = interface(ICondition)
    function GetCond: ICondition;
    function GetCondType: TMonoCondType;

    property CondType: TMonoCondType read GetCondType;
    property Cond: ICondition read GetCond;
  end;

  { IDuoCond }

  TDuoCondType = (dctAnd, dctOr, dctXOr);

  IDuoCond = interface(ICondition)
    function GetCond1: ICondition;
    function GetCond2: ICondition;
    function GetCondType: TDuoCondType;

    property CondType: TDuoCondType read GetCondType;
    property Cond1: ICondition read GetCond1;
    property Cond2: ICondition read GetCond2;
  end;

  { IConstCond }

  IConstCond = interface(ICondition)
    function GetValue: Boolean;
    
    property Value: Boolean read GetValue;
  end;

  { IFlagCond }

  IFlagCon = interface(ICondition)
    function GetFlag: TFlag;

    property Flag: TFlag read GetFlag;
  end;

  { IDuoSourceCond }

  TDuoSrcCondType = (dsctEqual, dsctLessThan, dsctGreatereThan);

  IDuoSourceCond = interface(ICondition)
    function GetSource1: IInstrSource;
    function GetSource2: IInstrSource;
    function GetCondType: TDuoSrcCondType;

    property Source1: IInstrSource read GetSource1;
    property Source2: IInstrSource read GetSource2;
    property CondType: TDuoSrcCondType read GetCondType;
  end;

implementation

end.
